

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_GetMediaByOracleBackupPiece.sp] ---------- 

-- Script to get job/media details for Oracle Backup piece.
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_GetMediaByOracleBackupPiece <<<'

IF EXISTS (select * from sysobjects where name='QS_GetMediaByOracleBackupPiece')
	drop procedure QS_GetMediaByOracleBackupPiece
IF EXISTS (select * from GxQscripts where name='QS_GetMediaByOracleBackupPiece')
	delete from GxQscripts where name = 'QS_GetMediaByOracleBackupPiece'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetMediaByOracleBackupPiece')
	delete from GXDBVersions where aliasname = 'QS_GetMediaByOracleBackupPiece'
GO
print '... Creating Procedure: QS_GetMediaByOracleBackupPiece'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_GetMediaByOracleBackupPiece
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @inSPName NVARCHAR(144) = N'%s',
  @inBackupPieceName NVARCHAR(2048) = N'%s'
AS
SET NOCOUNT ON
SELECT      DISTINCT Q.jobId, @inBackupPieceName as BackupPiece,Q.BackupLevel,
                        Q.SPName as [Storage Policy], Q.CopyName as Copy ,Q.LibraryName,
                        (CASE WHEN Q.RecordingFormatId = 10001 THEN DC.Folder ELSE Q.BarCode END) AS Media
FROM  (SELECT  DISTINCT V.MediaSideId, V.RecordingFormatId , M.MediaId, AG.name SPName, AGC.name CopyName,AF.jobId,M.BarCode, L.AliasName AS LibraryName,
                                    CASE  AF.backupLevel
                                                WHEN 1 THEN 'Full'
                                                WHEN 2 THEN 'Incremental'
                                                WHEN 4 THEN 'Differential'
                                                WHEN 64 THEN 'Synthetic Full'
                                                WHEN 256 THEN 'Transaction Log w. NoTruncate'
                                                ELSE ''
                                    END AS BackupLevel
                        FROM  archGroup AG, archGroupCopy AGC, archFile AF,
                                    archFileCopy AFC, archChunkMapping ACM, archChunk AC, MMVolume V, MMMedia M, MMLibrary L
                        WHERE AG.id = AGC.archGroupId AND AF.archGroupId = AG.id
									AND AGC.type <> 5
                                    AND ACM.archCopyId = AGC.id
                                    AND ACM.archFileId = AFC.archFileId AND ACM.archCopyId = AFC.archCopyId AND ACM.commCellId = AFC.commCellId
                                    AND ACM.archChunkId = AC.id AND ACM.chunkCommCellId = AC.commCellId
                                    AND AC.volumeId = V.VolumeId AND M.MediaId = V.MediaId
                                    AND M.LibraryId = L.LibraryId
                                    AND AFC.isValid = 1 AND AFC.flags & 256 = 0 AND ACM.flags & 256 = 0 AND AC.flags & 256 = 0 AND AF.isValid = 1
                                    AND AG.name = @inSPName
                                    AND AF.name LIKE '%' + @inBackupPieceName + '%'
            ) AS Q
            LEFT OUTER JOIN MMMountPath MP
					ON Q.MediaSideId = MP.MediaSideId
            LEFT OUTER JOIN MMMountPathToStorageDevice AS MPSD
					ON  MP.MountPathId = MPSD.MountPathId
            LEFT OUTER JOIN MMDeviceController AS DC
					ON MPSD.DeviceId = DC.DeviceId
ORDER BY Q.SPName, Q.CopyName,jobId,LibraryName,Media
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GetMediaByOracleBackupPiece')
	delete from GxQscripts where name = 'QS_GetMediaByOracleBackupPiece'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetMediaByOracleBackupPiece')
	delete from GXDBVersions where aliasname = 'QS_GetMediaByOracleBackupPiece'
GO

insert into GXDBVersions values(2, 'QS_GetMediaByOracleBackupPiece',  '00000000000000000000', 'QS_GetMediaByOracleBackupPiece', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_GetMediaByOracleBackupPiece',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn QS_GetMediaByOracleBackupPiece  
'
 + CHAR(10) + '-- 	Returns a list of media that has valid jobs for the given backup piece and on the given storage policy.'
)
GO

