

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_GetMSSQLcredentials.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_GetMSSQLcredentials')
BEGIN
	print '>>> Drop Stored Procedure: QS_GetMSSQLcredentials <<<'
	drop procedure QS_GetMSSQLcredentials
END
IF EXISTS (select * from GxQscripts where name='QS_GetMSSQLcredentials')
	delete from GxQscripts where name = 'QS_GetMSSQLcredentials'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetMSSQLcredentials')
	delete from GXDBVersions where aliasname = 'QS_GetMSSQLcredentials'
GO
print '... Creating Procedure: QS_GetMSSQLcredentials'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_GetMSSQLcredentials
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @PARAM1 varchar(512) = '%s'
AS
Set NOCOUNT ON
-------------------------------------------
-- FOLLOWING ARE FILLED IN FROM COMMAND  --
-- .. LINE, IN THIS ORDER! 				 --
-------------------------------------------
--DECLARE @PARAM1     	varchar(512)
--DECLARE @PARAM2     	varchar(512)
--SET @PARAM1 = '%s'					-- c=clientName, allclients
--SET @PARAM1='allclients'
---- Convenience Definitions    -----------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'GetMSSQLcredentials'
DECLARE @allClientsOption		varchar(32)
set		@allClientsOption		= 'allClients'
DECLARE @oneClientOption		varchar(10)
SET		@oneClientOption		='c='
DECLARE @useConnect             varchar (30)
SET     @useConnect             = 'MSSQL username'
DECLARE @usePassword            varchar(30)
SET     @usePassword            = 'MSSQL password'
DECLARE @NoParameter			varchar(10)
SET		@NoParameter			='%'						-- Get Around QScript Parameter
SET		@NoParameter            =@NoParameter + 's'			-- .. Substitution
-------- Local Variables    -------------
DECLARE @lastError				integer
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
SET     @lastError  = 0									-- Be optimistic
DECLARE @clientId				integer
SET		@clientId				=0
DECLARE @currentUserName        nvarchar(512)
DECLARE @currentPassword        nvarchar(512)
DECLARE @currentClientName      nvarchar(512)
DECLARE @currentDomainName      nvarchar(512)
DECLARE @componentNameId        int
---------------------------------------
-- SET FOR STANDALONE DEBUGGING ONLY --
---------------------------------------
---SET @PARAM1 =  'c=jewelfish_cn'
---SET @PARAM1 =  'allclients'
--=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
--- CHECK IF PARAMETERS SPECIFIED CORRECTLY  ---
--=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
---------------------------------------
---  SPECIFIC CLIENT OR ALL CLIENTS ---
---------------------------------------
IF @PARAM1 = @allClientsOption
	SET @clientId =0
ELSE
BEGIN
	IF SUBSTRING(@PARAM1, 1, 2) = @oneClientOption
	BEGIN
		set @clientId= ISNULL((SELECT id from APP_CLIENT WHERE name = (SELECT SUBSTRING(@PARAM1, 3, LEN(@PARAM1)-2))),0)
		IF @clientId = 0
		BEGIN
			SET @localErrorMsg = 'Error.  Client ['+ (SELECT SUBSTRING(@PARAM1, 3, LEN(@PARAM1)-2)) + '] Does not exist.'
			Set @lastError = 1
			goto   ARGS_ERROR
		END
	END
	ELSE
	BEGIN
		SET @localErrorMsg = 'Error.  Parameter1 must be specified as allclients or c=clientName.'
		Set @lastError = 1
		goto   ARGS_ERROR
	END
END
--=====================================================
-- DONE PROCESSING CMD ARGS, START THINGS GOING:	 ==
--=====================================================
PRINT @scriptName + ' Started at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: ( ' + @PARAM1
--------------------------------------------------------------------------
--- ALL COMMAND LINE ARGS PROCESSED, DO SOME WORK!					------
--------------------------------------------------------------------------
BEGIN TRAN
BEGIN TRY
-- MS SQL SERVER --
	IF object_id('tempdb.dbo.MsSqlCredentialsList') is not null DROP TABLE #MsSqlCredentialsList
	CREATE TABLE #MsSqlCredentialsList
	(
	clientName nvarchar(512),
	--domainName nvarchar(512)
	userName nvarchar(512),
	encryptedPassword nvarchar(512)
	)
	 IF @clientId = 0
			DECLARE GetUserNameList CURSOR FOR
			SELECT DISTINCT componentNameId,AttrVal from APP_INSTANCEPROP where AttrName=@useConnect AND componentNameId in (SELECT DISTINCT instance FROM APP_APPLICATION WHERE appTypeId in (4, 16, 70, 81))
		ELSE
          	DECLARE GetUserNameList CURSOR FOR
			SELECT DISTINCT componentNameId,AttrVal from APP_INSTANCEPROP where AttrName=@useConnect AND componentNameId in (SELECT DISTINCT instance FROM APP_APPLICATION WHERE clientID = @clientId AND appTypeId in (4, 16, 70, 81))
		OPEN GetUserNameList
			FETCH GetUserNameList INTO @componentNameId, @currentUserName
			WHILE @@FETCH_STATUS = 0
			BEGIN
				SELECT @currentPassword = dbo.pswConvertV5ToV3(AttrVal) from  APP_INSTANCEPROP where componentNameId = @componentNameId and AttrName = @usePassword
				SELECT @currentClientName = name from APP_Client,APP_APPLICATION where APP_APPLICATION.instance = @componentNameId AND APP_APPLICATION.clientId=APP_Client.id
				--SELECT @domainName = AttrVal from  APP_INSTANCEPROP where componentNameId = @componentNameId and AttrName = @CV_ORACLE_DOMAIN_NAME
				INSERT INTO #MsSqlCredentialsList (clientName, userName, encryptedPassword) VALUES(@currentClientName, @currentUserName , @currentPassword)
				FETCH GetUserNameList INTO @componentNameId, @currentUserName
			END
		CLOSE GetUserNameList
		DEALLOCATE GetUserNameList
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
BEGIN
    set @lastError = ERROR_NUMBER()
    set @localErrorMsg = 'Problems Getting Password/Username ' +ERROR_MESSAGE()
END
END CATCH
----------------------------------------------------
-------   ALL DONE, KEEP OR DESCARD CHANGES   ------
----------------------------------------------------
ALL_DONE:
IF (@lastError  = 0)
	commit Tran
ELSE
	rollback Tran
SELECT clientName,userName,encryptedPassword from #MsSqlCredentialsList
DROP TABLE #MsSqlCredentialsList
ARGS_ERROR:
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: ( ' + +REPLACE(@PARAM1, @NoParameter, '[]')
         + '). Exit Code(' +convert(varchar(2), @lastError) + ').'
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GetMSSQLcredentials')
	delete from GxQscripts where name = 'QS_GetMSSQLcredentials'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetMSSQLcredentials')
	delete from GXDBVersions where aliasname = 'QS_GetMSSQLcredentials'
GO

insert into GXDBVersions values(2, 'QS_GetMSSQLcredentials',  '00000000000000000000', 'QS_GetMSSQLcredentials', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_GetMSSQLcredentials',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	Qscript -f GetMSSQLcredentials -i c=clientName|allclients  
'
 + CHAR(10) + '--   script_name : GetMSSQLcredentials'
)
GO

