

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_GetLicenseInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_GetLicenseInfo')
BEGIN
	print '>>> Drop Stored Procedure: QS_GetLicenseInfo <<<'
	drop procedure QS_GetLicenseInfo
END
IF EXISTS (select * from GxQscripts where name='QS_GetLicenseInfo')
	delete from GxQscripts where name = 'QS_GetLicenseInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetLicenseInfo')
	delete from GXDBVersions where aliasname = 'QS_GetLicenseInfo'
GO
print '... Creating Procedure: QS_GetLicenseInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_GetLicenseInfo
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @licName varchar(1024) = '%s'
AS
SET NOCOUNT ON
--DECLARE @licName	varchar(1024)
DECLARE @evalFld	varchar(1024)
DECLARE @permFld	varchar(1024)
DECLARE @isAllLic	integer
DECLARE @licTypeId	integer
DECLARE @evalTotal	integer
DECLARE @evalUsed	integer
DECLARE @permTotal	integer
DECLARE @permUsed	integer
DECLARE @retLicData	TABLE (	licName	varchar(1024),
				licTypeId INTEGER,
				TotalPermLicensesIssued INTEGER,
				FreePermLicensesAvailable INTEGER,
				TotalEvalLicensesIssued INTEGER,
				FreeEvalLicensesAvailable INTEGER	)
SET @evalTotal	= 0
SET @evalUsed	= 0
SET @permTotal	= 0
SET @permUsed	= 0
--SET @licName = '%s'
SET @isAllLic = (CASE @licName WHEN '%s' THEN 1 WHEN 'ALL' THEN 1 ELSE 0 END)
IF @isAllLic = 0
BEGIN
	SET @licTypeId = ISNULL((SELECT TOP 1 id FROM simLicAppTypeV2 WHERE short_name = @licName), 0)
	IF @licTypeId = 0
	BEGIN
		RAISERROR ('Invalid input license name', 16, 1)
		RETURN
	END
	IF NOT EXISTS (SELECT * FROM licAAL WHERE simLicAppTypeId = @licTypeId)
	BEGIN
		RAISERROR ('The license is not avaliable', 16, 1)
		RETURN
	END
	SELECT @evalFld = RTRIM(eval_fld1), @permFld = RTRIM(perm_fld1) FROM licAAL WHERE simLicAppTypeId = @licTypeId
	IF len(@evalFld) > 0
		EXEC dbo.xp_getAALInfo @evalFld, @evalTotal OUTPUT, @evalUsed OUTPUT
	IF len(@permFld) > 0
		EXEC dbo.xp_getAALInfo @permFld, @permTotal OUTPUT, @permUsed OUTPUT
	INSERT INTO @retLicData
	SELECT @licName, @licTypeId, @permTotal, @permTotal - @permUsed, @evalTotal, @evalTotal - @evalUsed
END
ELSE
BEGIN
	DECLARE licList CURSOR FOR
 		SELECT DISTINCT simLicAppTypeId, RTRIM(eval_fld1), RTRIM(perm_fld1) FROM licAAL WHERE simLicAppTypeId < 1000
	OPEN licList
	FETCH NEXT FROM licList INTO @licTypeId, @evalFld, @permFld
	WHILE @@FETCH_STATUS <> -1
	BEGIN
		SET @evalTotal	= 0
		SET @evalUsed	= 0
		SET @permTotal	= 0
		SET @permUsed	= 0
		IF len(@evalFld) > 0
			EXEC dbo.xp_getAALInfo @evalFld, @evalTotal OUTPUT, @evalUsed OUTPUT
		IF len(@permFld) > 0
			EXEC dbo.xp_getAALInfo @permFld, @permTotal OUTPUT, @permUsed OUTPUT
		INSERT INTO @retLicData
		SELECT '', @licTypeId, @permTotal, @permTotal - @permUsed, @evalTotal, @evalTotal - @evalUsed
		FETCH NEXT FROM licList INTO @licTypeId, @evalFld, @permFld
	END
	CLOSE licList
	DEALLOCATE licList
END
SELECT	licName = (CASE @isAllLic WHEN 1 THEN (SELECT short_name FROM simLicAppTypeV2 WHERE id = licTypeId) ELSE @licName END),
		TotalPermLicensesIssued,
		FreePermLicensesAvailable,
		TotalEvalLicensesIssued,
		FreeEvalLicensesAvailable
FROM	@retLicData
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GetLicenseInfo')
	delete from GxQscripts where name = 'QS_GetLicenseInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetLicenseInfo')
	delete from GXDBVersions where aliasname = 'QS_GetLicenseInfo'
GO

insert into GXDBVersions values(2, 'QS_GetLicenseInfo',  '00000000000000000000', 'QS_GetLicenseInfo', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_GetLicenseInfo',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	Qoperation execscript sn getLicenseInfo.sql -si license_name|all
'
 + CHAR(10) + '--   script_name : GetLicenseInfo'
)
GO

