

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_GetJobHistory.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_GetJobHistory <<<'

IF EXISTS (select * from sysobjects where name='QS_GetJobHistory')
	drop procedure QS_GetJobHistory
IF EXISTS (select * from GxQscripts where name='QS_GetJobHistory')
	delete from GxQscripts where name = 'QS_GetJobHistory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetJobHistory')
	delete from GXDBVersions where aliasname = 'QS_GetJobHistory'
GO
print '... Creating Procedure: QS_GetJobHistory'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_GetJobHistory
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @clientName varchar(1024) = '',
  @fromTime varchar(128) = ''
AS
Set NOCOUNT ON
-------------------------------------------
-- INPUT :
-------------------------------------------
--DECLARE @clientName   varchar(1024)
--SET       @clientName = '%s'
---- Convenience Definitions    -----------
DECLARE @scriptName varchar(32)
SET     @scriptName = 'GetJobHistory'
DECLARE @COMMCELLID int
SET @COMMCELLID = 2
DECLARE @nowTime    integer = 0
SET     @nowTime    = dbo.GetUnixTime (GetUTCdate())
DECLARE @fromPeriodInt    integer = 0
-------- Local Variables    -------------
DECLARE @lastError              integer
SET     @lastError  = 0
DECLARE @localErrorMsg          varchar(512)
SET     @localErrorMsg          ='Error Encountered when running script.'
if(@clientName = '')
BEGIN
    SET @localErrorMsg = 'Error.  Client Name was not supplied as an input.'
    Set @lastError = 1
    goto   ARGS_ERROR
END
IF (@fromTime IS null)
BEGIN
	SET	@fromPeriodInt = 0
END
ELSE
BEGIN
	DECLARE @csTimeZone    VARCHAR(256)
	SELECT  @csTimeZone = timeZone FROM APP_CommCell WHERE id = 2
	SELECT @csTimeZone = TimeZoneStdName FROM SchedTimeZone
	WHERE  TimeZoneName= SUBSTRING(@csTimeZone, CHARINDEX(':', @csTimeZone, CHARINDEX(':', @csTimeZone, 0) + 1) + 1, 255)
	SET @fromPeriodInt = dbo.getUnixTime(dbo.LocalToUTCTime(CONVERT(DATETIME, @fromTime), @csTimeZone))
END
DECLARE @clientId int
SET @clientId = ISNULL((Select id FROM APP_Client WHERE name LIKE @clientName), 0)
if(@clientId = 0)
BEGIN
    SET @localErrorMsg = 'Error.  Client ['+@clientName+'] does not exist.'
    Set @lastError = 1
    goto   ARGS_ERROR
END
SELECT jobID = JMBkpStats.jobId,
    (case bkpLevel  WHEN 0x1 THEN 'Full'
                    WHEN 0x2 THEN 'Incremental'
                    WHEN 0x4 THEN 'Differential'
                    WHEN 0x8 THEN 'Any'
                    WHEN 0x40 THEN 'Synthetic Full'
                    WHEN 0x80 THEN 'Synthetic Full Followed by Incremental'
                    WHEN 0x100 THEN 'Incremental Do Not Truncate Logs'
                    WHEN 0x200 THEN 'ASR'
                    WHEN 0x400 THEN 'Selective Online Full'
                    WHEN 0x800 THEN 'Snapshot Backup'
                    WHEN 0x1000 THEN 'Create Replication Backup'
                    WHEN 0x2000 THEN 'Update Replication Backup'
                    WHEN 0x4000 THEN 'Synthentic Full with Incremental Before'
                    WHEN 0x8000 THEN 'Selective Online Full'
                    WHEN 0x10000 THEN 'Qnet SAP Operation'
                    WHEN 0x20000 THEN 'SRM Analysis'
                    WHEN 0x40000 THEN 'SRM Discovery'
                    WHEN 0x80000 THEN 'Qnet SAP Operation'
    END)As Level,
    (case status    WHEN 1 THEN 'Success'
                        WHEN 2 THEN 'Failed'
                        WHEN 3 THEN 'Partial Success'
                        WHEN 4 THEN 'Killed'
                        WHEN 5 THEN 'Stopped'
                        WHEN 6 THEN 'Interrupted'
                        WHEN 7 THEN 'Any'
                        WHEN 8 THEN 'Skipped'
                        WHEN 9 THEN 'Dropped'
                        WHEN 10 THEN 'In Sync'
                        WHEN 11 THEN 'Out of Sync'
                        WHEN 12 THEN 'Not Attempted'
                        WHEN 13 THEN 'Started'
                        ELSE 'Unknown'
    END) as Status,
    StoragePolicyName = CASE
        WHEN APP_Application.appTypeId = 47 OR APP_Application.appTypeId = 50 THEN ISNULL((SELECT name FROM QRPolicy WHERE id = (CASE WHEN JMBkpStats.dataArchGrpId = 0 THEN JMBkpStats.logArchGrpId ELSE JMBkpStats.dataArchGrpId END)),'Unavailable')
        WHEN (CASE WHEN JMBkpStats.dataArchGrpId = 0 THEN JMBkpStats.logArchGrpId ELSE JMBkpStats.dataArchGrpId END) = 0 THEN ''
        ELSE ISNULL((SELECT name FROM archGroup WHERE id = (CASE WHEN JMBkpStats.dataArchGrpId = 0 THEN JMBkpStats.logArchGrpId ELSE JMBkpStats.dataArchGrpId END)),'Unavailable')
        END,
    (Select retentiondays FROM archAgingRule WHERE copyid = ISNULL((SELECT defaultcopy FROM archGroup WHERE id = (CASE WHEN JMBkpStats.dataArchGrpId = 0 THEN JMBkpStats.logArchGrpId ELSE JMBkpStats.dataArchGrpId END)),0)) as RetentionDays,
    --ClientName = (select name from APP_Client WITH (NOLOCK) where id = APP_Application.clientId),
    AppTypeName = (select name from APP_iDAType WITH (NOLOCK) where type = APP_Application.appTypeId),
    --instanceName = (select name from APP_InstanceName WITH (NOLOCK) where id = APP_Application.instance),
    --backupSetName = (select name from APP_BackupSetName WITH (NOLOCK) where id = APP_Application.backupSet),
    APP_Application.SubclientName,
    DATEADD(SS,(DATEDIFF(SS,GETUTCDATE(),GETDATE())),dbo.GetDateTime(servStartDate)) as 'CommServerStartTime',
    servStartDate as 'UTCStartTime',
    DATEADD(SS,(DATEDIFF(SS,GETUTCDATE(),GETDATE())),dbo.GetDateTime(servEndDate)) as 'CommServerEndTime',
    servEndDate as 'UTCEndTime',
    BackupSize  = JMBkpStats.totalBackupSize,
    ApplicationSize    = JMBkpStats.totalUncompBytes
FROM JMBkpStats
INNER JOIN APP_Application WITH (NOLOCK) ON
JMBkpStats.appId = APP_Application.id
WHERE APP_Application.clientId = @clientId
AND JMBkpStats.servStartDate > @fromPeriodInt
ORDER BY servStartDate ASC
ARGS_ERROR:
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
         + ' with Parameters ClientName : ['+@clientName+']. Exit Code(' +convert(varchar(2), @lastError) + ').'
if @lastError <> 0
    Raiserror(@localErrorMsg,
                15,  --Severity (> 10 to force DOS Error Code = 1)
                1    --State
                )
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GetJobHistory')
	delete from GxQscripts where name = 'QS_GetJobHistory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetJobHistory')
	delete from GXDBVersions where aliasname = 'QS_GetJobHistory'
GO

insert into GXDBVersions values(2, 'QS_GetJobHistory',  '00000000000000000000', 'QS_GetJobHistory', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_GetJobHistory',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '    qoperation execscript -sn GetJobHistory -si Client_name unixTime
'
 + CHAR(10) + '--   script_name : GetJobHistory'
)
GO

