

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_GetJobDetails.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_GetJobDetails <<<'

IF EXISTS (select * from sysobjects where name='QS_GetJobDetails')
	drop procedure QS_GetJobDetails
IF EXISTS (select * from GxQscripts where name='QS_GetJobDetails')
	delete from GxQscripts where name = 'QS_GetJobDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetJobDetails')
	delete from GXDBVersions where aliasname = 'QS_GetJobDetails'
GO
print '... Creating Procedure: QS_GetJobDetails'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_GetJobDetails
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @clientName varchar(1024) = '%s'
AS
Set NOCOUNT ON
-------------------------------------------
-- INPUT :
-------------------------------------------
--DECLARE @clientName	varchar(1024)
--SET		@clientName = '%s'
---- Convenience Definitions    -----------
DECLARE @scriptName	varchar(32)
SET		@scriptName	= 'GetJobDetails'
DECLARE @COMMCELLID int
SET @COMMCELLID = 2
DECLARE @NoParameter varchar(4)
SET     @NoParameter            ='%'                        -- Get Around QScript Parameter
SET     @NoParameter            =@NoParameter + 's'         -- .. Substitution
DECLARE @nowTime	integer
SET     @nowTime	= dbo.GetUnixTime (GetUTCdate())
-------- Local Variables    -------------
DECLARE @lastError				integer
SET     @lastError  = 0									-- Be optimistic
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
------------------------------------------
--SET @clientName = 'oscar'
------------------------------------------
if(@clientName = @NoParameter)
BEGIN
	SET @localErrorMsg = 'Error.  Client Name was not supplied as an input.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
DECLARE @clientId int
SET @clientId = (Select id FROM APP_Client WHERE name LIKE @clientName)
if(@clientId = 0 OR @clientId IS NULL)
BEGIN
	SET @localErrorMsg = 'Error.  Client ['+@clientName+'] does not exist.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
DECLARE @localeId integer
SET @localeId = 0
SELECT jobID = JMJobInfo.jobId,
	(case bkpLevel  WHEN 0x1 THEN 'Full'
				    WHEN 0x2 THEN 'Incremental'
					WHEN 0x4 THEN 'Differential'
					WHEN 0x8 THEN 'Any'
					WHEN 0x40 THEN 'Synthetic Full'
					WHEN 0x80 THEN 'Synthetic Full Followed by Incremental'
					WHEN 0x100 THEN 'Incremental Do Not Truncate Logs'
					WHEN 0x200 THEN 'ASR'
					WHEN 0x400 THEN 'Selective Online Full'
					WHEN 0x800 THEN 'Snapshot Backup'
					WHEN 0x1000 THEN 'Create Replication Backup'
					WHEN 0x2000 THEN 'Update Replication Backup'
					WHEN 0x4000 THEN 'Synthentic Full with Incremental Before'
					WHEN 0x8000 THEN 'Selective Online Full'
					WHEN 0x10000 THEN 'Qnet SAP Operation'
					WHEN 0x20000 THEN 'SRM Analysis'
					WHEN 0x40000 THEN 'SRM Discovery'
					WHEN 0x80000 THEN 'Qnet SAP Operation'
	END)As Level,
	(case displayState 	WHEN 1 THEN 'Running'
						WHEN 2 THEN 'Pending'
						WHEN 3 THEN 'Waiting'
						WHEN 4 THEN 'Completed'
						WHEN 5 THEN 'Stopped'
						WHEN 6 THEN 'Kill Pending'
						WHEN 7 THEN 'Stop Pending'
						WHEN 8 THEN 'Interrupt Pending'
						WHEN 9 THEN 'Completed Successfully'
						WHEN 10 THEN 'Completed with Errors'
						WHEN 11 THEN 'Killed'
						WHEN 12 THEN 'Completed Partial Success'
						WHEN 13 THEN 'System Kill Pending'
						WHEN 14 THEN 'Dormant'
						WHEN 15 THEN 'Queued'
						WHEN 16 THEN 'Dormant Schedule Wait'
						WHEN 17 THEN 'Running Unavailable'
						WHEN 18 THEN 'Dangling Job Cleanup'
						ELSE 'Unknown'
	END)as Status,
	StoragePolicyName = CASE
		WHEN APP_Application.appTypeId = 47 OR APP_Application.appTypeId = 50 THEN ISNULL((SELECT name FROM QRPolicy WHERE id = currentPolicy),'Unavailable')
		WHEN currentPolicy = 0 THEN ''
		ELSE ISNULL((SELECT name FROM archGroup WHERE id = currentPolicy),'Unavailable')
		END,
	(Select retentiondays FROM archAgingRule WHERE copyid = ISNULL((SELECT defaultcopy FROM archGroup WHERE id = currentPolicy),0)) as RetentionDays,
	--ClientName = (select name from APP_Client where id = APP_Application.clientId),
	AppTypeName = (select name from APP_iDAType where type = APP_Application.appTypeId),
	--instanceName = (select name from APP_InstanceName where id = APP_Application.instance),
	--backupSetName = (select name from APP_BackupSetName where id = APP_Application.backupSet),
	APP_Application.SubclientName,
	DATEADD(SS,(DATEDIFF(SS,GETUTCDATE(),GETDATE())),dbo.GetDateTime(jobStartTime)) as 'StartTime/EndTime',
	Active = 'Yes',
	BackupSize      = -1,
	ApplicationSize = -1
	--dbo.JMGetLocalizedMessageAndIDFunc(@localeId,failureReason) as PendingReason
FROM JMBkpJobInfo
INNER JOIN JMJobInfo ON
JMBkpJobInfo.jobId = JMJobInfo.jobId AND
JMBkpJobInfo.commcellId = JMJobInfo.commcellId
INNER JOIN APP_Application ON
JMBkpJobInfo.applicationId = APP_Application.id
WHERE APP_Application.clientId= @clientId
UNION
SELECT jobID = JMBkpStats.jobId,
	(case bkpLevel  WHEN 0x1 THEN 'Full'
				    WHEN 0x2 THEN 'Incremental'
					WHEN 0x4 THEN 'Differential'
					WHEN 0x8 THEN 'Any'
					WHEN 0x40 THEN 'Synthetic Full'
					WHEN 0x80 THEN 'Synthetic Full Followed by Incremental'
					WHEN 0x100 THEN 'Incremental Do Not Truncate Logs'
					WHEN 0x200 THEN 'ASR'
					WHEN 0x400 THEN 'Selective Online Full'
					WHEN 0x800 THEN 'Snapshot Backup'
					WHEN 0x1000 THEN 'Create Replication Backup'
					WHEN 0x2000 THEN 'Update Replication Backup'
					WHEN 0x4000 THEN 'Synthentic Full with Incremental Before'
					WHEN 0x8000 THEN 'Selective Online Full'
					WHEN 0x10000 THEN 'Qnet SAP Operation'
					WHEN 0x20000 THEN 'SRM Analysis'
					WHEN 0x40000 THEN 'SRM Discovery'
					WHEN 0x80000 THEN 'Qnet SAP Operation'
	END)As Level,
	(case status 	WHEN 1 THEN 'Success'
						WHEN 2 THEN 'Failed'
						WHEN 3 THEN 'Partial Success'
						WHEN 4 THEN 'Killed'
						WHEN 5 THEN 'Stopped'
						WHEN 6 THEN 'Interrupted'
						WHEN 7 THEN 'Any'
						WHEN 8 THEN 'Skipped'
						WHEN 9 THEN 'Dropped'
						WHEN 10 THEN 'In Sync'
						WHEN 11 THEN 'Out of Sync'
						WHEN 12 THEN 'Not Attempted'
						WHEN 13 THEN 'Started'
						ELSE 'Unknown'
	END) as Status,
	StoragePolicyName = CASE
		WHEN APP_Application.appTypeId = 47 OR APP_Application.appTypeId = 50 THEN ISNULL((SELECT name FROM QRPolicy WHERE id = (CASE WHEN JMBkpStats.dataArchGrpId = 0 THEN JMBkpStats.logArchGrpId ELSE JMBkpStats.dataArchGrpId END)),'Unavailable')
		WHEN (CASE WHEN JMBkpStats.dataArchGrpId = 0 THEN JMBkpStats.logArchGrpId ELSE JMBkpStats.dataArchGrpId END) = 0 THEN ''
		ELSE ISNULL((SELECT name FROM archGroup WHERE id = (CASE WHEN JMBkpStats.dataArchGrpId = 0 THEN JMBkpStats.logArchGrpId ELSE JMBkpStats.dataArchGrpId END)),'Unavailable')
		END,
	(Select retentiondays FROM archAgingRule WHERE copyid = ISNULL((SELECT defaultcopy FROM archGroup WHERE id = (CASE WHEN JMBkpStats.dataArchGrpId = 0 THEN JMBkpStats.logArchGrpId ELSE JMBkpStats.dataArchGrpId END)),0)) as RetentionDays,
	--ClientName = (select name from APP_Client where id = APP_Application.clientId),
	AppTypeName = (select name from APP_iDAType where type = APP_Application.appTypeId),
	--instanceName = (select name from APP_InstanceName where id = APP_Application.instance),
	--backupSetName = (select name from APP_BackupSetName where id = APP_Application.backupSet),
	APP_Application.SubclientName,
	DATEADD(SS,(DATEDIFF(SS,GETUTCDATE(),GETDATE())),dbo.GetDateTime(servEndDate)) as 'StartTime/EndTime',
	Active = 'No',
	BackupSize  = JMBkpStats.totalBackupSize,
	ApplicationSize    = JMBkpStats.totalUncompBytes
 	--dbo.JMGetLocalizedMessageAndIDFunc(@localeId,failureReason) as PendingReason
FROM JMBkpStats
INNER JOIN APP_Application ON
JMBkpStats.appId = APP_Application.id
WHERE APP_Application.clientId = @clientId
ORDER BY 'StartTime/EndTime' DESC
ARGS_ERROR:
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters ClientName : ['+@clientName+']. Exit Code(' +convert(varchar(2), @lastError) + ').'
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GetJobDetails')
	delete from GxQscripts where name = 'QS_GetJobDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetJobDetails')
	delete from GXDBVersions where aliasname = 'QS_GetJobDetails'
GO

insert into GXDBVersions values(2, 'QS_GetJobDetails',  '00000000000000000000', 'QS_GetJobDetails', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_GetJobDetails',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn GetJobDetails.sql -si Client_name
'
 + CHAR(10) + '--   script_name : GetJobDetails'
)
GO

