

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_GetJobConfiguration.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_GetJobConfiguration <<<'

IF EXISTS (select * from sysobjects where name='QS_GetJobConfiguration')
	drop procedure QS_GetJobConfiguration
IF EXISTS (select * from GxQscripts where name='QS_GetJobConfiguration')
	delete from GxQscripts where name = 'QS_GetJobConfiguration'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetJobConfiguration')
	delete from GXDBVersions where aliasname = 'QS_GetJobConfiguration'
GO
print '... Creating Procedure: QS_GetJobConfiguration'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_GetJobConfiguration
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @CLIENTNAME varchar(512) = '%s'
AS
Set NOCOUNT ON
-------------------------------------------
--INPUT
-------------------------------------------
--DECLARE @CLIENTNAME     	varchar(512)
--SET @CLIENTNAME = '%s'  			-- c=clientName, allclients
--SET @CLIENTNAME = 'roman'
--------------- Constants   -----------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'GetJobConfiguration'
-------------- Local Variables    -------------
DECLARE @NoParameter			varchar(10)
SET		@NoParameter			='%'						-- Get Around QScript Parameter
SET		@NoParameter            =@NoParameter + 's'			-- .. Substitution
DECLARE @lastError				integer
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
SET     @lastError  = 0									-- Be optimistic
-------------- Validate inputs -------------
IF(@clientName = @NoParameter)
BEGIN
	SET @localErrorMsg = 'Error.  Client Name was not supplied as an input.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
DECLARE @clientId				integer
SET @clientId= ISNULL((SELECT id from APP_CLIENT WHERE name = @CLIENTNAME),0)
IF @clientId = 0
BEGIN
	SET @localErrorMsg = 'Error.  Client ['+@CLIENTNAME+ '] Does not exist.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
-------------- Get Job configuration -------------
SELECT 'Prune Job results when Disk Capaicity reaches' as 'Job Property', ISNULL((SELECT attrval FROM APP_CLIENTPROP
		WHERE AttrName = 'DiskFullPercent' AND componentnameid = @clientId AND MODIFIED = 0), 90) as Value
UNION
SELECT 'Job Priority', ISNULL((SELECT attrval FROM APP_CLIENTPROP
		WHERE AttrName = 'JMPriority' AND componentnameid = @clientId AND MODIFIED = 0), 6)
UNION
SELECT 'Low Space Threshold on Job Results Folder(MB)', ISNULL((SELECT attrval FROM APP_CLIENTPROP
		WHERE AttrName = 'JobResultsThresholdMB' AND componentnameid = @clientId AND MODIFIED = 0), 500)
UNION
SELECT 'Prune job results after', ISNULL((SELECT attrval FROM APP_CLIENTPROP
		WHERE AttrName = 'AgingDays' AND componentnameid = @clientId AND MODIFIED = 0), 7)
UNION
SELECT 'Job Results Directory UserName (windows client)', ISNULL((SELECT attrval FROM APP_CLIENTPROP
		WHERE AttrName = 'Job Results Dir Username' AND componentnameid = @clientId AND MODIFIED = 0), '')
UNION
SELECT 'Job Results Directory', jobResultDir FROM APP_Client WHERE Id = @clientid
ARGS_ERROR:
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: [ ' + @CLIENTNAME+
         + ']. Exit Code(' +convert(varchar(2), @lastError) + ').'
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GetJobConfiguration')
	delete from GxQscripts where name = 'QS_GetJobConfiguration'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetJobConfiguration')
	delete from GXDBVersions where aliasname = 'QS_GetJobConfiguration'
GO

insert into GXDBVersions values(2, 'QS_GetJobConfiguration',  '00000000000000000000', 'QS_GetJobConfiguration', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_GetJobConfiguration',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn GetJobConfiguration.sql -si client_name
'
 + CHAR(10) + '--   script_name : GetJobConfiguration'
)
GO

