

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_GetIndexingPathForNotesDB.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_GetIndexingPathforNotesDB <<<'

IF EXISTS (select * from sysobjects where name='QS_GetIndexingPathforNotesDB')
	drop procedure QS_GetIndexingPathforNotesDB
IF EXISTS (select * from GxQscripts where name='QS_GetIndexingPathforNotesDB')
	delete from GxQscripts where name = 'QS_GetIndexingPathforNotesDB'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetIndexingPathforNotesDB')
	delete from GXDBVersions where aliasname = 'QS_GetIndexingPathforNotesDB'
GO
print '... Creating Procedure: QS_GetIndexingPathforNotesDB'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_GetIndexingPathforNotesDB
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @clientName nvarchar(1024) = '%s',
  @dbName nvarchar(1024) = '%s',
  @instancename nvarchar(1024) = '',
  @browsetime datetime = '31-Dec-9999'
AS
----CONVENIENT DEFS------
DECLARE @NoParam AS nvarchar(1024)
SET @NoParam = '%s'
DECLARE @ScriptName AS nvarchar(1024)
SET @ScriptName = 'getIndexingPath'
DECLARE @ErrorCode AS int
SET @ErrorCode = 0
DECLARE @ErrorString AS nvarchar(1024)
SET @ErrorString = '%s'
DECLARE @ClientID AS int
DECLARE @ApplID AS int
DECLARE @InstanceID AS int
DECLARE @ubrowsetime AS int
----Check for missing parameters------
IF @ClientName = @NoParam
BEGIN
	SET @ErrorCode = 1
	SET @ErrorString = 'Error. Please provide client Name as input'
	GOTO ARGS_ERROR
END
IF @dbName = @NoParam
BEGIN
	SET @ErrorCode = 1
	SET @ErrorString = 'Error. Please provide dbname as input'
	GOTO ARGS_ERROR
END
-----Validate the input parameters---------
SET @ClientID = ISNULL ((SELECT id FROM APP_Client WHERE name = @ClientName), 0)
IF @ClientID = 0
BEGIN
	SET @ErrorCode = 1
	SET @ErrorString = 'Error. Client Name '+@ClientName +' is not valid'
	GOTO ARGS_ERROR
END
-----Verify whether client has Notes DB-------
DECLARE @Count AS int
SET @Count = ISNULL((SELECT COUNT(*) FROM APP_IDAName WHERE clientId = @ClientID AND appTypeId in (59,77)),0)
IF @Count = 0
BEGIN
	SET @ErrorCode = 1
	SET @ErrorString = 'Error. Client '+@ClientName +' does not contain Notes DB ida'
	GOTO ARGS_ERROR
END
----Verify for instance name--------
IF @instancename <> ''
BEGIN
	SET @InstanceID =  ISNULL((SELECT DISTINCT API.id
					   FROM APP_Application APL INNER JOIN APP_InstanceName API
					   ON APL.instance = API.id
					   WHERE APL.clientId  = @ClientID AND APL.appTypeId in (59,77) AND API.name like @instancename + CHAR(18) + '%' ),0)
	IF @InstanceID = 0
	BEGIN
		SET @ErrorCode = 1
		SET @ErrorString = 'Instance Name ' +@instancename +' is invalid'
		GOTO ARGS_ERROR
	END
END
IF @browsetime <> '31-Dec-9999'
SET @ubrowsetime = dbo.GetUnixTime (@browsetime)
-----Inputs are all correct--------
IF @InstanceName = '' AND @browsetime = '31-Dec-9999'
BEGIN
	select Replace(fileName, char(18), '|#12!')
	from APP_ScFilterFile
	where componentNameId in ( select distinct id
							   from APP_Application
							   where appTypeId in (59, 77) and clientId = @ClientID )
	and ((filename like N'%\' + @dbname + N'%')  or (filename like N'%/' + @dbname + N'%')) and (modified = 0)
END
ELSE IF @instancename <> '' AND @browsetime = '31-Dec-9999'
BEGIN
	select Replace(fileName, char(18), '|#12!')
	from APP_ScFilterFile
	where componentNameId in ( select distinct id
							   from APP_Application
							   where appTypeId in (59, 77) and clientId = @ClientID and instance = @InstanceID )
	and ((filename like N'%\' + @dbname + N'%') or (filename like N'%/' + @dbname + N'%')) and (modified = 0)
END
ELSE IF @instancename = '' AND @browsetime <> '31-Dec-9999'
BEGIN
	select Replace(fileName, char(18), '|#12!')
	from APP_ScFilterFile
	where componentNameId in ( select distinct id
							   from APP_Application
							   where appTypeId in (59, 77) and clientId = @ClientID)
	and ((filename like N'%\' + @dbname + N'%') or (filename like N'%/' + @dbname + N'%')) and (created <= @ubrowsetime) and (modified = 0 or modified >= @ubrowsetime)
END
ELSE
BEGIN
	select Replace(fileName, char(18), '|#12!')
	from APP_ScFilterFile
	where componentNameId in ( select distinct id
							   from APP_Application
							   where appTypeId in (59, 77) and clientId = @ClientID and instance = @InstanceID )
	and ((filename like N'%\' + @dbname + N'%') or (filename like N'%/' + @dbname + N'%')) and (created <= @ubrowsetime)  and (modified = 0 or modified >= @ubrowsetime)
END
ARGS_ERROR:
if @ErrorCode  <> 0
	Raiserror(@ErrorString,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GetIndexingPathForNotesDB')
	delete from GxQscripts where name = 'QS_GetIndexingPathForNotesDB'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetIndexingPathForNotesDB')
	delete from GXDBVersions where aliasname = 'QS_GetIndexingPathForNotesDB'
GO

insert into GXDBVersions values(2, 'QS_GetIndexingPathForNotesDB',  '00000000000000000000', 'QS_GetIndexingPathForNotesDB', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_GetIndexingPathForNotesDB',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn GetIndexingPathforNotesDB.sql -si clientName -si dbname [-si InstanceName] [-si BrowseTime]
'
 + CHAR(10) + '--   script_name : GetIndexingPathforNotesDB'
)
GO

