

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_GetHWEncryptionKeys.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ------------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_GetHWEncryptionKeys')
BEGIN
	print '>>> Drop Stored Procedure: QS_GetHWEncryptionKeys <<<'
	drop procedure QS_GetHWEncryptionKeys
END
IF EXISTS (select * from GxQscripts where name='QS_GetHWEncryptionKeys')
	delete from GxQscripts where name = 'QS_GetHWEncryptionKeys'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetHWEncryptionKeys')
	delete from GXDBVersions where aliasname = 'QS_GetHWEncryptionKeys'
GO
print '... Creating Procedure: QS_GetHWEncryptionKeys'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_GetHWEncryptionKeys
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- SP Input Params
  @mediaBarCode varchar(256) = '%s'
AS
SET NOCOUNT ON
---------------- Consts   -------------------------------------------------------------------
DECLARE @scriptName                      varchar(32)
SET     @scriptName                       = 'GetHWEncryptionKeys'
-------- Local Variables  -------------------------------------------------------------------
DECLARE @lastError                       integer
DECLARE @localErrorMsg                   varchar(512)
SET     @localErrorMsg                    ='Error Encountered when running script.'
SET     @lastError  = 0
DECLARE @NoParameter            varchar(10)
SET     @NoParameter            ='%'                        -- Get Around QScript Parameter
SET     @NoParameter            =@NoParameter + 's'         -- .. Substitution
--------------------- Input validation    ----------------------------------------------------
if(@mediaBarCode = @NoParameter)
BEGIN
	SET @localErrorMsg = 'Error.  Media BarCode was not supplied as an input.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
DECLARE @mediaId int
SET @mediaId = ISNULL((select top 1 M.MediaId from MMMedia M where M.BarCode = @mediaBarCode), 0)
IF(@mediaId = 0)
BEGIN
	SET @localErrorMsg = 'Error.  Media BarCode ['+ @mediaBarCode + '] Does not exist.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
-----------------------------------------------------------------------------------------------
SELECT distinct M.BarCode,A.fileMarkerNo, CASE WHEN A.flags & 1048576 > 0 THEN M.hwEncKey ELSE A.hwEncKey END
FROM  MMMedia M, archChunk A , MMVolume V
WHERE M.BarCode = @mediaBarCode AND  M.MediaId = V.MediaId
AND V.VolumeId = A.volumeId
AND (A.hwEncKey <> '' OR A.flags & 1048576 /*CVA_CHUNK_IS_ENC_BY_MEDIA_KEY*/ > 0)
ARGS_ERROR:
if @lastError <> 0
       Raiserror(@localErrorMsg,
                 15,  		--Severity (> 10 to force DOS Error Code = 1)
                 1      	--State
                )
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GetHWEncryptionKeys')
	delete from GxQscripts where name = 'QS_GetHWEncryptionKeys'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetHWEncryptionKeys')
	delete from GXDBVersions where aliasname = 'QS_GetHWEncryptionKeys'
GO

insert into GXDBVersions values(2, 'QS_GetHWEncryptionKeys',  '00000000000000000000', 'QS_GetHWEncryptionKeys', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_GetHWEncryptionKeys',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '      qoperation execscript -sn GetHWEncryptionKeys.sql -si Media_BarCode
'
 + CHAR(10) + '--   script_name : GetHWEncryptionKeys'
 + CHAR(10) + '--     returns the filemarker number , Hardware Encryption Keys for the given Media BarCode.'
)
GO

