

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_GetHANALogBackupInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='QS_GetHANALogBackupInfo')
BEGIN
	print '>>> Drop Stored Procedure: QS_GetHANALogBackupInfo <<<'
	drop procedure QS_GetHANALogBackupInfo
END
IF EXISTS (select * from GxQscripts where name='QS_GetHANALogBackupInfo')
	delete from GxQscripts where name = 'QS_GetHANALogBackupInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetHANALogBackupInfo')
	delete from GXDBVersions where aliasname = 'QS_GetHANALogBackupInfo'
GO
print '... Creating Procedure: QS_GetHANALogBackupInfo'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure QS_GetHANALogBackupInfo
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--Stored procedure inputs
  @ClientName NVARCHAR(1024) = N'',
  @InstanceName NVARCHAR(1024) = N'',
  @StartTime NVARCHAR(1024) = N'',
  @EndTime NVARCHAR(1024) = N''
AS
Set NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
-- Convenience Definitions ----------------------
DECLARE @scriptName	varchar(32)
set	@scriptName	= 'GetHANALogBackupInfo'
DECLARE @StartTimeDT DATETIME
DECLARE @EndTimeDT DATETIME
DECLARE @StartTimeUTC	DATETIME
DECLARE @EndTimeUTC		DATETIME
DECLARE @StartTimeEpoch INT = 0
DECLARE @EndTimeEpoch INT = 0
DECLARE @commCellId INT = 2
SELECT @commCellId = id FROM APP_CommCell WHERE type = 1 AND id > 1
if OBJECT_ID('tempdb.dbo.#tmpArchFileList') is not NULL drop table dbo.#tmpArchFileList
if OBJECT_ID('tempdb.dbo.#tmpHanaLogBackups') is not NULL drop table dbo.#tmpHanaLogBackups
CREATE TABLE #tmpArchFileList (ClientName NVARCHAR(1024), InstanceName NVARCHAR(1024), DatabaseName NVARCHAR(1024), jobID BIGINT, ArchFileID BIGINT, name NVARCHAR(2048), backupTime INT)
CREATE TABLE #tmpHanaLogBackups(ClientName NVARCHAR(1024), InstanceName NVARCHAR(1024), DatabaseName NVARCHAR(1024), jobID BIGINT, ArchFileID BIGINT, name NVARCHAR(2048), backupTime INT, Data NVARCHAR(1024), rowN INT)
IF @StartTime <> ''
BEGIN
	SET @StartTimeDT = @StartTime
	SET @StartTimeUTC = dbo.CellLocalToUTCTime(@StartTimeDT, @commCellId)
	SET @StartTimeEpoch = dbo.GetUnixTime(@StartTimeUTC)
END
IF @EndTime <> ''
BEGIN
	SET @EndTimeDT = @EndTime
	SET @EndTimeUTC = dbo.CellLocalToUTCTime(@EndTimeDT, @commCellId)
	SET @EndTimeEpoch = dbo.GetUnixTime(@EndTimeUTC)
END
INSERT INTO #tmpArchFileList
SELECT	C.name 'ClientName', I.name 'InstanceName', B.name 'BackupsetName', AF.jobId, AF.id, AF.name, AF.cTime
FROM	archFile AF
	INNER JOIN APP_Application A
		ON	AF.appId = A.id AND AF.fileType = 4 AND A.appTypeId = 135 AND (A.subclientStatus & 4096) <> 0
			AND (AF.cTime >= @StartTimeEpoch OR @StartTimeEpoch = 0)
			AND (AF.cTime <= @EndTimeEpoch OR @EndTimeEpoch = 0)
	INNER JOIN APP_Client C
		ON C.id = A.clientId AND (@ClientName = '' OR @ClientName = C.name)
	INNER JOIN APP_InstanceName I
		ON A.instance = I.id AND (@InstanceName = '' OR @InstanceName = I.name)
	INNER JOIN APP_BackupSetName B
		ON A.backupSet = B.id
WHERE	AF.name <> 'DBLOGBACKUP'
INSERT INTO #tmpHanaLogBackups
SELECT ClientName, InstanceName, DatabaseName, jobId, ArchFileId, name, backupTime, data, rowN
FROM
	(SELECT	ClientName, InstanceName, DatabaseName, jobId, ArchFileID, name, backupTime, R.Data, row_number() over (partition by jobId, ArchFileID order by R.id desc) as rowN
	FROM	#tmpArchFileList
	CROSS APPLY dbo.SplitString(name, '_') R
	) result
WHERE result.rowN IN (1, 2, 4)
SELECT	ClientName 'Client',
		InstanceName 'SID',
		CASE WHEN DatabaseName = 'default' THEN 'N/A' ELSE DatabaseName END AS 'Tenant DB',
		jobId 'Job ID',
		name 'File Name',
		dbo.UTCToCellLocalTime(dbo.GetDateTime(BackupTime), @commCellId) 'Backup Time',
		CAST([4] AS INT) as 'Volume ID',
		[2] as 'Start Log Number',
		CASE WHEN CHARINDEX('.', [1]) <> 0 THEN SUBSTRING([1], 1, CHARINDEX('.', [1])) ELSE [1] END AS 'End Log Number',
		CASE WHEN CHARINDEX('.', [1]) <> 0 THEN SUBSTRING([1], CHARINDEX('.', [1]), LEN([1])) ELSE 'Not Available' END AS 'Backup ID'
FROM
	(SELECT ClientName, InstanceName, DatabaseName, jobId, ArchFileID, name, BackupTime, rowN, Data from  #tmpHanaLogBackups) P
	PIVOT (
	MAX(DATA) FOR rowN in ([1], [2], [4]))
	as PVT
ORDER BY ClientName, InstanceName, jobid
DROP TABLE #tmpHanaLogBackups
DROP TABLE #tmpArchFileList
SET NOCOUNT OFF
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GetHANALogBackupInfo')
	delete from GxQscripts where name = 'QS_GetHANALogBackupInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetHANALogBackupInfo')
	delete from GXDBVersions where aliasname = 'QS_GetHANALogBackupInfo'
GO

insert into GXDBVersions values(2, 'QS_GetHANALogBackupInfo',  '00000000000000000000', 'QS_GetHANALogBackupInfo', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_GetHANALogBackupInfo',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn GetHANALogBackupInfo
'
 + CHAR(10) + '--   script_name :GetHANALogBackupInfo'
)
GO

