

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_GetGlobalFilterState.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_GetGlobalFilterState <<<'

IF EXISTS (select * from sysobjects where name='QS_GetGlobalFilterState')
	drop procedure QS_GetGlobalFilterState
IF EXISTS (select * from GxQscripts where name='QS_GetGlobalFilterState')
	delete from GxQscripts where name = 'QS_GetGlobalFilterState'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetGlobalFilterState')
	delete from GXDBVersions where aliasname = 'QS_GetGlobalFilterState'
GO
print '... Creating Procedure: QS_GetGlobalFilterState'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_GetGlobalFilterState
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @PARAM1 varchar(1024) = '%s',
  @PARAM2 varchar(1024) = '%s',
  @PARAM3 varchar(1024) = '%s',
  @PARAM4 varchar(1024) = '%s',
  @PARAM5 varchar(1024) = '%s'
AS
Set NOCOUNT ON
-------------------------------------------
-- INPUT :
-------------------------------------------
--DECLARE @PARAM1	varchar(1024)
--SET		@PARAM1 = '%s'
--DECLARE @PARAM2 varchar(1024)
--SET		@PARAM2	= '%s'
--DECLARE @PARAM3 varchar(1024)
--SET		@PARAM3 = '%s'
--DECLARE @PARAM4 varchar(1024)
--SET		@PARAM4 = '%s'
--DECLARE @PARAM5 varchar(1024)
--SET		@PARAM5 = '%s'
------------------ Constants    -----------
DECLARE @scriptName	varchar(32)
SET		@scriptName	= 'GetGlobalFilterState'
DECLARE @propName1 varchar(50)
SET @propName1 = 'use cs setting for Global Filters'
DECLARE @propName2 varchar(32)
SET @propName2 = 'Use Global Filters'
-------- Local Variables    -------------
DECLARE @NoParameter varchar(4)
SET     @NoParameter            ='%'                        -- Get Around QScript Parameter
SET     @NoParameter            =@NoParameter + 's'         -- .. Substitution
DECLARE @lastError				integer
SET     @lastError  = 0									-- Be optimistic
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
---------------------------------------
--test
--SET		@PARAM1= 'c=bingo'
--SET		@PARAM2= 'a=Q_WINNET_FS'
--SET		@PARAM3= 'b=defaultbackupset'
--SET		@PARAM4= 's=default'
---------------------------------------
------------ Get ids -------------
DECLARE @ClientId int
DECLARE @AppTypeId int
DECLARE @InstanceId int
DECLARE @BackupsetId int
DECLARE @subclientId int
IF  OBJECTPROPERTY(object_id(N'[dbo].[QscriptGetAppIdsFromNames]'), N'IsProcedure') IS NULL
BEGIN
	SET @lastError = 1
	SET @localErrorMsg  = 'This script requires Stored procedure QscriptGetAppIdsFromNames to be installed. Please install it and try again.'
	GOTO ARGS_ERROR
END
EXECUTE @lastError = QscriptGetAppIdsFromNames @PARAM1, @PARAM2, @PARAM3, @PARAM4, @PARAM5,
	@subclientId OUTPUT, @BackupsetId OUTPUT, @InstanceId OUTPUT, @AppTypeId OUTPUT, @ClientId OUTPUT,
    @localErrorMsg OUTPUT
IF @lastError != 0
BEGIN
	GOTO ARGS_ERROR
END
----------------------- input validation ------------------------
DECLARE @scpid integer
SET @scpid = ISNULL((select attrval from app_backupsetprop where attrname like 'Associated subclient Policy' and componentnameid = @backupsetid AND modified = 0),0)
DECLARE @useSCPfilters integer
IF @scpid >0
BEGIN
	SET @useSCPfilters = ISNULL((select attrval from app_subclientprop where componentNameId = @subclientId and modified=0 AND attrname like 'use SCP filters'), 0)
END
IF @useSCPfilters = 0
BEGIN
	SELECT 'NOT APPLICABLE (USES SUBCLIENT POLICY FILTERS)' As GlobalFilterState
	GOTO ARGS_ERROR
END
IF @AppTypeId NOT IN  (1,11,12,17,18,19,20,21,28,29,36,33,34,36,38,42,43, 54,56,57,58, 63,64,67,68,74,86, 105,106)
BEGIN
	SELECT 'NOT APPLICABLE' AS GlobalFilterState
	GOTO ARGS_ERROR
END
----------------------- Get global filter state ------------------------
IF (ISNULL(( SELECT attrVal FROM APP_SubclientProp WHERE componentNameId = @subclientId AND modified =0 and attrName = @propName1), '1')= '0')
BEGIN
	IF(ISNULL((SELECT attrVal FROM APP_SubclientProp WHERE componentNameId = @subclientId AND modified =0 and attrName = @propName2), '0') = '1')
		SELECT 'ON' AS GlobalFilterState
	ELSE
		SELECT 'OFF'AS GlobalFilterState
END
ELSE
	SELECT 'USE CELL LEVEL POLICY'AS GlobalFilterState
ARGS_ERROR:
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GetGlobalFilterState')
	delete from GxQscripts where name = 'QS_GetGlobalFilterState'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetGlobalFilterState')
	delete from GXDBVersions where aliasname = 'QS_GetGlobalFilterState'
GO

insert into GXDBVersions values(2, 'QS_GetGlobalFilterState',  '00000000000000000000', 'QS_GetGlobalFilterState', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_GetGlobalFilterState',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn GetGlobalFilterState -si c=client_name -si a=app_type_name [-si i=instance_name] [-si b=backupset_name] -si s=subclient_name
'
 + CHAR(10) + '--   script_name : GetGlobalFilterState'
)
GO

