

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_GetFlaggedJobCount.sp] ---------- 

-------------------------------------------
--         Name:   QS_GetFlaggedJobCount.sql
--       Author:   Gokul Pattabiraman
--  Description:   Get the count of jobs that are flagged in GUI needing Administrator's attention.
-- TR(original):   120322-000214
--     Customer:   RackSpace
--   CommcellId:   N/A (generic)
-------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_GetFlaggedJobCount <<<'

IF EXISTS (select * from sysobjects where name='QS_GetFlaggedJobCount')
	drop procedure QS_GetFlaggedJobCount
IF EXISTS (select * from GxQscripts where name='QS_GetFlaggedJobCount')
	delete from GxQscripts where name = 'QS_GetFlaggedJobCount'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetFlaggedJobCount')
	delete from GXDBVersions where aliasname = 'QS_GetFlaggedJobCount'
GO
print '... Creating Procedure: QS_GetFlaggedJobCount'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_GetFlaggedJobCount
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--  3 Corresponds to "medium", same as same functionality in GUI.  Macro doesn't expand right for some reason
-- Qscript Usage.
AS
SET NOCOUNT ON
---- Convenience Definitions    -----------
DECLARE @scriptName				VARCHAR(32)
SET		@scriptName				= 'QS_GetFlaggedJobCount'
-------- Local Variables    -------------
--
DECLARE @localErrorMsg			AS	VARCHAR(512)	='Error Encountered when running script.'
DECLARE @lastError				AS	INTEGER = 0							-- Be optimistic
SELECT COUNT(*) "JobCount" FROM JMJobInfo WITH (NOLOCK)
WHERE guiAlertColorLevel <> 0
ARGS_ERROR:
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
         + ']. Exit Code(' +convert(varchar(2), @lastError) + ').'
IF @lastError <> 0
Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GetFlaggedJobCount')
	delete from GxQscripts where name = 'QS_GetFlaggedJobCount'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetFlaggedJobCount')
	delete from GXDBVersions where aliasname = 'QS_GetFlaggedJobCount'
GO

insert into GXDBVersions values(2, 'QS_GetFlaggedJobCount',  '00000000000000000000', 'QS_GetFlaggedJobCount', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_GetFlaggedJobCount',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 		qoperation execscript -sn QS_GetFlaggedJobCount'
 + CHAR(10) + '--       Get the count of jobs that are flagged in GUI needing Administrator''s attention.'
)
GO

