

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_GetFileSystemQuotaUsage.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_GetFileSystemQuotaUsage.sp,v $ $Id: QS_GetFileSystemQuotaUsage.sp,v 1.1.2.3 2019/12/02 22:25:28 nramalingam Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_GetFileSystemQuotaUsage')
BEGIN
	print '>>> Drop Stored Procedure: QS_GetFileSystemQuotaUsage <<<'
	drop procedure QS_GetFileSystemQuotaUsage
END
IF EXISTS (select * from GxQscripts where name='QS_GetFileSystemQuotaUsage')
	delete from GxQscripts where name = 'QS_GetFileSystemQuotaUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetFileSystemQuotaUsage')
	delete from GXDBVersions where aliasname = 'QS_GetFileSystemQuotaUsage'
GO
print '... Creating Procedure: QS_GetFileSystemQuotaUsage'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_GetFileSystemQuotaUsage
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @param1 VARCHAR(255) = '%s',
  @param2 VARCHAR(128) = '%s'
AS
SET NOCOUNT ON
---------------command line inputs--------------------
DECLARE @i_UserId INT = 0
DECLARE @i_EnforceQuota INT = 0
IF ISNULL(@param1, '') <> ''
	SELECT @i_UserId = id FROM UMUsers WITH (NOLOCK) WHERE name = @param1 OR login = @param1
IF LEFT(@param2,1) IN ('Y', 'y')
	SET @i_EnforceQuota = 1
CREATE TABLE #UserQuota (UserId INT, GroupId INT, InheritsQuota INT, EnforceQuota INT, QuotaLimitGB INT)
INSERT	INTO #UserQuota
SELECT	componentNameId, 0, [UMDS User Inherits Quota], [Enforce Quota], [Quota Size]
FROM	(SELECT	componentNameId, attrName, CAST(attrVal AS INT) AS attrVal
		FROM	UMUsersProp WITH (NOLOCK)
		WHERE	attrName IN (N'UMDS User Inherits Quota', N'Enforce Quota', N'Quota Size')
		) S
		PIVOT  (MAX(attrVal) FOR attrName IN ([UMDS User Inherits Quota], [Enforce Quota], [Quota Size])) AS P
WHERE	@i_UserId = 0 OR componentNameId = @i_UserId
CREATE TABLE #GroupQuota (GroupId INT, EnforceQuota INT, QuotaLimitGB INT)
INSERT	INTO #GroupQuota
SELECT	G.id, ISNULL([Enforce Quota],0), ISNULL([Quota Size],0)
FROM	UMGroups G WITH (NOLOCK)
		LEFT OUTER JOIN (
		SELECT	componentNameId, attrName, CAST(attrVal AS INT) AS attrVal
		FROM	UMGroupsProp WITH (NOLOCK)
		WHERE	attrName IN (N'Enforce Quota', N'Quota Size')
		) S
		PIVOT  (MAX(attrVal) FOR attrName IN ([Enforce Quota], [Quota Size])) AS P
	 ON G.id = P.componentNameId
WHERE	(G.groupFlags & 0x0001) <> 0  -- select enabled groups
	AND (G.groupFlags & 0x0002) = 0   -- ignore deleted groups
	AND ISNULL([Enforce Quota],0) > 0 -- ignore user groups without quota enforced
	AND ISNULL([Quota Size],0) > 0    -- ignore user groups without quota limit
CREATE TABLE #UserAndGroup (UserId INT, GroupId INT, EnforceQuota INT, QuotaLimitGB INT)
INSERT	INTO #UserAndGroup
SELECT	UserId, 0, EnforceQuota, QuotaLimitGB
FROM	#UserQuota
UNION
SELECT	G.userId, G.groupId, Q.EnforceQuota, Q.QuotaLimitGB
FROM	UMUserGroup G WITH (NOLOCK)
		INNER JOIN #UserQuota U ON G.userId = U.UserId
		INNER JOIN #GroupQuota Q WITH (NOLOCK) ON G.GroupId = Q.GroupId
UNION
SELECT	G.userId, GM.umgroupId, Q.EnforceQuota, Q.QuotaLimitGB
FROM	UMDSGroupMaps GM WITH (NOLOCK)
		INNER JOIN UMUserGroup G WITH (NOLOCK) ON GM.umdsGroupId = G.groupID
		INNER JOIN #UserQuota U ON G.userId = U.UserId
		INNER JOIN #GroupQuota Q WITH (NOLOCK) ON G.GroupId = Q.GroupId
UPDATE	U SET GroupId = T.GroupId, EnforceQuota = CASE WHEN U.EnforceQuota = 1 THEN 1 ELSE T.EnforceQuota END, QuotaLimitGB = T.QuotaLimitGB
FROM	#UserQuota U
		INNER JOIN (
		SELECT	UserId, GroupId, EnforceQuota, QuotaLimitGB,
				ROW_NUMBER() OVER (PARTITION BY UserId, GroupId ORDER BY EnforceQuota DESC, QuotaLimitGB DESC) AS RowNo
		FROM	#UserAndGroup
		WHERE	GroupId > 0
		) T ON U.UserId = T.UserId
WHERE	U.InheritsQuota = 1 AND T.RowNo = 1
DROP TABLE #GroupQuota
CREATE TABLE #OwnedClients (userId INT, clientId INT)
INSERT	INTO #OwnedClients
SELECT	DISTINCT UG.UserId, O.entityId
FROM	UMOwners O INNER JOIN #UserAndGroup UG
	ON O.isUser = 1 AND O.userOrGroupId = UG.UserId OR O.isUser = 0 AND O.userOrGroupId = UG.GroupId
DROP TABLE #UserAndGroup
CREATE TABLE #UserQuotaUsage (UserId INT, QuotaUsageMB BIGINT)
INSERT	INTO #UserQuotaUsage
SELECT	userId, SUM(1.0*CAST(attrVal AS BIGINT))/1024/1024 AS QuotaUsage
FROM	APP_SubClientProp SC WITH (NOLOCK)
		INNER JOIN APP_Application A WITH (NOLOCK) ON SC.componentNameId = A.id
		INNER JOIN #OwnedClients OC ON A.clientId = OC.clientId
WHERE	SC.attrName = N'Application Size' AND SC.modified = 0
	AND A.subclientStatus & (0 | 0x00002 | 0x00004 | 0x00010 | 0x00020) = 0
GROUP BY userId
INSERT	INTO #UserQuotaUsage
SELECT	userId, SUM(1.0*CAST(attrVal AS BIGINT))/1024/1024 AS QuotaUsage
FROM	APP_BackupSetProp BS WITH (NOLOCK)
		INNER JOIN (
			SELECT	DISTINCT OC.userId, A.backupSet
			FROM	APP_Application A WITH (NOLOCK)
					INNER JOIN #OwnedClients OC ON A.clientId = OC.clientId
			WHERE	A.subclientStatus & (0 | 0x00002 | 0x00004 | 0x00010 | 0x00020) = 0
		) T ON BS.componentNameId = T.backupSet
WHERE	BS.attrName = N'Application Size' AND BS.modified = 0
GROUP BY userId
SELECT	U.id AS UserId, U.name AS UserName, U.login AS UserLogin, U.email AS UserEmail, ISNULL(QuotaUsageMB, 0) AS QuotaUsageMB,
		ISNULL(G.id, 0) AS UserGroupId, ISNULL(G.name, '') AS UserGroupName, InheritsQuota, EnforceQuota, QuotaLimitGB
FROM	UMUsers U WITH (NOLOCK)
		INNER JOIN #UserQuota Q ON U.id = Q.UserId
		LEFT OUTER JOIN
		(SELECT	UserId, SUM(QuotaUsageMB) AS QuotaUsageMB
		FROM	#UserQuotaUsage
		GROUP BY UserId
		) S ON S.UserId = U.id
		LEFT OUTER JOIN UMGroups G WITH (NOLOCK) ON Q.GroupId = G.id
WHERE	@i_EnforceQuota = 0 OR EnforceQuota = 1
ORDER BY QuotaUsageMB DESC
DROP TABLE #UserQuota
DROP TABLE #OwnedClients
DROP TABLE #UserQuotaUsage
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GetFileSystemQuotaUsage')
	delete from GxQscripts where name = 'QS_GetFileSystemQuotaUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetFileSystemQuotaUsage')
	delete from GXDBVersions where aliasname = 'QS_GetFileSystemQuotaUsage'
GO

insert into GXDBVersions values(2, 'QS_GetFileSystemQuotaUsage',  '00010001000200030000', 'QS_GetFileSystemQuotaUsage', '00010001000200030000')
GO

insert into GxQscripts values(2,'QS_GetFileSystemQuotaUsage',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn GetFileSystemQuotaUsage.sql -si UserName -si EnforceQuota
'
 + CHAR(10) + '--   script_name : GetFileSystemQuotaUsage'
)
GO

