

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_GetDedupProp.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_GetDedupProp')
BEGIN
	print '>>> Drop Stored Procedure: QS_GetDedupProp <<<'
	drop procedure QS_GetDedupProp
END
IF EXISTS (select * from GxQscripts where name='QS_GetDedupProp')
	delete from GxQscripts where name = 'QS_GetDedupProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetDedupProp')
	delete from GXDBVersions where aliasname = 'QS_GetDedupProp'
GO
print '... Creating Procedure: QS_GetDedupProp'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_GetDedupProp
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- Stored Procedure Inputs
  @i_clientNameParam NVARCHAR(510)=N'',
  @i_appTypeName NVARCHAR(255)=N''
AS
 SET NOCOUNT ON
 -- CV_SINGLE_INSTANCING_OPTION
    DECLARE @C_CV_SI_OPTION NVARCHAR(32)
    SET @C_CV_SI_OPTION = N'Single Instancing Option'
    DECLARE @ENABLE_DEDUP NVARCHAR(32)
    SET @ENABLE_DEDUP = N'Enable DeDuplication'
    -- All Subclients
    DECLARE @C_ALL_CLIENTS NVARCHAR(32)
    SET @C_ALL_CLIENTS = N'__AllClients__'
    -- Variables to hold the Error Number & Error Message
    DECLARE @ErrorNumber	INTEGER
    DECLARE @ErrorMessage	NVARCHAR(MAX)
    IF LEN(@i_clientNameParam) = 0
    BEGIN
        SET @ErrorMessage = N'Client Name is empty'
        SET @ErrorNumber = 1
        GOTO    QS_ERROR
    END
    IF NOT EXISTS (SELECT Id FROM APP_Client WITH (NOLOCK) WHERE Name = @i_clientNameParam)
            AND @C_ALL_CLIENTS != @i_clientNameParam
    BEGIN
        SET @ErrorMessage = N'Client Name is invalid'
        SET @ErrorNumber = 1
        GOTO    QS_ERROR
    END
    IF LEN(@i_appTypeName) <> 0 AND NOT EXISTS (SELECT type FROM APP_iDAType WITH (NOLOCK) WHERE Name = @i_appTypeName)
    BEGIN
        SET @ErrorMessage = N'App Type Name is invalid'
        SET @ErrorNumber = 1
        GOTO    QS_ERROR
    END
    DECLARE @tmpSubClients TABLE (componentNameId integer)
    DECLARE	@tmpSubClientList TABLE
    (
		appTypeName		varchar(255),
		instanceName	nvarchar(1024),
		backupSetName	nvarchar(256),
		subClientName	nvarchar(256),
		subclientId		integer,
		clientName		nvarchar(510)
	)
	DECLARE @tmpDedupProps TABLE
	(
		subclientId		integer,
		archGroupCopyId	integer,
		clientId		integer,
		agcDedupeFlags	integer,
		agcExtendedFlags integer,
		IdxSIDBStoreFlag integer,
		scDedupProp		integer,
		clntDedupProp	integer,
		dedupWhere		integer,
		compressWhere	integer
	)
	INSERT INTO		@tmpSubClients
	SELECT			DISTINCT	id
	FROM			App_Application APP WITH (NOLOCK)
	INNER JOIN		APP_iDAType IDA WITH (NOLOCK) ON APP.appTypeId = IDA.type
	WHERE			(  (APP.clientId = ( SELECT Id FROM App_Client WITH (NOLOCK) WHERE	Name = @i_clientNameParam )) OR  ( @i_clientNameParam = @C_ALL_CLIENTS ))
	AND				(  @i_appTypeName=N'' OR IDA.name = @i_appTypeName )
	AND				dbo.IsSubClientValid(APP.appTypeId,APP.subclientStatus,0)  = 1
AND				(APP.subclientStatus & 0x00002) <> 0x00002  --uninstalled/*CV_STATUS_UNINSTALLED*/
AND				(APP.subclientStatus & 0x00004) <> 0x00004  --deleted/*CV_STATUS_DELETED*/
	INSERT	INTO	@tmpSubClientList
	SELECT			IDAT.name APP_TYPE, INST.name INSTANCE_NAME, B.name BACKUPSET_NAME,APP.subclientName SUBCLIENT_NAME,APP.id SUBCLIENT_ID,CLNT.name CLIENT_NAME
	FROM			@tmpSubClients TEMP
	INNER JOIN		APP_Application APP WITH (NOLOCK) ON APP.id = TEMP.componentNameId
	INNER JOIN		APP_Client CLNT WITH (NOLOCK) ON CLNT.id = APP.clientId
	INNER JOIN		APP_iDAType IDAT WITH (NOLOCK) ON APP.appTypeId = IDAT.type
	INNER JOIN		APP_InstanceName INST WITH (NOLOCK) ON APP.instance = INST.id
	INNER JOIN		APP_BackupSetName B WITH (NOLOCK) ON APP.backupSet = B.id
	INSERT	INTO	@tmpDedupProps
	SELECT			APP.id,AGC.id,APP.clientId,AGC.dedupeFlags,AGC.extendedFlags,ISNULL(STORE.flags,0),0,0,0,0
	FROM			@tmpSubClients TEMP
	INNER JOIN		APP_Application APP WITH (NOLOCK) ON APP.id = TEMP.componentNameId
	INNER JOIN		archGroup AG WITH(NOLOCK) ON APP.dataArchGrpID = AG.id OR AG.id = APP.logArchGrpID
	INNER JOIN		archGroupCopy AGC WITH (NOLOCK) ON AG.defaultCopy = AGC.id
LEFT JOIN		archCopySIDBStore CS WITH (NOLOCK) ON AGC.id = CS.copyId AND ((CS.Flags & (2|4)) = (2|4))
	LEFT JOIN		IdxSIDBStore STORE WITH (NOLOCK) ON STORE.SIDBStoreId = CS.SIDBStoreId
	-- If the rows are not found, using the defaults for the client/subclient level
	UPDATE			@tmpDedupProps
	SET				scDedupProp = ISNULL(( SELECT	CONVERT(INT, attrVal)
									FROM			APP_SubclientProp WITH (NOLOCK)
									WHERE			componentNameId = subclientId AND attrName = @C_CV_SI_OPTION AND modified = 0),1)
	UPDATE			@tmpDedupProps
	SET				clntDedupProp = ISNULL((	SELECT	CONVERT(INT, attrVal)
										FROM			APP_ClientProp WITH (NOLOCK)
										WHERE			componentNameId = clientId AND attrName = @ENABLE_DEDUP AND modified = 0),0)
	UPDATE			@tmpDedupProps
	SET				compressWhere = ISNULL ((	SELECT			compressWhere
										FROM			archPipeConfig APC WITH (NOLOCK)
										WHERE			APC.appNumber = subclientId  ),2)
	UPDATE			@tmpDedupProps
	SET				dedupWhere =
					( SELECT CASE
					WHEN ( ((agcDedupeFlags & 262144/*CVA_SIDB_STORE_ENABLED_FLAG*/) <> 0) AND (( agcDedupeFlags & 1048576/*CVA_DEDUP_INACTIVE_FLAG*/)= 0 ))
						THEN ( SELECT CASE
								WHEN (clntDedupProp = 1 AND (scDedupProp <> 0) )THEN 3 ELSE scDedupProp END )
						ELSE 0 END)
	-- Cleint-Side-Deduplication can be enabled by either or both Client-Property and Copy-Property
	UPDATE			@tmpDedupProps
	SET				dedupWhere =
					( SELECT CASE
					WHEN ( (dedupWhere <> 0) AND ((agcDedupeFlags & 524288/*CVA_CLIENT_SIDE_DEDUP_FLAG*/) <> 0) AND (clntDedupProp = 0) )
					THEN 3 ELSE dedupWhere END)
	UPDATE			@tmpDedupProps
	SET				compressWhere =
					( SELECT CASE
					WHEN ( (compressWhere = 1) AND (dedupWhere IN (1,3)) )  THEN 0
					WHEN ( (compressWhere = 2) AND ((agcDedupeFlags & 262144/*CVA_SIDB_STORE_ENABLED_FLAG*/) <> 0) AND (dedupWhere IN (1,3)) )  THEN 0
					WHEN ( (compressWhere = 2) AND ((agcDedupeFlags & 262144/*CVA_SIDB_STORE_ENABLED_FLAG*/) <> 0) AND (dedupWhere = 2) )  THEN 1
					WHEN ( (compressWhere = 2) AND ((agcDedupeFlags & 262144/*CVA_SIDB_STORE_ENABLED_FLAG*/) = 0) AND ((agcExtendedFlags & 16/*CVA_COMPRESSION_ON_CLIENTS_FLAG*/) > 0) )  THEN 0
					ELSE compressWhere END)
	UPDATE			@tmpDedupProps
	SET				compressWhere =
					( SELECT CASE
					WHEN (  ((agcDedupeFlags & 262144/*CVA_SIDB_STORE_ENABLED_FLAG*/) <> 0) AND IdxSIDBStoreFlag <> 0 AND  ((IdxSIDBStoreFlag & 2/*IDX_SIDBSTORE_FLAGS_SW_COMPRESSION*/) = 0)  )  THEN 2
					ELSE compressWhere END)
	SELECT			APP.appTypeName,APP.instanceName,APP.backupSetName,APP.clientName,APP.subClientName,APP.subclientId,
					DEDUP_WHERE = CASE PROP.dedupWhere
									WHEN 0 THEN 'Off'
									WHEN 1 THEN 'Client'
									WHEN 2 THEN 'MA'
									WHEN 3 THEN 'Client'
									ELSE 'NA' END,
					COMPRESS_WHERE = CASE PROP.compressWhere
									WHEN 0 THEN 'Client'
									WHEN 1 THEN 'MA'
									WHEN 2 THEN 'Off'
									WHEN 3 THEN 'Both'
									WHEN 4 THEN 'Off'
									ELSE 'NA' END
	FROM			@tmpSubClientList  APP
	INNER JOIN		@tmpDedupProps PROP ON APP.subclientId = PROP.subclientId
	ORDER BY		APP.clientName,APP.appTypeName,APP.instanceName,APP.backupSetName,APP.subClientName
QS_ERROR:
    IF @ErrorNumber <> 0
        Raiserror(@ErrorMessage,
                    15,  --Severity (> 10 to force DOS Error Code = 1)
                    1    --State
                    )
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GetDedupProp')
	delete from GxQscripts where name = 'QS_GetDedupProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetDedupProp')
	delete from GXDBVersions where aliasname = 'QS_GetDedupProp'
GO

insert into GXDBVersions values(2, 'QS_GetDedupProp',  '00000000000000000000', 'QS_GetDedupProp', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_GetDedupProp',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 		To get the properties for all the subclients for a given commcell'
 + CHAR(10) + '--       qoperation execscript -sn GetDedupProp -si "__AllClients__" '
 + CHAR(10) + '-- 		To get the properties for all the subclients for a given commcell and given app type'
 + CHAR(10) + '--       qoperation execscript -sn GetDedupProp -si "__AllClients__" -si AppTypeName'
 + CHAR(10) + '-- 		To get the properties for all the subclients for a given client'
 + CHAR(10) + '--       qoperation execscript -sn GetDedupProp -si clientName '
 + CHAR(10) + '-- 		To get the properties for all the subclients for a given client and given app type'
 + CHAR(10) + '--       qoperation execscript -sn GetDedupProp -si clientName -si AppTypeName'
)
GO

