

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_GetClientInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_GetClientInfo <<<'

IF EXISTS (select * from sysobjects where name='QS_GetClientInfo')
	drop procedure QS_GetClientInfo
IF EXISTS (select * from GxQscripts where name='QS_GetClientInfo')
	delete from GxQscripts where name = 'QS_GetClientInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetClientInfo')
	delete from GXDBVersions where aliasname = 'QS_GetClientInfo'
GO
print '... Creating Procedure: QS_GetClientInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_GetClientInfo
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
AS
Set NOCOUNT ON
-------------------------------------------
 --				NO INPUT				--
-------------------------------------------
---------------- Consts   -----------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'GetClientInfo'
DECLARE @propName varchar(32)
SET @propName = 'Active Physical Node'
-------- Local Variables    -------------
DECLARE @lastError				integer
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
SET     @lastError  = 0									-- Be optimistic
------------ No error handling ---------------
SELECT C.Name, ISNULL(C.net_hostName, 'Not Applicable') as 'Host Name', sSOS.name as 'OS',
			CASE(C.status & 2 )
			WHEN (2) THEN 'NO'
			ELSE (CASE(C.status & 4 ) WHEN(4) THEN 'NO' ELSE 'YES' END)END
			as 'ACTIVE' FROM APP_Client C
		 	join simOperatingSystem AS sSOS on sSOS.id = C.simOperatingSystemId
		 	WHERE C.simOperatingSystemId <> 0
			AND C.Id IN (SELECT clientId FROM APP_Platform WHERE platformType = 4)		--Check whether the client package is there for this client
			AND C.Id NOT IN (SELECT PMClientId FROM APP_VMToPMMap WHERE VMClientId = 2)	--Check whether this client is a physical machine for a cluster CS
 SET @lastError = @@error
 IF @lastError <> 0
 BEGIN
	SET @localErrorMsg = 'Error: Query Unsucess full'
	GOTO ARGS_ERROR
 END
--PRINT @scriptName + ' completed at '
--         + Convert(varchar(60), getdate()) + ' Exit Code(' +convert(varchar(2), @lastError) + ').'
ARGS_ERROR:
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GetClientInfo')
	delete from GxQscripts where name = 'QS_GetClientInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetClientInfo')
	delete from GXDBVersions where aliasname = 'QS_GetClientInfo'
GO

insert into GXDBVersions values(2, 'QS_GetClientInfo',  '00000000000000000000', 'QS_GetClientInfo', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_GetClientInfo',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	Qoperation execscript -sn GetClient_Info.sql
'
 + CHAR(10) + '--   script_name : GetClientInfo'
)
GO

