

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_GetClientGroup.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_GetClientGroup <<<'

IF EXISTS (select * from sysobjects where name='QS_GetClientGroup')
	drop procedure QS_GetClientGroup
IF EXISTS (select * from GxQscripts where name='QS_GetClientGroup')
	delete from GxQscripts where name = 'QS_GetClientGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetClientGroup')
	delete from GXDBVersions where aliasname = 'QS_GetClientGroup'
GO
print '... Creating Procedure: QS_GetClientGroup'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_GetClientGroup
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @param1 nvarchar(1030) = '%s'
AS
SET NOCOUNT ON
---------------command line inputs--------------------
--DECLARE @param1  NVARCHAR(1030)
--SET @param1 = '%s'
------------------input prefixes-------------------------
DECLARE @clientPrefix  NVARCHAR(32)
SET @clientPrefix = 'c='
DECLARE @cGroupPrefix NVARCHAR(32)
SET @cGroupPrefix = 'cg='
----------------------script Name-------------------------
DECLARE @scriptName NVARCHAR(100)
SET @scriptName = 'GetClientGroup'
-----------------------error handling-----------------
DECLARE @errorCode int
SET @errorCode = 0
DECLARE @errorString NVARCHAR(1024)
SET @errorString = ''
---------------insufficient parameters --------------------------------
DECLARE @noParameter NVARCHAR(32)
SET @noParameter = '%'
SET @noParameter = @noParameter + 's'
IF @param1 = @noParameter
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Please provide client name or client group name as input.'
	GOTO ARGS_ERROR
END
-----------------------invalid parameters------------------------------
DECLARE @clientName NVARCHAR(1024)
SET @clientName = ''
DECLARE @cGroupName NVARCHAR(1024)
SET @cGroupName = ''
IF SUBSTRING(@param1, 1, 2) = @clientPrefix
	SET @clientName =  SUBSTRING(@param1, 3, LEN(@param1)-2)
ELSE IF SUBSTRING(@param1, 1, 3) = @cGroupPrefix
	SET @cGroupName =  SUBSTRING(@param1, 4, LEN(@param1)-3)
ELSE
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Invalid input ['+@param1+']'
	GOTO ARGS_ERROR
END
IF @clientName = '' AND @cGroupName = ''
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Invalid input ['+@param1+']. Please provide client name or client name as input.'
	GOTO ARGS_ERROR
END
-----------------------invalid parameters II------------------------------
DECLARE @clientId integer
SET @ClientId = ISNULL((SELECT id FROM app_client WHERE name = @clientName), 0)
DECLARE @clientGroupId integer
SET @clientGroupId = ISNULL((SELECT id FROM app_clientgroup WHERE name like @cGroupName), 0)
IF @clientName <> '' AND @clientId = 0
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Client ['+ @clientName +'] does not exist.'
	GOTO ARGS_ERROR
END
IF @cGroupName <> '' AND @clientGroupId = 0
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Client Group ['+ @cGroupName +'] does not exist.'
	GOTO ARGS_ERROR
END
------------------------get clients/client groups------------------------
IF @clientGroupId > 0
	SELECT C.name as 'Client' FROM APP_client C INNER JOIN APP_ClientGroupAssoc CG
				ON C.id = CG. clientId
				WHERE CG.clientGroupId = @clientGroupId
ELSE
	SELECT G.name as 'Client Group' FROM APP_clientGroup G INNER JOIN APP_ClientGroupAssoc CG
				ON G.id = CG. clientgroupId
				WHERE CG.clientId = @clientId
ARGS_ERROR:
print @scriptName + 'completed at '	+ Convert(varchar(60), getdate())+' with parameters client 	['+ @clientName +'] or client group ['+ @cGroupName +']. ErrorCode ('+	Convert(varchar(2),@errorCode) +').'
if @errorCode <> 0
	Raiserror(@errorString,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GetClientGroup')
	delete from GxQscripts where name = 'QS_GetClientGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetClientGroup')
	delete from GXDBVersions where aliasname = 'QS_GetClientGroup'
GO

insert into GXDBVersions values(2, 'QS_GetClientGroup',  '00000000000000000000', 'QS_GetClientGroup', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_GetClientGroup',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn GetClientGroup.sql -si c=client_name/cg=client_group_name
'
 + CHAR(10) + '--   script_name : GetClientGroup'
)
GO

