

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_GetClientDescription.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_GetClientDescription <<<'

IF EXISTS (select * from sysobjects where name='QS_GetClientDescription')
	drop procedure QS_GetClientDescription
IF EXISTS (select * from GxQscripts where name='QS_GetClientDescription')
	delete from GxQscripts where name = 'QS_GetClientDescription'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetClientDescription')
	delete from GXDBVersions where aliasname = 'QS_GetClientDescription'
GO
print '... Creating Procedure: QS_GetClientDescription'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_GetClientDescription
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @clientName varchar(1024) = '%s'
AS
Set NOCOUNT ON
-------------------------------------------
-- INPUTS
-------------------------------------------
--DECLARE @clientName varchar(1024)
--SET @clientName = '%s'
----------------------------------------------
--SET @clientName = 'bingo'
----------------------------------------------
----------------------- const   -----------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'GetClientDescription'
DECLARE @propName varchar(32)
SET @propName  = 'User Description'
--------------------- Local Variables    -------------
DECLARE @lastError				integer
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
SET     @lastError  = 0									-- Be optimistic
DECLARE @NoParameter            varchar(10)
SET     @NoParameter            ='%'                        -- Get Around QScript Parameter
SET     @NoParameter            =@NoParameter + 's'         -- .. Substitution
--------------------- Input validation    -------------
if(@clientName = @NoParameter)
BEGIN
	SET @localErrorMsg = 'Error.  Client Name was not supplied as an input.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
DECLARE @clientId int
SET @clientId = ISNULL((select C.Id from APP_Client C where C.name = @clientName), 0)
IF(@clientId = 0)
BEGIN
	SET @localErrorMsg = 'Error.  Client ['+ @clientName + '] Does not exist.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
--------------------- Get Descrition   -------------
SELECT ClientDescription from APP_Client  where id = @clientId
ARGS_ERROR:
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GetClientDescription')
	delete from GxQscripts where name = 'QS_GetClientDescription'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetClientDescription')
	delete from GXDBVersions where aliasname = 'QS_GetClientDescription'
GO

insert into GXDBVersions values(2, 'QS_GetClientDescription',  '00000000000000000000', 'QS_GetClientDescription', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_GetClientDescription',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn GetClientDescription.sql -si client_name
'
 + CHAR(10) + '--   script_name : GetClientDescription'
)
GO

