

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_GetBarCodesForSMTPAddresses.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_GetBarCodesForSMTPAddresses.sp,v $ $Id: QS_GetBarCodesForSMTPAddresses.sp,v 1.1.2.4 2018/03/22 02:57:08 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_GetBarCodesForSMTPAddresses <<<'

IF EXISTS (select * from sysobjects where name='QS_GetBarCodesForSMTPAddresses')
	drop procedure QS_GetBarCodesForSMTPAddresses
IF EXISTS (select * from GxQscripts where name='QS_GetBarCodesForSMTPAddresses')
	delete from GxQscripts where name = 'QS_GetBarCodesForSMTPAddresses'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetBarCodesForSMTPAddresses')
	delete from GXDBVersions where aliasname = 'QS_GetBarCodesForSMTPAddresses'
GO
print '... Creating Procedure: QS_GetBarCodesForSMTPAddresses'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_GetBarCodesForSMTPAddresses
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @i_smtpAddress NVARCHAR(MAX) = '',
  @i_startDate VARCHAR(32) = '',
  @i_endDate VARCHAR(32) = ''
AS
SET NOCOUNT ON
	-- SET @i_smtpAddress = 'perfex2010mb7002@testex.commvault.com;perfex2010mb8002@testex.commvault.com'
	-- SET @i_startDate = '2013/02/12'
	-- SET @i_endDate = '2013/02/12'
	DECLARE @validation  INT = 1
	DECLARE @localErrorMsg  VARCHAR(256)
	DECLARE @servStartDate	INT = 0
	DECLARE @servEndDate	INT = 0
	DECLARE @tempStartDateTime DATETIME = @i_startDate
	DECLARE @tempEndDateTime DATETIME = @i_endDate
	IF @i_smtpAddress = N''
	BEGIN
		SET @validation = 0
		SET @localErrorMsg = 'Error: Invalid SmptAddress. Please provide SmptAddress with ; seperator!'
		GOTO ARGS_ERROR
	END
	IF @i_startDate <> ''
	BEGIN
		IF ISDATE(@i_startDate) <> 1
		BEGIN
			SET @validation = 0
			SET @localErrorMsg = 'Error: Invalid Start date. Please provide valid date in MM/DD/YYYY format!'
			GOTO ARGS_ERROR
		END
		SET @tempStartDateTime = dbo.ClientLocalToUTCTime(@tempStartDateTime, 2)
		SET @servStartDate = dbo.GetUnixTime(@tempStartDateTime)
	END
	IF @i_endDate <> ''
	BEGIN
		IF ISDATE(@i_endDate) <> 1
		BEGIN
			SET @validation = 0
			SET @localErrorMsg = 'Error: Invalid end date. Please provide valid date in MM/DD/YYYY format!'
			GOTO ARGS_ERROR
		END
		SET @tempEndDateTime = dbo.ClientLocalToUTCTime(@tempEndDateTime, 2)
		SET @servEndDate = dbo.GetUnixTime(@tempEndDateTime)
		SET @servEndDate = @servEndDate + (24*60*60 -1) /*For jobs till end of that day*/
	END
	DECLARE	@smtpAddressTbl TABLE(smtpAddress NVARCHAR(1024))
	DECLARE	@tripletTbl TABLE(name NVARCHAR(2048), smtpAddress NVARCHAR(1024), guidVal varchar(1024), subclientId INT, fromTime INT, toTime INT)
	DECLARE @tempXml XML
	SET @tempXml = N'<t>' + REPLACE(@i_smtpAddress,';','</t><t>') + '</t>'
	INSERT INTO @smtpAddressTbl
	SELECT distinct r.value('.','varchar(1024)') as item
	FROM  @tempXml.nodes('/t') as records(r)
	INSERT INTO @tripletTbl
	SELECT DISTINCT
	attrVal, cast(concat('<x>', REPLACE(attrVal, ' ', '</x><x>'), '</x>') as xml).value('/x[1]','nvarchar(2048)'),
	cast(concat('<x>', REPLACE(attrVal, ' ', '</x><x>'), '</x>') as xml).value('/x[7]','nvarchar(2048)'),
	 componentNameId, created, modified
	FROM APP_SubClientProp(NOLOCK) WHERE attrType = 111
	DELETE From @tripletTbl
	Where guidVal = 'nothing'
	DELETE FROM @tripletTbl
	WHERE smtpAddress NOT IN (SELECT *FROM @smtpAddressTbl)
	SELECT distinct triplet.smtpAddress, MM.BarCode, bkp.jobId, cli.name As Client, bSet.name As Backupset, App.subclientName As Subclient, App.id As SubclientId,
	case when bkp.totalUncompBytes = 0 then bkp.totalBackupSize else bkp.totalUncompBytes end as ApplicationSize,
	 dbo.getDateTime(bkp.servStartDate) as StartDateTime,
	  dbo.getDateTime(bkp.servEndDate) as EndDateTime
	FROM
	@tripletTbl triplet, Jmbkpstats(NOLOCK) bkp, archChunkMapping(NOLOCK) ACM, archChunk(NOLOCK) AC, MMVolume(NOLOCK) MV, MMMedia(NOLOCK) MM,
	App_Application(NOLOCK) App, App_Client(NOLOCK) cli, APP_BackupSetName(NOLOCK) bSet
	WHERE bkp.appId = triplet.subclientId
	AND bkp.status in(1, 3, 14)
	AND (@servStartDate = 0 OR bkp.servStartDate >= @servStartDate)
	AND (@servEndDate = 0 OR bkp.servEndDate <= @servEndDate)
	AND (bkp.servEndDate >= triplet.fromTime AND bkp.servEndDate <= (case when triplet.toTime =0 then dbo.getUnixTime(GETUTCDATE()) else triplet.toTime end)) /*As the subclient Created time is not reliable and for totime considering the current time*/
	AND App.id = bkp.AppId
	AND cli.id = App.clientId
	AND bSet.id = App.backupSet
	AND ACM.jobid = bkp.jobId
	AND ACM.commCellId = bkp.commcellId
	AND ACM.archChunkId = AC.id
	AND ACM.chunkCommCellId = AC.commCellId
	AND AC.volumeId = MV.VolumeId
	AND MM.MediaId = MV.MediaId
	ORDER BY triplet.smtpAddress, bkp.jobid desc
ARGS_ERROR:
SET NOCOUNT OFF
IF @validation = 0
BEGIN
	Raiserror(@localErrorMsg , 15, 1)
	RETURN -1
END
RETURN 0
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GetBarCodesForSMTPAddresses')
	delete from GxQscripts where name = 'QS_GetBarCodesForSMTPAddresses'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GetBarCodesForSMTPAddresses')
	delete from GXDBVersions where aliasname = 'QS_GetBarCodesForSMTPAddresses'
GO

insert into GXDBVersions values(2, 'QS_GetBarCodesForSMTPAddresses',  '00010001000200040000', 'QS_GetBarCodesForSMTPAddresses', '00010001000200040000')
GO

insert into GxQscripts values(2,'QS_GetBarCodesForSMTPAddresses',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn QS_GetBarCodesForSMTPAddresses [-si @i_smptAddress=''perfex2010mb7002@testex.commvault.com;perfex2010mb8002@testex.commvault.com'']  [-si @i_startDate=''02/12/2012''] [-si @i_endDate=''02/20/2015''] 
'
 + CHAR(10) + '--  Options: @i_smptAddress <> NULL, @i_startDate <> NULL, @i_endDate <> NULL, list all the SMTP Address and corresponding barcodes in the given range.'
 + CHAR(10) + '--  Options: @i_smptAddress <> NULL, @i_startDate = NULL, @i_endDate <> NULL, list all the SMTP Address and corresponding barcodes from beginning to toTime specified.'
 + CHAR(10) + '--  Options: @i_smptAddress <> NULL, @i_startDate <> NULL, @i_endDate = NULL, list all the SMTP Address and corresponding barcodes from the specified from time to the end.'
 + CHAR(10) + '--  Options: @i_smptAddress <> NULL, @i_startDate = NULL, @i_endDate = NULL, list all the SMTP Address and corresponding barcodes from the beginning to the end.'
 + CHAR(10) + '-- 	Return list of SMTP Address and corresponding barcodes.'
)
GO

