

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_GenerateBillingReport.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_GenerateBillingReport.sp,v $ $Id: QS_GenerateBillingReport.sp,v 1.6.60.3 2018/11/01 01:33:25 chandru Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_GenerateBillingReport')
BEGIN
	print '>>> Drop Stored Procedure: QS_GenerateBillingReport <<<'
	drop procedure QS_GenerateBillingReport
END
IF EXISTS (select * from GxQscripts where name='QS_GenerateBillingReport')
	delete from GxQscripts where name = 'QS_GenerateBillingReport'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GenerateBillingReport')
	delete from GXDBVersions where aliasname = 'QS_GenerateBillingReport'
GO
print '... Creating Procedure: QS_GenerateBillingReport'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_GenerateBillingReport
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- Stored Procedure Inputs
  @i_asOfTime VARCHAR(1024)='',
  @i_SummaryOnly INTEGER=0
AS
Set NOCOUNT ON
  ---- Convenience Definitions    -----------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'GenerateBillingReport'
DECLARE @lastError				integer
SET		@lastError				= 0
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
DECLARE @NoParameter			varchar(10)
SET     @NoParameter			=''
DECLARE @ErrorString	VARCHAR(1000) = ''
DECLARE @ErrorCode		INT = 0
DECLARE @i_asOfTimeInt		INTEGER
IF (@i_asOfTime = '')
	SET @i_asOfTime = GetUTCDate()
BEGIN TRY
	SET		@i_asOfTimeInt =	dbo.GetUnixTime(dbo.ClientLocalToUTCTime(CAST(@i_asOfTime AS DATETIME), 2))
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SELECT @ErrorCode = ERROR_NUMBER(),@ErrorString = 'Date Conversion failed Error [' + ERROR_MESSAGE() + ']'
	GOTO	SCRIPT_EXIT
END CATCH
CREATE TABLE #TblJob (
	jobId INT, commCellId INT, archGrpCopyId INT, appId INT, appSize BIGINT, backupSize BIGINT, sizeOnMedia BIGINT)
CREATE TABLE #TblCopy (
	archGroupId INT, copyId INT, isPrimaryCopy INT, isDedupeCopy INT, onDisk INT, onTape INT)
CREATE TABLE #AppAgg (
	appId INT, onPrimaryCopy INT, onDedupeCopy INT, onDisk INT, onTapeOffsite INT, appSize BIGINT, sizeOnMedia BIGINT)
CREATE TABLE #AppTypeAgg (
	ClientGroupID INT, ClientID INT, AppTypeID INT,
	PriCopyDeDupeRawSize    BIGINT, PriCopyDeDupeSize    BIGINT,
	PriCopyNonDeDupeRawSize BIGINT, PriCopyNonDeDupeSize BIGINT,
	PriCopyOnSiteRawSize    BIGINT, PriCopyOnSiteSize    BIGINT,
	PriCopyOffSiteRawSize   BIGINT, PriCopyOffSiteSize   BIGINT,
	SecCopyDeDupeRawSize    BIGINT, SecCopyDeDupeSize    BIGINT,
	SecCopyNonDeDupeRawSize BIGINT, SecCopyNonDeDupeSize BIGINT,
	SecCopyOnSiteRawSize    BIGINT, SecCopyOnSiteSize    BIGINT,
	SecCopyOffSiteRawSize   BIGINT, SecCopyOffSiteSize   BIGINT)
INSERT INTO #TblJob
SELECT	jobId, commCellId, archGrpCopyId, appId, 0, 0, SUM(sizeOnMedia)
FROM	JMJobDataStats
WHERE	copiedTime <= @i_asOfTimeInt AND (agedTime = 0 OR agedTime > @i_asOfTimeInt)
GROUP BY jobId, commCellId, archGrpCopyId, appId
UPDATE	#TblJob
SET		appSize = B.totalUncompBytes, backupSize = B.totalBackupSize
FROM	JMBkpStats B WITH (NOLOCK)
WHERE	#TblJob.jobId = B.jobId AND #TblJob.commCellId = B.commCellId
	AND B.status IN (1, 3, 14) AND B.totalBackupSize > 0
INSERT INTO #TblCopy
SELECT	S.archGroupId, S.archGroupCopyId,
		CASE WHEN S.archGroupCopyId IN (AG.defaultCopy, AG.defaultSnapCopy) THEN 1 ELSE 0 END,
CASE WHEN ((AGC.dedupeFlags & 262144) > 0) THEN 1 ELSE 0 END,
		MAX(CASE V.RecordingFormatId WHEN 10001 THEN 1 ELSE 0 END),
		MIN(CASE V.RecordingFormatId WHEN 10001 THEN 0 ELSE 1 END)
FROM	archGroup AG WITH (NOLOCK)
		INNER JOIN archGroupCopy AGC WITH (NOLOCK) ON AGC.archGroupId = AG.id AND AG.id > 1
		INNER JOIN archStream S WITH (NOLOCK) ON S.archGroupCopyId = AGC.id
		INNER JOIN MMVolume V WITH (NOLOCK) ON V.MediaGroupId = S.mediaGroupId
GROUP BY S.archGroupId, S.archGroupCopyId,
		CASE WHEN S.archGroupCopyId IN (AG.defaultCopy, AG.defaultSnapCopy) THEN 1 ELSE 0 END,
CASE WHEN ((AGC.dedupeFlags & 262144) > 0) THEN 1 ELSE 0 END
-- disk copies
INSERT INTO #AppAgg
SELECT	J.appId, C.isPrimaryCopy, C.isDedupeCopy, 1, 0, SUM(J.appSize), SUM(J.sizeOnMedia)
FROM	#TblJob J  WITH (NOLOCK)
		INNER JOIN #TblCopy C ON C.copyId = J.archGrpCopyId AND C.onDisk = 1 AND C.onTape = 0
GROUP BY J.appId, C.isPrimaryCopy, C.isDedupeCopy
-- tape copies and tape-disk mixed copies
INSERT INTO #AppAgg
SELECT	J.appId, C.isPrimaryCopy, C.isDedupeCopy,
		CASE WHEN M.MediaTypeId = 10001 THEN 1 ELSE 0 END,
		CASE WHEN M.MediaTypeId <> 10001 AND M.MediaLocation > 2 THEN 1 ELSE 0 END,
		SUM(ACM.physicalSize*(1.0*J.appSize/J.backupSize)),
		SUM(ACM.dedupedSize)
FROM	#TblJob J  WITH (NOLOCK)
		INNER JOIN #TblCopy C ON C.copyId = J.archGrpCopyId AND C.onTape = 1 AND J.backupSize > 0
		INNER JOIN archFile AF WITH (NOLOCK) ON AF.jobId = J.jobId AND AF.commCellId = J.commCellId AND AF.isValid = 1
		INNER JOIN archChunkMapping ACM WITH (NOLOCK) ON ACM.archFileId = AF.id AND ACM.commCellId = AF.commCellId AND ACM.archCopyId = J.archGrpCopyId
		INNER JOIN archChunk AC WITH (NOLOCK) ON AC.id = ACM.archChunkId AND AC.commCellId = ACM.chunkCommCellId
		INNER JOIN MMVolume V WITH (NOLOCK) ON V.VolumeId = AC.volumeId
		INNER JOIN MMMedia M WITH (NOLOCK) ON M.MediaId = V.MediaId
GROUP BY J.appId, C.isPrimaryCopy, C.isDedupeCopy,
		CASE WHEN M.MediaTypeId = 10001 THEN 1 ELSE 0 END,
		CASE WHEN M.MediaTypeId <> 10001 AND M.MediaLocation > 2 THEN 1 ELSE 0 END
DROP TABLE #TblJob
DROP TABLE #TblCopy
INSERT INTO #AppTypeAgg
SELECT	ISNULL(CGA.clientGroupId, 2147483647), A.clientId, A.appTypeId,
		SUM(CASE WHEN T.onPrimaryCopy = 1 AND T.onDisk = 1 AND T.onDedupeCopy  = 1 THEN T.appSize ELSE 0 END),
		SUM(CASE WHEN T.onPrimaryCopy = 1 AND T.onDisk = 1 AND T.onDedupeCopy  = 1 THEN T.sizeOnMedia ELSE 0 END),
		SUM(CASE WHEN T.onPrimaryCopy = 1 AND T.onDisk = 1 AND T.onDedupeCopy  = 0 THEN T.appSize ELSE 0 END),
		SUM(CASE WHEN T.onPrimaryCopy = 1 AND T.onDisk = 1 AND T.onDedupeCopy  = 0 THEN T.sizeOnMedia ELSE 0 END),
		SUM(CASE WHEN T.onPrimaryCopy = 1 AND T.onDisk = 0 AND T.onTapeOffsite = 0 THEN T.appSize ELSE 0 END),
		SUM(CASE WHEN T.onPrimaryCopy = 1 AND T.onDisk = 0 AND T.onTapeOffsite = 0 THEN T.sizeOnMedia ELSE 0 END),
		SUM(CASE WHEN T.onPrimaryCopy = 1 AND T.onDisk = 0 AND T.onTapeOffsite = 1 THEN T.appSize ELSE 0 END),
		SUM(CASE WHEN T.onPrimaryCopy = 1 AND T.onDisk = 0 AND T.onTapeOffsite = 1 THEN T.sizeOnMedia ELSE 0 END),
		SUM(CASE WHEN T.onPrimaryCopy = 0 AND T.onDisk = 1 AND T.onDedupeCopy  = 1 THEN T.appSize ELSE 0 END),
		SUM(CASE WHEN T.onPrimaryCopy = 0 AND T.onDisk = 1 AND T.onDedupeCopy  = 1 THEN T.sizeOnMedia ELSE 0 END),
		SUM(CASE WHEN T.onPrimaryCopy = 0 AND T.onDisk = 1 AND T.onDedupeCopy  = 0 THEN T.appSize ELSE 0 END),
		SUM(CASE WHEN T.onPrimaryCopy = 0 AND T.onDisk = 1 AND T.onDedupeCopy  = 0 THEN T.sizeOnMedia ELSE 0 END),
		SUM(CASE WHEN T.onPrimaryCopy = 0 AND T.onDisk = 0 AND T.onTapeOffsite = 0 THEN T.appSize ELSE 0 END),
		SUM(CASE WHEN T.onPrimaryCopy = 0 AND T.onDisk = 0 AND T.onTapeOffsite = 0 THEN T.sizeOnMedia ELSE 0 END),
		SUM(CASE WHEN T.onPrimaryCopy = 0 AND T.onDisk = 0 AND T.onTapeOffsite = 1 THEN T.appSize ELSE 0 END),
		SUM(CASE WHEN T.onPrimaryCopy = 0 AND T.onDisk = 0 AND T.onTapeOffsite = 1 THEN T.sizeOnMedia ELSE 0 END)
FROM	#AppAgg T,
		APP_Application A WITH (NOLOCK)
		LEFT OUTER JOIN APP_ClientGroupAssoc CGA WITH (NOLOCK) ON A.clientId = CGA.clientId
WHERE	T.AppId = A.id AND A.appTypeId < 600
GROUP BY CGA.clientGroupId, A.clientId, A.appTypeId
DROP TABLE #AppAgg
SELECT	(CASE WHEN ClientGroupID = 0 THEN 'Grand Total' ELSE ISNULL((SELECT name FROM APP_ClientGroup CG WHERE T.clientGroupId = id), 'No ClientGroup') END) AS ClientGroup ,
		(CASE WHEN ClientID = 0 AND ClientGroupID <> 0 THEN 'Total' ELSE ISNULL((SELECT name FROM APP_Client C WHERE T.clientId = id), '') END) AS Client,
		ISNULL((SELECT name FROM APP_iDAType I WHERE T.appTypeId = type AND T.appTypeId <> 0), '') AS AppType,
		T.[Primary Copy(DeDupe) RAW GB],
		T.[Primary Copy(DeDupe) GB],
		T.[Primary Copy(NonDeDupe Disk) RAW GB],
		T.[Primary Copy(NonDeDupe Disk) GB],
		T.[Primary Copy(Onsite Tape) RAW GB],
		T.[Primary Copy(Onsite Tape) GB],
		T.[Primary Copy(offsite Tape) RAW GB],
		T.[Primary Copy(offsite Tape) GB],
		T.[Secondary Copy(DeDupe) RAW GB],
		T.[Secondary Copy(DeDupe) GB],
		T.[Secondary Copy(NonDeDupe Disk) RAW GB],
		T.[Secondary Copy(NonDeDupe Disk) GB],
		T.[Secondary Copy(Onsite Tape) RAW GB],
		T.[Secondary Copy(Onsite Tape) GB],
		T.[Secondary Copy(offsite Tape) RAW GB],
		T.[Secondary Copy(offsite Tape) GB]
FROM
(
	SELECT	ClientGroupID, ClientID, AppTypeID,
			SUM(PriCopyDedupeRawSize)/1024/1024/1024    AS 'Primary Copy(DeDupe) RAW GB',
			SUM(PriCopyDeDupeSize)/1024/1024/1024       AS 'Primary Copy(DeDupe) GB',
			SUM(PriCopyNonDedupeRawSize)/1024/1024/1024 AS 'Primary Copy(NonDeDupe Disk) RAW GB',
			SUM(PriCopyNonDeDupeSize)/1024/1024/1024    AS 'Primary Copy(NonDeDupe Disk) GB',
			SUM(PriCopyOnSiteRawSize)/1024/1024/1024    AS 'Primary Copy(Onsite Tape) RAW GB',
			SUM(PriCopyOnSiteSize)/1024/1024/1024       AS 'Primary Copy(Onsite Tape) GB',
			SUM(PriCopyOffSiteRawSize)/1024/1024/1024   AS 'Primary Copy(offsite Tape) RAW GB',
			SUM(PriCopyOffSiteSize)/1024/1024/1024      AS 'Primary Copy(offsite Tape) GB',
			SUM(SecCopyDedupeRawSize)/1024/1024/1024    AS 'Secondary Copy(DeDupe) RAW GB',
			SUM(SecCopyDeDupeSize)/1024/1024/1024       AS 'Secondary Copy(DeDupe) GB',
			SUM(SecCopyNonDedupeRawSize)/1024/1024/1024 AS 'Secondary Copy(NonDeDupe Disk) RAW GB',
			SUM(SecCopyNonDeDupeSize)/1024/1024/1024    AS 'Secondary Copy(NonDeDupe Disk) GB',
			SUM(SecCopyOnSiteRawSize)/1024/1024/1024    AS 'Secondary Copy(Onsite Tape) RAW GB',
			SUM(SecCopyOnSiteSize)/1024/1024/1024       AS 'Secondary Copy(Onsite Tape) GB',
			SUM(SecCopyOffSiteRawSize)/1024/1024/1024   AS 'Secondary Copy(offsite Tape) RAW GB',
			SUM(SecCopyOffSiteSize)/1024/1024/1024      AS 'Secondary Copy(offsite Tape) GB'
	FROM    #AppTypeAgg
	GROUP BY ClientGroupID, ClientID, AppTypeID
	UNION ALL
	SELECT	ClientGroupID, 0, 0,
			SUM(PriCopyDedupeRawSize)/1024/1024/1024    AS 'Primary Copy(DeDupe) RAW GB',
			SUM(PriCopyDeDupeSize)/1024/1024/1024       AS 'Primary Copy(DeDupe) GB',
			SUM(PriCopyNonDedupeRawSize)/1024/1024/1024 AS 'Primary Copy(NonDeDupe Disk) RAW GB',
			SUM(PriCopyNonDeDupeSize)/1024/1024/1024    AS 'Primary Copy(NonDeDupe Disk) GB',
			SUM(PriCopyOnSiteRawSize)/1024/1024/1024    AS 'Primary Copy(Onsite Tape) RAW GB',
			SUM(PriCopyOnSiteSize)/1024/1024/1024       AS 'Primary Copy(Onsite Tape) GB',
			SUM(PriCopyOffSiteRawSize)/1024/1024/1024   AS 'Primary Copy(offsite Tape) RAW GB',
			SUM(PriCopyOffSiteSize)/1024/1024/1024      AS 'Primary Copy(offsite Tape) GB',
			SUM(SecCopyDedupeRawSize)/1024/1024/1024    AS 'Secondary Copy(DeDupe) RAW GB',
			SUM(SecCopyDeDupeSize)/1024/1024/1024       AS 'Secondary Copy(DeDupe) GB',
			SUM(SecCopyNonDedupeRawSize)/1024/1024/1024 AS 'Secondary Copy(NonDeDupe Disk) RAW GB',
			SUM(SecCopyNonDeDupeSize)/1024/1024/1024    AS 'Secondary Copy(NonDeDupe Disk) GB',
			SUM(SecCopyOnSiteRawSize)/1024/1024/1024    AS 'Secondary Copy(Onsite Tape) RAW GB',
			SUM(SecCopyOnSiteSize)/1024/1024/1024       AS 'Secondary Copy(Onsite Tape) GB',
			SUM(SecCopyOffSiteRawSize)/1024/1024/1024   AS 'Secondary Copy(offsite Tape) RAW GB',
			SUM(SecCopyOffSiteSize)/1024/1024/1024      AS 'Secondary Copy(offsite Tape) GB'
	FROM	#AppTypeAgg
	GROUP BY clientGroupId
	UNION ALL
	SELECT	0, 0, 0,
			SUM(PriCopyDedupeRawSize)/1024/1024/1024    AS 'Primary Copy(DeDupe) RAW GB',
			SUM(PriCopyDeDupeSize)/1024/1024/1024       AS 'Primary Copy(DeDupe) GB',
			SUM(PriCopyNonDedupeRawSize)/1024/1024/1024 AS 'Primary Copy(NonDeDupe Disk) RAW GB',
			SUM(PriCopyNonDeDupeSize)/1024/1024/1024    AS 'Primary Copy(NonDeDupe Disk) GB',
			SUM(PriCopyOnSiteRawSize)/1024/1024/1024    AS 'Primary Copy(Onsite Tape) RAW GB',
			SUM(PriCopyOnSiteSize)/1024/1024/1024       AS 'Primary Copy(Onsite Tape) GB',
			SUM(PriCopyOffSiteRawSize)/1024/1024/1024   AS 'Primary Copy(offsite Tape) RAW GB',
			SUM(PriCopyOffSiteSize)/1024/1024/1024      AS 'Primary Copy(offsite Tape) GB',
			SUM(SecCopyDedupeRawSize)/1024/1024/1024    AS 'Secondary Copy(DeDupe) RAW GB',
			SUM(SecCopyDeDupeSize)/1024/1024/1024       AS 'Secondary Copy(DeDupe) GB',
			SUM(SecCopyNonDedupeRawSize)/1024/1024/1024 AS 'Secondary Copy(NonDeDupe Disk) RAW GB',
			SUM(SecCopyNonDeDupeSize)/1024/1024/1024    AS 'Secondary Copy(NonDeDupe Disk) GB',
			SUM(SecCopyOnSiteRawSize)/1024/1024/1024    AS 'Secondary Copy(Onsite Tape) RAW GB',
			SUM(SecCopyOnSiteSize)/1024/1024/1024       AS 'Secondary Copy(Onsite Tape) GB',
			SUM(SecCopyOffSiteRawSize)/1024/1024/1024   AS 'Secondary Copy(offsite Tape) RAW GB',
			SUM(SecCopyOffSiteSize)/1024/1024/1024      AS 'Secondary Copy(offsite Tape) GB'
	FROM	#AppTypeAgg
	) T
ORDER BY clientGroupId, clientId, appTypeId
DROP TABLE #AppTypeAgg
SCRIPT_EXIT:
if @ErrorCode <> 0
	Raiserror(@ErrorString,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
set nocount off
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GenerateBillingReport')
	delete from GxQscripts where name = 'QS_GenerateBillingReport'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GenerateBillingReport')
	delete from GXDBVersions where aliasname = 'QS_GenerateBillingReport'
GO

insert into GXDBVersions values(2, 'QS_GenerateBillingReport',  '00010006006000030000', 'QS_GenerateBillingReport', '00010006006000030000')
GO

insert into GxQscripts values(2,'QS_GenerateBillingReport',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 			qoperation execscript -sn GenerateBillingReport -si <AsOfTime> -si <SummaryOnly> '
 + CHAR(10) + '-- 			Ex: qoperation execscript -sn GenerateBillingReport -si "2009-11-04 00:00:00" -si 0'
)
GO

