

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_GenerateAuxCopyPriorityListFile.sp] ---------- 

  -- ----------------------------------------------------------------------
  --
 --           Copyright (c) 1998  CommVault Systems, Inc.
 --                  All rights reserved.
 --
 --
 --        This is unpublished proprietary source code of CommVault
 --        Systems, Inc. The copyright notice above does not evidence
 --        any actual or intended publication of such source code.
 -- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_GenerateAuxCopyPriorityListFile')
BEGIN
	print '>>> Drop Stored Procedure: QS_GenerateAuxCopyPriorityListFile <<<'
	drop procedure QS_GenerateAuxCopyPriorityListFile
END
IF EXISTS (select * from GxQscripts where name='QS_GenerateAuxCopyPriorityListFile')
	delete from GxQscripts where name = 'QS_GenerateAuxCopyPriorityListFile'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GenerateAuxCopyPriorityListFile')
	delete from GXDBVersions where aliasname = 'QS_GenerateAuxCopyPriorityListFile'
GO
print '... Creating Procedure: QS_GenerateAuxCopyPriorityListFile'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_GenerateAuxCopyPriorityListFile
--Modified for Checkin
--QScript is enabled
-- QScript secure this script does the user validation
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
-- SP Input Params
  @i_StoragePolicy NVARCHAR(2048) = N'',
  @i_StoragePolicyCopy NVARCHAR(2048) = N'',
  @i_FileName NVARCHAR(1024) = N''
AS
SET NOCOUNT ON
DECLARE @errorCode INTEGER = 0
DECLARE @ErrorMessage NVARCHAR(MAX) = N''
DECLARE @l_SPId INTEGER = -1
DECLARE @l_defaultSPCId INTEGER = -1
DECLARE @l_SPCId INTEGER = -1
DECLARE @l_SPCType INTEGER = -1
DECLARE @l_IsSnapCopy INTEGER = -1
DECLARE @l_currentTime INTEGER = dbo.GetUnixTime(GetUTCDate())
DECLARE @isOsWindows BIT = dbo.IsOSOnCSWindows()
	SELECT @l_SPId = Id, @l_defaultSPCId = defaultCopy
	FROM archGroup WITH (NOLOCK)
	WHERE name = @i_StoragePolicy
	SELECT	@errorCode = @@ERROR, @ErrorMessage = ERROR_MESSAGE()
	IF	@errorCode <> 0 GOTO CX_EXIT
	IF @l_SPId = -1
	BEGIN
		SET	@errorCode = -1
		GOTO CX_EXIT
	END
	SELECT @l_SPCId = id, @l_SPCType = type, @l_IsSnapCopy = isSnapCopy
	FROM archGroupCopy WITH (NOLOCK)
	WHERE	name = @i_StoragePolicyCopy
			AND archGroupId = @l_SPId
	SELECT	@errorCode = @@ERROR, @ErrorMessage = ERROR_MESSAGE()
	IF	@errorCode <> 0 GOTO CX_EXIT
	IF @l_SPCId = -1
	BEGIN
		SET	@errorCode = -2
		GOTO CX_EXIT
	END
	IF @l_SPCId = @l_defaultSPCId
	BEGIN
		SET	@errorCode = -4
		GOTO CX_EXIT
	END
	/* Not Applicable
	IF @l_SPCType != 2
	BEGIN
		SET	@errorCode = -3
		GOTO CX_EXIT
	END
	*/
	IF @l_IsSnapCopy = 1
	BEGIN
		SET	@errorCode = -5
		GOTO CX_EXIT
	END
	DECLARE	@InstallDir as NVARCHAR(1024)
	DECLARE	@SrcFilePath as NVARCHAR(1024)
	DECLARE	@DestFilePath as NVARCHAR(1024)
	DECLARE @RetCode int = 0 , @FileSystem int = 0, @srcFileHandle int = 0, @destFileHandle int = 0
	IF @isOsWindows = 1
	BEGIN
		EXECUTE @RetCode = sp_OACreate 'Scripting.FileSystemObject' , @FileSystem OUTPUT
		IF (@@ERROR != 0 OR @RetCode != 0 OR @FileSystem < 0)
		BEGIN
			IF (@FileSystem > 0)
				EXEC sp_OADestroy @FileSystem
			SET	@errorCode = -6
			GOTO CX_EXIT
		END
	END
	SELECT	TOP 1 @InstallDir = install_dir + '\Base\'
	FROm	APP_Platform
	WHERE	platformType = 1
	SELECT	@errorCode = @@ERROR, @ErrorMessage = ERROR_MESSAGE()
	IF	@errorCode <> 0 GOTO CX_EXIT
	SET	@SrcFilePath = @InstallDir + @i_FileName
	SET	@DestFilePath = @InstallDir + 'SP_' + CAST(@l_SPId AS VARCHAR(10)) + '_SPC_' + CAST(@l_SPCId AS VARCHAR(10)) + '_Jobs.txt'
	IF @isOsWindows = 1
	BEGIN
		EXEC @RetCode = sp_OAMethod @FileSystem, 'GetFile', @srcFileHandle OUTPUT, @SrcFilePath
		IF (@@ERROR != 0 OR @RetCode != 0 OR @FileSystem < 0)
		BEGIN
			IF (@FileSystem > 0)
				EXEC sp_OADestroy @FileSystem
			SET	@errorCode = -7
			GOTO CX_EXIT
		END
		EXEC @RetCode = sp_OAMethod @FileSystem, 'copyFile' , NULL, @SrcFilePath, @DestFilePath
		IF (@@ERROR != 0 OR @RetCode != 0 OR @FileSystem < 0)
		BEGIN
			IF (@srcFileHandle > 0)
			BEGIN
				EXECUTE @RetCode = sp_OAMethod @srcFileHandle , 'Close' , NULL
				IF (@@ERROR = 0 AND @RetCode = 0)
					EXEC sp_OADestroy @srcFileHandle
			END
			IF (@FileSystem > 0)
				EXEC sp_OADestroy @FileSystem
			SET	@errorCode = -8
			GOTO CX_EXIT
		END
	END
	ELSE
	BEGIN
		EXECUTE cv_spCopyFile @SrcFilePath , @DestFilePath, @errorMessage OUTPUT, 1
		IF LEN(@errorMessage)>0
		BEGIN
			SET @errorCode = -10
		END
	END
CX_EXIT:
	IF @errorCode = -1
		SET @ErrorMessage = 'Error: Invalid Storage Policy Name [' + @i_StoragePolicy + ']'
	ELSE IF @errorCode = -2
		SET @ErrorMessage = 'Error: Invalid Storage Policy Copy Name [' + @i_StoragePolicyCopy + ']'
	ELSE IF @errorCode = -3
		SET @ErrorMessage = 'Error: Storage Policy [' + @i_StoragePolicy + '] Storage Policy Copy [' + @i_StoragePolicyCopy + '] is not a selective copy'
	ELSE IF @errorCode = -4
		SET @ErrorMessage = 'Error: Storage Policy [' + @i_StoragePolicy + '] Storage Policy Copy [' + @i_StoragePolicyCopy + '] is primary copy'
	ELSE IF @errorCode = -5
		SET @ErrorMessage = 'Error: Storage Policy [' + @i_StoragePolicy + '] Storage Policy Copy [' + @i_StoragePolicyCopy + '] is a snap copy'
	ELSE IF @errorCode = -6
		SET @ErrorMessage = 'Error: Unable to create file system object'
	ELSE IF @errorCode = -7
		SET @ErrorMessage = 'Error: Unable to access file [' + @i_FileName + ']'
	ELSE IF @errorCode = -8
		SET @ErrorMessage = 'Error: Unable to copy file from [' + @SrcFilePath + '] to [' +  @DestFilePath + ']'
	ELSE IF @errorCode <> 0
		SET @ErrorMessage = 'Error: Failed to execute script. Error code [' + CAST(@errorCode AS VARCHAR(20)) + '], Error Message [' + @ErrorMessage + ']'
	ELSE
		SET @ErrorMessage = 'GenerateAuxCopyPriorityListFile completed successfully at '	+ CONVERT(VARCHAR(60), GETDATE())+' and file path is [' + @DestFilePath +'].'
	IF @errorCode NOT IN (0)
		Raiserror(@ErrorMessage,
					15,  --Severity (> 10 to force DOS Error Code = 1)
					1	 --State
					)
	ELSE
		SELECT	@ErrorMessage
	RETURN  @errorCode
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_GenerateAuxCopyPriorityListFile')
	delete from GxQscripts where name = 'QS_GenerateAuxCopyPriorityListFile'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_GenerateAuxCopyPriorityListFile')
	delete from GXDBVersions where aliasname = 'QS_GenerateAuxCopyPriorityListFile'
GO

insert into GXDBVersions values(2, 'QS_GenerateAuxCopyPriorityListFile',  '00000000000000000000', 'QS_GenerateAuxCopyPriorityListFile', '00000000000000000000')
GO

insert into GxQscripts values(2+8,'QS_GenerateAuxCopyPriorityListFile',  0, GETDATE(), GETDATE(), '' + CHAR(10) + ' qoperation execscript -sn GenerateAuxCopyPriorityListFile -si StoragePolicyName -si StoragePolicyCopyName -si FileName 
'
 + CHAR(10) + ' script_name : GenerateAuxCopyPriorityListFile
'
)
GO

