

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_FrontendCapacityUsage.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_FrontendCapacityUsage.sp,v $ $Id: QS_FrontendCapacityUsage.sp,v 1.4.192.2.68.1 2021/03/04 09:35:06 leiwang Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='QS_FrontendCapacityUsage')
BEGIN
	print '>>> Drop Stored Procedure: QS_FrontendCapacityUsage <<<'
	drop procedure QS_FrontendCapacityUsage
END
IF EXISTS (select * from GxQscripts where name='QS_FrontendCapacityUsage')
	delete from GxQscripts where name = 'QS_FrontendCapacityUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_FrontendCapacityUsage')
	delete from GXDBVersions where aliasname = 'QS_FrontendCapacityUsage'
GO
print '... Creating Procedure: QS_FrontendCapacityUsage'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure QS_FrontendCapacityUsage
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
  @Frequency VARCHAR(1024)='Weekly',
  @NumberOfPoints INTEGER=4,
  @PredictionPoints INTEGER=1,
  @CostPerGB FLOAT=1,
  @AddlCostPerGB FLOAT=0,
  @IncludeCurrentPeriod INTEGER=0
AS
SET NOCOUNT ON
DECLARE @timeFrameType              INT =1 -- relative
DECLARE @freq                  INT  -- RelTimeFreq {Day = 1, Week = 2, Month = 3, Hour = 4, Year = 6}
DECLARE @BackupFrom		VARCHAR(32) = '18:00'
IF ( @Frequency LIKE 'Weekly')
	SET @freq = 2
ELSE IF ( @Frequency LIKE 'Daily')
	SET @freq = 1
ELSE IF ( @Frequency LIKE 'Monthly')
	SET @freq = 3
ELSE IF ( @Frequency LIKE 'Yearly')
	SET @freq = 6
DECLARE @numberOfPeriods            INT = @NumberOfPoints
DECLARE @predictionSteps            INT = @PredictionPoints
DECLARE @reqStartTime				INT =0
DECLARE @reqEndTime					INT =0
DECLARE @treatWeekend				INT =1
DECLARE @totalCostPerGB				FLOAT = ( @CostPerGB + @AddlCostPerGB )
DECLARE @csName VARCHAR(256) = (SELECT aliasName FROM APP_CommCell WHERE id = 2)
DECLARE @csTimeZone	VARCHAR(256)
SELECT	@csTimeZone	= timeZone FROM APP_CommCell WHERE id = 2
SELECT	@csTimeZone = TimeZoneStdName FROM SchedTimeZone
WHERE	TimeZoneName= SUBSTRING(@csTimeZone, CHARINDEX(':', @csTimeZone, CHARINDEX(':', @csTimeZone, 0) + 1) + 1, 255)
IF OBJECT_ID('tempdb.dbo.#GrowthAndTranding_tmp__PeriodsRaw')       IS NOT NULL DROP TABLE #GrowthAndTranding_tmp__PeriodsRaw
IF OBJECT_ID('tempdb.dbo.#GrowthAndTranding_tmp__Periods')          IS NOT NULL DROP TABLE #GrowthAndTranding_tmp__Periods
IF OBJECT_ID('tempdb.dbo.#GrowthAndTranding_tmp__HistoryData')      IS NOT NULL DROP TABLE #GrowthAndTranding_tmp__HistoryData
IF OBJECT_ID('tempdb.dbo.#GrowthAndTranding_tmp__PredictedData')    IS NOT NULL DROP TABLE #GrowthAndTranding_tmp__PredictedData
IF OBJECT_ID('tempdb.dbo.#GrowthAndTranding_tmp__HistoryData')      IS NOT NULL DROP TABLE #GrowthAndTranding_tmp__HistoryData
DECLARE @const_AGG_LICS_ENT_BKP		INT = 0x0200000
DECLARE @const_AGG_LICS_CORE_BKP	INT = 0x0400000
DECLARE @const_AGG_LICS_ENT_ARC		INT = 0x0800000
DECLARE @const_AGG_LICS_CORE_ARC	INT = 0x1000000
DECLARE @const_AGG_LICS				INT = (@const_AGG_LICS_ENT_BKP|@const_AGG_LICS_CORE_BKP|@const_AGG_LICS_ENT_ARC|@const_AGG_LICS_CORE_ARC)
CREATE TABLE #GrowthAndTranding_tmp__PeriodsRaw
(
    commCellId              INT,
    dayNum                  INT,
    dayRefStart             DATETIME,
    dayRefEnd               DATETIME,
    dayStart                DATETIME,
    dayEnd                  DATETIME,
    predicted               INT,
    dayRefStartLocal        DATETIME,
    dayRefEndLocal          DATETIME,
    dayRefStartUnix         INT,
    dayRefEndUnix           INT,
    dayStartUnix            INT,
    dayEndUnix              INT,
    dayRefStartLocalUnix    INT,
    dayRefEndLocalUnix      INT
)
CREATE TABLE #GrowthAndTranding_tmp__Periods
(
    periodId            INT     IDENTITY(1,1)   NOT NULL,
    predicted           BIT                     NOT NULL,
    DayNo               INT                     NOT NULL,
    periodStart         INT                     NOT NULL,
    periodEnd           INT                     NOT NULL,
    periodStartDT       DATETIME                NOT NULL,
    periodEndDT         DATETIME                NOT NULL
)
CREATE TABLE #GrowthAndTranding_tmp__HistoryData
(
    periodId            INT,
    entityType          INT,
	doNotPlot			INT,
    value               BIGINT
)
CREATE TABLE #GrowthAndTranding_tmp__PredictedData
(
    entityType          INT,
    growthRate          FLOAT
)
--check if core backup license exists
DECLARE @permTotal INT    = 0
DECLARE @permUsed  INT   = 0
DECLARE @permFld  varchar(1024)
DECLARE @combineDP INT =0
SELECT @permFld = perm_fld1 FROM LicAal WHERE simLicAppTypeId =100001
IF @permFld IS NOT NULL
	EXEC MASTER.dbo.xp_getAALInfo @permFld, @permTotal OUTPUT, @permUsed OUTPUT
IF ( @permTotal = 0 )
BEGIN
SET @combineDP =1
END
SET @permTotal    = 0
SET @permUsed     = 0
DECLARE @combineArchive INT =0
SELECT @permFld = perm_fld1 FROM LicAal WHERE simLicAppTypeId =100003
IF @permFld IS NOT NULL
	EXEC MASTER.dbo.xp_getAALInfo @permFld, @permTotal OUTPUT, @permUsed OUTPUT
IF ( @permTotal = 0 )
BEGIN
SET @combineArchive =1
END
EXEC dbo.wr_BuildDaysRange  2, '#GrowthAndTranding_tmp__PeriodsRaw', @timeFrameType, @numberOfPeriods, @freq, @reqStartTime, @reqEndTime, @treatWeekend, 0, 1, 10, @predictionSteps, @IncludeCurrentPeriod, @BackupFrom
-- -- get only the values we are going to work with
INSERT INTO #GrowthAndTranding_tmp__Periods (predicted, DayNo, periodStart, periodEnd, periodStartDT, periodEndDT)
    SELECT  predicted, dayNum, dayStartUnix, dayEndUnix, dayStart, dayEnd
    FROM    #GrowthAndTranding_tmp__PeriodsRaw
    ORDER   BY dayStart ASC
-- -- no need for #GrowthAndTranding_tmp__PeriodsRaw table any more. kill it
DROP TABLE #GrowthAndTranding_tmp__PeriodsRaw
IF (@combineDP = 0 ) BEGIN
	INSERT INTO #GrowthAndTranding_tmp__HistoryData
			  -- enterprise backup
	SELECT  P.periodId, @const_AGG_LICS_ENT_BKP, 0,
			ISNULL((SELECT MAX(EnterpriseBackupSize) FROM LicUsageDetailsHistory LUHH WHERE  [date] BETWEEN P.periodStart AND P.periodEnd),0)
	FROM    #GrowthAndTranding_tmp__Periods P
	UNION ALL -- core backup
	SELECT  P.periodId, @const_AGG_LICS_CORE_BKP, 0,
			ISNULL((SELECT MAX(CoreBackupSize) FROM LicUsageDetailsHistory LUHH WHERE  [date] BETWEEN P.periodStart AND P.periodEnd),0)
	FROM    #GrowthAndTranding_tmp__Periods P
END
ELSE BEGIN
	INSERT INTO #GrowthAndTranding_tmp__HistoryData
	SELECT  P.periodId, @const_AGG_LICS_ENT_BKP, 0,
			ISNULL((SELECT MAX(T.value) FROM (SELECT SUM(CoreBackupSize+EnterpriseBackupSize) as value, date FROM LicUsageDetailsHistory LUHH group by date) T
			WHERE  T.date BETWEEN P.periodStart AND P.periodEnd),0)
	FROM    #GrowthAndTranding_tmp__Periods P
END
IF ( @combineArchive = 0) BEGIN
	INSERT INTO #GrowthAndTranding_tmp__HistoryData
	SELECT  P.periodId, @const_AGG_LICS_ENT_ARC, 0,
			ISNULL((SELECT MAX(EnterpriseArchiveSize) FROM LicUsageDetailsHistory LUHH WHERE  [date] BETWEEN P.periodStart AND P.periodEnd),0)
	FROM    #GrowthAndTranding_tmp__Periods P
	UNION ALL -- core archive
	SELECT  P.periodId, @const_AGG_LICS_CORE_ARC, 0,
			ISNULL((SELECT MAX(CoreArchiveSize) FROM LicUsageDetailsHistory LUHH WHERE  [date] BETWEEN P.periodStart AND P.periodEnd),0)
	FROM    #GrowthAndTranding_tmp__Periods P WHERE @combineArchive <> 0
END
ELSE BEGIN
	INSERT INTO #GrowthAndTranding_tmp__HistoryData
	SELECT  P.periodId, @const_AGG_LICS_ENT_ARC, 0,
			ISNULL((SELECT MAX(T.value) FROM (SELECT SUM(CoreArchiveSize+EnterpriseArchiveSize) as value, date FROM LicUsageDetailsHistory LUHH group by date) T
			WHERE  T.date BETWEEN P.periodStart AND P.periodEnd),0)
	FROM    #GrowthAndTranding_tmp__Periods P
END
DECLARE @maxRealPeriodId INT = (SELECT MAX(periodId) FROM #GrowthAndTranding_tmp__Periods WHERE predicted = 0)
DECLARE @currentEntityType INT = (SELECT MIN(entityType) FROM #GrowthAndTranding_tmp__HistoryData)
DECLARE @previousValue BIGINT =0
WHILE @currentEntityType IS NOT NULL BEGIN
    DECLARE @growthRate FLOAT = 0
    IF @maxRealPeriodId > 1 BEGIN
        -- calculate running average
        DECLARE @currentPeriodId  INT = 2
        SET @previousValue	 = ISNULL((SELECT value FROM #GrowthAndTranding_tmp__HistoryData WHERE entityType = @currentEntityType AND periodId = @currentPeriodId - 1), 0)
        DECLARE @currentValue	BIGINT = (SELECT value FROM #GrowthAndTranding_tmp__HistoryData WHERE entityType = @currentEntityType AND periodId = @currentPeriodId)
        SET @previousValue =0
        WHILE @currentValue IS NOT NULL BEGIN
			IF ( @currentValue = 0 ) BEGIN
				SET @currentValue = @previousValue + @growthRate/(@currentPeriodId-1)
			END
			IF ( @currentValue - @previousValue > 0)
				SET @growthRate = @growthRate + CAST((@currentValue - @previousValue) AS FLOAT)
            SET @currentPeriodId = @currentPeriodId + 1
            SET @previousValue = @currentValue
            SET @currentValue = NULL
            SELECT  @currentValue = value
            FROM    #GrowthAndTranding_tmp__HistoryData HD INNER JOIN #GrowthAndTranding_tmp__Periods P ON P.periodId =  HD.periodId
            WHERE   P.predicted = 0 AND HD.entityType = @currentEntityType AND HD.periodId = @currentPeriodId
        END
        SET @growthRate = @growthRate / (@maxRealPeriodId - 1)
    END ELSE BEGIN
        SELECT @growthRate = CAST(value AS FLOAT) FROM #GrowthAndTranding_tmp__HistoryData WHERE entityType = @currentEntityType AND periodId = 1
    END
    INSERT INTO #GrowthAndTranding_tmp__PredictedData
        SELECT @currentEntityType, (@growthRate)
	IF ( @growthRate < 0 ) SET @growthRate =1
    UPDATE  #GrowthAndTranding_tmp__HistoryData
    SET     value  =  ( SELECT (@previousValue + (P.periodId - @maxRealPeriodId) * @growthRate) )
    FROM    #GrowthAndTranding_tmp__HistoryData HD INNER JOIN #GrowthAndTranding_tmp__Periods P ON P.periodId = HD.periodId
    WHERE   HD.entityType = @currentEntityType AND P.predicted = 1
    -- next entity type
    SELECT  @currentEntityType = MIN(entityType)
    FROM    #GrowthAndTranding_tmp__HistoryData
    WHERE   entityType > @currentEntityType
END
SELECT  	@csName AS CommServer,
			(CASE PD.entityType
			WHEN @const_AGG_LICS_ENT_BKP THEN 'DataProtectionEnterprise'
			WHEN @const_AGG_LICS_CORE_BKP THEN 'DataProtectionCore'
			WHEN @const_AGG_LICS_ENT_ARC THEN 'DataArchiveEnterprise'
			WHEN @const_AGG_LICS_CORE_ARC THEN 'DataArchiveCore'
			END ) as Name,
            dbo.UTCToLocalStringTime(dbo.GetDateTime(P.periodStart), @csTimeZone) AS DateStart,
            dbo.UTCToLocalStringTime(dbo.GetDateTime(P.periodEnd), @csTimeZone) AS DateEnd,
			@csTimeZone AS TimeZone,
            P.predicted				   AS IsPredicted,
            CAST(ISNULL(HD.value,0)/1024.0/1024.0/1024.0 AS DECIMAL(20,2)) AS SizeGB,
            CAST((ISNULL(HD.value,0)/1024.0/1024.0/1024.0) * @totalCostPerGB AS DECIMAL(20,2)) AS TotalCost
            FROM   #GrowthAndTranding_tmp__HistoryData HD
            INNER JOIN     #GrowthAndTranding_tmp__Periods P
            	ON P.periodId = HD.periodId
            INNER JOIN #GrowthAndTranding_tmp__PredictedData PD
                ON HD.entityType = PD.entityType
GO

IF EXISTS (select * from GxQscripts where name = 'QS_FrontendCapacityUsage')
	delete from GxQscripts where name = 'QS_FrontendCapacityUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_FrontendCapacityUsage')
	delete from GXDBVersions where aliasname = 'QS_FrontendCapacityUsage'
GO

insert into GXDBVersions values(2, 'QS_FrontendCapacityUsage',  'v1.4.192.2.68.1', 'QS_FrontendCapacityUsage', 'v1.4.192.2.68.1')
GO

insert into GxQscripts values(2,'QS_FrontendCapacityUsage',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '  qoperation execscript -sn QS_FrontendCapacityUsage  [Frequency] [NumberOfPoints] [PredictionPoints]  [CostPerGB] [AddlCostPerGB]  [IncludeCurrentPeriod]
'
 + CHAR(10) + '
'
 + CHAR(10) + '  Example:
'
 + CHAR(10) + '
'
 + CHAR(10) + '  qoperation execscript -sn QS_FrontendCapacityUsage -si @Frequency = ''Weekly'' -si @NumberOfPoints =''4'' -si @PredictionPoints=''2''
'
 + CHAR(10) + '
'
 + CHAR(10) + '
'
 + CHAR(10) + '  Input Parameters: 
'
 + CHAR(10) + '  --  Frequency			- Default is Weekly. Possible values Daily, Weekly, Monthly, Yearly.
'
 + CHAR(10) + '
'
 + CHAR(10) + '  --  NumberOfPoints	- Default is 4. Number of Days/Weeks/Months/Years 
'
 + CHAR(10) + '
'
 + CHAR(10) + '  --  PredictionPoints  - Default is 1. Number of Prediction Days/Weeks/Months/Years
'
 + CHAR(10) + '
'
 + CHAR(10) + '  --  CostPerGB			- Default is 1. Cost per 1 GB of data.
'
 + CHAR(10) + '
'
 + CHAR(10) + '  --  AddlCostPerGB		- Default is 0. Additional Cost Per 1 GB of data.
'
 + CHAR(10) + '
'
 + CHAR(10) + '  --  IncludeCurrentPeriod		- Include current activity window, which is off by default.
'
 + CHAR(10) + '
'
)
GO

