

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_ForceAgeIndexCheckPointAfile.sp] ---------- 

-- ----------------------------------------------------------------------
-- Copyright (c) 2015 Commvault Systems, Inc.
-- All rights reserved.
--
-- This is unpublished proprietary source code of CommVault
-- Systems, Inc. The copyright notice above does not evidence
-- any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='QS_ForceAgeIndexCheckPointAfile')
BEGIN
	print '>>> Drop Stored Procedure: QS_ForceAgeIndexCheckPointAfile <<<'
	drop procedure QS_ForceAgeIndexCheckPointAfile
END
IF EXISTS (select * from GxQscripts where name='QS_ForceAgeIndexCheckPointAfile')
	delete from GxQscripts where name = 'QS_ForceAgeIndexCheckPointAfile'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ForceAgeIndexCheckPointAfile')
	delete from GXDBVersions where aliasname = 'QS_ForceAgeIndexCheckPointAfile'
GO
print '... Creating Procedure: QS_ForceAgeIndexCheckPointAfile'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure QS_ForceAgeIndexCheckPointAfile
-- Stored Procedure Inputs (order of inputs matter)
  @i_commCellId int = 0,
  @i_dbName NVARCHAR(MAX) = '',
  @i_archFileId int = 0
AS
SET NOCOUNT ON
--
DECLARE @scriptName nvarchar(32) = 'ForceAgeIndexCheckPointAfile';
DECLARE @errorCode int = 0;
DECLARE @errorString nvarchar(1024) = ''
DECLARE @archiveFileXML     XML
DECLARE @archFileName nvarchar(2048) = N''
DECLARE	@rowCnt int = 0
DECLARE @retVal int = 0
DECLARE @retStr nvarchar(100)= N''
DECLARE @pruneArchFileId int = 0
DECLARE @pruneCommCellId int = 0
DECLARE @isIndexSubclient int = 0
--check for mandatory input parameters backupSetGUID and commCellId
IF ( @i_dbName='' OR @i_dbName is null OR @i_commCellId=0)
BEGIN
    SET @retStr = 'Either backupSetGUID or commCellId is missing'
	GOTO CX_EXIT
END
DECLARE @dbGroup NVARCHAR(36)
DECLARE @dbName NVARCHAR(36)
SELECT TOP 1 @dbGroup = backupsetGUID, @dbName = dbName FROM App_IndexDBInfo WITH (NOLOCK) WHERE dbName = @i_dbName
SET @archFileName = N'IdxCheckPoint_'+ @dbGroup + N':'+ @dbName;
--create temp table
IF OBJECT_ID('tempdb.dbo.#tblResultarchDeleteArchiveFiles', 'U') IS NOT NULL
DROP TABLE #tblResultarchDeleteArchiveFiles;
CREATE TABLE #tblResultarchDeleteArchiveFiles (
	retVal INT,
	retStr NVARCHAR(100),
)
IF OBJECT_ID('tempdb.dbo.#TempToBeAgedAFiles', 'U') IS NOT NULL
DROP TABLE #TempToBeAgedAFiles;
CREATE TABLE #TempToBeAgedAFiles (
	archFileid INT,
	commCellId INT,
	appId INT
)
--if archive file id is not specified , prune all archive files for backupset
IF ( @i_archFileId!='' AND @i_archFileId is NOT NULL )
BEGIN
    --insert afile into temp table which we find as a match from archFile table
	insert into #TempToBeAgedAFiles SELECT id,commCellId,appId from archFile where commCellId=@i_commCellId and name = @archFileName and id = @i_archFileId
	SELECT	@rowCnt = @@ROWCOUNT,@retVal = @@ERROR
END
ELSE
BEGIN
	insert into #TempToBeAgedAFiles SELECT id,commCellId,appId from archFile where commCellId=@i_commCellId and name = @archFileName
	SELECT	@rowCnt = @@ROWCOUNT,@retVal = @@ERROR
END
IF	@retVal <> 0
BEGIN
	set @retStr='Failed while retrieving archive files'
	GOTO CX_EXIT
END
IF @rowCnt = 0
BEGIN
	set @retStr='No archive files to prune'
	GOTO CX_EXIT
END
--check the archive file belongs to index subclient
select @isIndexSubclient=attrVal from APP_SubClientProp where componentNameId=(select top 1 appId From #TempToBeAgedAFiles) and attrName='Index SubClient'
IF @isIndexSubclient<>1
BEGIN
	set @retStr='The archive file doesn''t belong to a Index Subclient'
	GOTO CX_EXIT
END
SET @archiveFileXML = ( SELECT archFileInfo.archFileId AS archFileId, archFileInfo.commCellId AS commCelld
                                                    FROM #TempToBeAgedAFiles archFileInfo
                                                    FOR  XML AUTO, ROOT('GalaxyOperations_PruneArchiveFiles')
                                                )
--mark index check point archive files as CVA_AGED_BY_INDEX_PRUNING
EXEC @retVal = archDeleteArchiveFiles @archiveFileXML,8589934592,0
IF  (@@ERROR != 0 OR @retVal != 0)
BEGIN
	print 'Failed to prune archive files. Error Code [' + CAST(@retVal AS VARCHAR) + ']'
	set @retStr='Failed while pruning archive files'
	GOTO CX_EXIT
END
ELSE
BEGIN
	print 'Archive files pruned successfully'
END
print @scriptName + ' completed at ' + CONVERT(nvarchar(60), GETDATE())
CX_EXIT:
IF OBJECT_ID('tempdb.dbo.#TempToBeAgedAFiles', 'U') IS NOT NULL
DROP TABLE #TempToBeAgedAFiles;
IF OBJECT_ID('tempdb.dbo.#tblResultarchDeleteArchiveFiles', 'U') IS NOT NULL
DROP TABLE #tblResultarchDeleteArchiveFiles
--if retstr is set, raise error
if @retStr!=''
RAISERROR(@retStr, 15 /* Severity > 10 to force DOS error code 1 */, 1);
GO

IF EXISTS (select * from GxQscripts where name = 'QS_ForceAgeIndexCheckPointAfile')
	delete from GxQscripts where name = 'QS_ForceAgeIndexCheckPointAfile'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ForceAgeIndexCheckPointAfile')
	delete from GXDBVersions where aliasname = 'QS_ForceAgeIndexCheckPointAfile'
GO

insert into GXDBVersions values(2, 'QS_ForceAgeIndexCheckPointAfile',  '00000000000000000000', 'QS_ForceAgeIndexCheckPointAfile', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_ForceAgeIndexCheckPointAfile',  0, GETDATE(), GETDATE(), '' + CHAR(10) + ' Force Age an afile
'
 + CHAR(10) + ' 
'
 + CHAR(10) + '--  qoperation execscript -sn ForceAgeIndexCheckPointAfile.sql -si commCellId=commcell_id -si dbName=db_name [-si archFileId=archive_file_id]'
 + CHAR(10) + ' 
'
)
GO

