

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_ForceAgeDummyAfile.sp] ---------- 

-- ----------------------------------------------------------------------
-- Copyright (c) 2015 Commvault Systems, Inc.
-- All rights reserved.
--
-- This is unpublished proprietary source code of CommVault
-- Systems, Inc. The copyright notice above does not evidence
-- any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_ForceAgeDummyAfile <<<'

IF EXISTS (select * from sysobjects where name='QS_ForceAgeDummyAfile')
	drop procedure QS_ForceAgeDummyAfile
IF EXISTS (select * from GxQscripts where name='QS_ForceAgeDummyAfile')
	delete from GxQscripts where name = 'QS_ForceAgeDummyAfile'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ForceAgeDummyAfile')
	delete from GXDBVersions where aliasname = 'QS_ForceAgeDummyAfile'
GO
print '... Creating Procedure: QS_ForceAgeDummyAfile'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_ForceAgeDummyAfile
-- Stored Procedure Inputs (order of inputs matter)
  @i_auth nvarchar(32) = '',
  @i_commCellId int = 0,
  @i_archFileId int = 0
AS
SET NOCOUNT ON
--
DECLARE @scriptName nvarchar(32) = 'ForceAgeDummyAfile';
DECLARE @errorCode int = 0;
DECLARE @errorString nvarchar(1024) = ''
DECLARE @archiveFileXML     XML
DECLARE @archFileName nvarchar(2048) = N''
DECLARE	@rowCnt int = 0
DECLARE @retVal int = 0
DECLARE @retStr nvarchar(100)= N''
DECLARE @pruneArchFileId int = 0
DECLARE @pruneCommCellId int = 0
DECLARE @authCode nvarchar(32) = ''
DECLARE @authCodeHash nvarchar(32) = ''
--check for mandatory input parameters commCellId and archFileId
IF ( @i_commCellId=0 OR @i_archFileId=0 OR @i_auth='' )
BEGIN
    SET @retStr = 'Either commCellId, archFileId or authCode is missing'
	GOTO CX_EXIT
END
SET @authCode = CONCAT(CONVERT(nvarchar(32) , @i_commCellId  ) , '_' , CONVERT(nvarchar(32), @i_archFileId))
set @authCodeHash = LOWER(CONVERT(VARCHAR(32), HashBytes('MD5', CONVERT(varchar, @authCode)), 2))
IF (@i_auth <> @authCodeHash )
BEGIN
	SET @retStr = 'Authentication error'
	GOTO CX_EXIT
END
--create temp table
IF OBJECT_ID('tempdb.dbo.#TempToBeAgedAFiles', 'U') IS NOT NULL
DROP TABLE #TempToBeAgedAFiles;
CREATE TABLE #TempToBeAgedAFiles (
	archFileid INT,
	commCellId INT,
	appId INT
)
IF ( @i_archFileId!='' AND @i_archFileId is NOT NULL )
BEGIN
    --insert afile into temp table which we find as a match from archFile table
	insert into #TempToBeAgedAFiles SELECT id,commCellId,appId from archFile where commCellId=@i_commCellId and id = @i_archFileId
	SELECT	@rowCnt = @@ROWCOUNT,@retVal = @@ERROR
END
ELSE
BEGIN
	GOTO CX_EXIT
END
IF	@retVal <> 0
BEGIN
	set @retStr='Failed while retrieving archive files'
	GOTO CX_EXIT
END
IF @rowCnt = 0
BEGIN
	set @retStr='No archive files to prune'
	GOTO CX_EXIT
END
SET @archiveFileXML = ( SELECT archFileInfo.archFileId AS archFileId, archFileInfo.commCellId AS commCelld
                                                    FROM #TempToBeAgedAFiles archFileInfo
                                                    FOR  XML AUTO, ROOT('GalaxyOperations_PruneArchiveFiles')
                                                )
--mark archive files as CVA_AGED_BY_INDEX_PRUNING
EXEC @retVal = archDeleteArchiveFiles @archiveFileXML,8589934592,0
IF  (@@ERROR != 0 OR @retVal != 0)
BEGIN
	set @retStr='Failed while pruning archive files'
	GOTO CX_EXIT
END
print @scriptName + ' completed at ' + CONVERT(nvarchar(60), GETDATE())
CX_EXIT:
IF OBJECT_ID('tempdb.dbo.#TempToBeAgedAFiles', 'U') IS NOT NULL
DROP TABLE #TempToBeAgedAFiles;
--if retstr is set, raise error
if @retStr!=''
RAISERROR(@retStr, 15 /* Severity > 10 to force DOS error code 1 */, 1);
GO

IF EXISTS (select * from GxQscripts where name = 'QS_ForceAgeDummyAfile')
	delete from GxQscripts where name = 'QS_ForceAgeDummyAfile'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ForceAgeDummyAfile')
	delete from GXDBVersions where aliasname = 'QS_ForceAgeDummyAfile'
GO

insert into GXDBVersions values(2, 'QS_ForceAgeDummyAfile',  '00000000000000000000', 'QS_ForceAgeDummyAfile', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_ForceAgeDummyAfile',  0, GETDATE(), GETDATE(), '' + CHAR(10) + ' Force Age an afile
'
 + CHAR(10) + ' 
'
 + CHAR(10) + '--  qoperation execscript -sn ForceAgeDummyAfile.sql -si auth=auth_code -si commCellId=commcell_id -si archFileId=archive_file_id'
 + CHAR(10) + ' 
'
)
GO

