

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_FixClientsPlatformType.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_FixClientsPlatformType <<<'

IF EXISTS (select * from sysobjects where name='QS_FixClientsPlatformType')
	drop procedure QS_FixClientsPlatformType
IF EXISTS (select * from GxQscripts where name='QS_FixClientsPlatformType')
	delete from GxQscripts where name = 'QS_FixClientsPlatformType'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_FixClientsPlatformType')
	delete from GXDBVersions where aliasname = 'QS_FixClientsPlatformType'
GO
print '... Creating Procedure: QS_FixClientsPlatformType'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_FixClientsPlatformType
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
  @opType nvarchar(10)
AS
Set NOCOUNT ON
---------------- Consts   -----------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'QS_FixClientsPlatformType'
declare @ClientsWithNoPlatformType TABLE ( id integer primary key, name nvarchar(120))
-------- Local Variables    -------------
DECLARE @lastError				integer
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
SET     @lastError  = 0									-- Be optimistic
------------ No error handling ---------------
BEGIN TRY
	INSERT @ClientsWithNoPlatformType
	SELECT client.id,client.name FROM APP_Client client LEFT OUTER JOIN APP_PLATFORM platform
	ON client.id = platform.clientId
	WHERE platform.clientId is NULL and client.id not in (0,1)
	AND client.id NOT IN (SELECT PMClientId FROM APP_VmToPMMap WHERE VMClientId = 2)	--Check whether this client is a physical machine for a cluster CS
	IF @opType = 'Get'
	BEGIN
		SELECT id as 'id',name as 'name'
		FROM  @ClientsWithNoPlatformType
	END
	ELSE IF @opType = 'Fix'
	BEGIN
		INSERT INTO APP_PLATFORM
		SELECT id, 4, '', 0
		FROM @ClientsWithNoPlatformType
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @lastError = @@error
	SET @localErrorMsg = (SELECT ERROR_MESSAGE())
END CATCH
ARGS_ERROR:
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_FixClientsPlatformType')
	delete from GxQscripts where name = 'QS_FixClientsPlatformType'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_FixClientsPlatformType')
	delete from GXDBVersions where aliasname = 'QS_FixClientsPlatformType'
GO

insert into GXDBVersions values(2, 'QS_FixClientsPlatformType',  '00000000000000000000', 'QS_FixClientsPlatformType', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_FixClientsPlatformType',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn QS_FixClientsPlatformType.sql -si ''Get/Fix''
'
 + CHAR(10) + '--   script_name : GetClients'
)
GO

