

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_FixCaseListOfRecreatedUser.sp] ---------- 

SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_FixCaseListOfRecreatedUser <<<'

IF EXISTS (select * from sysobjects where name='QS_FixCaseListOfRecreatedUser')
	drop procedure QS_FixCaseListOfRecreatedUser
IF EXISTS (select * from GxQscripts where name='QS_FixCaseListOfRecreatedUser')
	delete from GxQscripts where name = 'QS_FixCaseListOfRecreatedUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_FixCaseListOfRecreatedUser')
	delete from GXDBVersions where aliasname = 'QS_FixCaseListOfRecreatedUser'
GO
print '... Creating Procedure: QS_FixCaseListOfRecreatedUser'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_FixCaseListOfRecreatedUser
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @i_OldUserGuid varchar(36) = N'',
  @i_NewUserGuid varchar(36) = N''
AS
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @RowsEffected INT = 0
DECLARE @NoParameter	nvarchar(10)
SET     @NoParameter	=N''
DECLARE @scriptName NVARCHAR(100)
SET @scriptName = N'QS_FixCaseListOfRecreatedUser'
DECLARE @errorCode int
SET @errorCode = 0
DECLARE @errorString NVARCHAR(1024)
SET @errorString = N'Succeeded'
-----------------------invalid parameters------------------------------
IF(@i_OldUserGuid = @NoParameter OR @i_NewUserGuid = @NoParameter)
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error: Insufficient command line parameters. Please refer to the readme file and retry with necessary parameters'
	GOTO SCRIPT_EXIT
END
------------------------------------------------------------------------
-----------------Validation of new userGUID---------------------
IF NOT EXISTS (SELECT 1 FROM UMUsers (NOLOCK) WHERE UserGUID = @i_NewUserGuid)
BEGIN
	SET @errorCode = 2
	SET @errorString = 'Error. Invalid NewUserGuid [' + @i_NewUserGuid + '] specified.'
	GOTO SCRIPT_EXIT
END
------------------------------------------------------------------------
-----------------Update relevant cases only--------------
;WITH CTE
AS
(
SELECT CaseId, T.ref.value('@userGUID', 'VARCHAR(36)') UserGUID
FROM DM2CaseInfo A CROSS APPLY A.CaseXML.nodes('(/DM2ContentIndexing_CaseInfo/casePartakers/user)') t(ref)
)
UPDATE U
SET CaseXML.modify('replace value of (/DM2ContentIndexing_CaseInfo/casePartakers/user[@userGUID=sql:variable("@i_OldUserGuid")]/@userGUID)[1] with sql:variable("@i_NewUserGuid")')
FROM
CTE T, DM2CaseInfo U
WHERE T.CaseId = U.CaseId AND T.UserGUID = @i_OldUserGuid
SET @RowsEffected = @@rowcount
------------------------------------------------------------------------
SCRIPT_EXIT:
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: ['+@i_OldUserGuid + ', '+@i_NewUserGuid
         + ']. Exit Code(' +convert(varchar(2), @ErrorCode) + '). Number of rows effected: [' + convert(varchar, @RowsEffected) + ']'
IF @ErrorCode <> 0
Raiserror(@ErrorString,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_FixCaseListOfRecreatedUser')
	delete from GxQscripts where name = 'QS_FixCaseListOfRecreatedUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_FixCaseListOfRecreatedUser')
	delete from GXDBVersions where aliasname = 'QS_FixCaseListOfRecreatedUser'
GO

insert into GXDBVersions values(2, 'QS_FixCaseListOfRecreatedUser',  '00000000000000000000', 'QS_FixCaseListOfRecreatedUser', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_FixCaseListOfRecreatedUser',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn QS_FixCaseListOfRecreatedUser.sql -si ''OldUserGuid'' -si ''NewUserGuid''
'
 + CHAR(10) + '-- 	script_name: QS_FixCaseListOfRecreatedUser'
 + CHAR(10) + '-- 	Script to fix the problem of user being unable to access certain cases in Case Manager after recreation of account'
 + CHAR(10) + '-- 	OldUserGuid - GUID of user before user is deleted and recreated'
 + CHAR(10) + '-- 	NewUserGuid - GUID of user after user is recreated'
)
GO

