

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_FindJobsOnStore.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_FindJobsOnStore <<<'

IF EXISTS (select * from sysobjects where name='QS_FindJobsOnStore')
	drop procedure QS_FindJobsOnStore
IF EXISTS (select * from GxQscripts where name='QS_FindJobsOnStore')
	delete from GxQscripts where name = 'QS_FindJobsOnStore'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_FindJobsOnStore')
	delete from GXDBVersions where aliasname = 'QS_FindJobsOnStore'
GO
print '... Creating Procedure: QS_FindJobsOnStore'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_FindJobsOnStore
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- Stored Procedure Inputs
  @MountPathId INT, 
  @LibraryName NVARCHAR(256) = '',
  @DeviceName NVARCHAR(256) = '',
  @MountPathName NVARCHAR(2048) = ''
AS
Set NOCOUNT ON
DECLARE @validation  INT = 0
DECLARE @localErrorMsg  VARCHAR(256)
DECLARE @MountPathIdList TABLE(MPId INTEGER)
IF @MountPathId <> 0
BEGIN
	SELECT @validation = 1 from MMMountPath where MountPathId = @MountPathId
	IF @validation = 0
	BEGIN
			SET @localErrorMsg = 'Error: No Mount Path by this ID found!'
			goto   ARGS_ERROR
	END
	DECLARE @jobId1 NVARCHAR(MAX)
	DECLARE @SPName1 NVARCHAR(MAX)
	DECLARE @CopyName1 NVARCHAR(MAX)
	DECLARE @StoreId1 NVARCHAR(MAX)
	DECLARE @ClientName1 NVARCHAR(MAX)
	DECLARE print_row CURSOR
	FOR
		select distinct AJSI.JobId, AJSI.StoragePolicyName, AJSI.CopyName, AJSI.StoreId, AJSI.ClientName
		from MMMountPath mp WITH (READUNCOMMITTED) inner join MMVolume mv WITH (READUNCOMMITTED) on mv.SIDBStoreId > 0 and mv.MediaSideId = mp.MediaSideId
		inner join archChunk ac WITH (READUNCOMMITTED) on ac.volumeId = mv.VolumeId
		inner join archChunkMapping acm WITH (READUNCOMMITTED) on acm.archChunkId = ac.id and ac.commcellid = acm.chunkcommcellid
		inner join archJobsOnStoreInfo ajsi WITH (READUNCOMMITTED) on ajsi.JobId = acm.jobId and ajsi.storeid = mv.sidbstoreid
		where mp.MountPathId = @MountPathId
		ORDER BY AJSI.StoragePolicyName,AJSI.CopyName, AJSI.JobId
	PRINT 'Job Id'+ SPACE(5)+ 'Storage Policy Name' +SPACE(24) +'Copy Name'+SPACE(33) + 'Store Id' + SPACE(5) + 'Client Name'
	PRINT SPACE(136)
	OPEN print_row
	FETCH NEXT FROM print_row
	INTO @jobId1 ,@SPName1, @CopyName1, @StoreId1, @ClientName1
	WHILE @@FETCH_STATUS = 0
	BEGIN
		PRINT @jobId1 +SPACE(11 - LEN(@jobId1)) +  @SPName1 +SPACE(43 - LEN(@SPName1)) + @CopyName1 +SPACE(42 - LEN(@CopyName1)) + @StoreId1 + SPACE(13-LEN(@StoreId1))
			+  @ClientName1 +SPACE(25- LEN(@ClientName1))
		FETCH NEXT FROM print_row
		INTO @jobId1 ,@SPName1, @CopyName1, @StoreId1, @ClientName1
	END
	CLOSE print_row;
	DEALLOCATE print_row
END
ELSE IF @MountPathName <> ''
BEGIN
	SELECT @validation = MP.MountPathId FROM MMLibrary ML WITH (READUNCOMMITTED)
			INNER JOIN MMMountPath MP WITH (READUNCOMMITTED) ON ML.LIbraryId = MP.LibraryId
			INNER JOIN MMMountPathToStorageDevice MPD WITH (READUNCOMMITTED) ON MPD.MountPathId = MP.MountPathId
			INNER JOIN MMDevice MD WITH (READUNCOMMITTED) ON MD.DeviceId = MPD.DeviceId
	WHERE	MP.MountPathName = @MountPathName
	AND	ML.AliasName = @LibraryName
	AND	MD.AliasName = @DeviceName
	IF @validation = 0
	BEGIN
			SET @localErrorMsg = 'Error: The Library-Device-MountPath combination is not valid. Please recheck these inputs. '
			goto   ARGS_ERROR
	END
	DECLARE @jobId2 NVARCHAR(MAX)
	DECLARE @SPName2 NVARCHAR(MAX)
	DECLARE @CopyName2 NVARCHAR(MAX)
	DECLARE @StoreId2 NVARCHAR(MAX)
	DECLARE @ClientName2 NVARCHAR(MAX)
	DECLARE print_row CURSOR
	FOR
		select distinct AJSI.JobId, AJSI.StoragePolicyName, AJSI.CopyName, AJSI.StoreId, AJSI.ClientName
		from MMMountPath mp WITH (READUNCOMMITTED)
		inner join MMVolume mv WITH (READUNCOMMITTED) on mv.SIDBStoreId > 0 and mv.MediaSideId = mp.MediaSideId
		inner join archChunk ac WITH (READUNCOMMITTED) on ac.volumeId = mv.VolumeId
		inner join archChunkMapping acm WITH (READUNCOMMITTED) on acm.archChunkId = ac.id and ac.commcellid = acm.chunkcommcellid
		inner join archJobsOnStoreInfo ajsi WITH (READUNCOMMITTED) on ajsi.JobId = acm.jobId and ajsi.storeid = mv.sidbstoreid
		where mp.MountPathId  = @validation
		ORDER BY AJSI.StoragePolicyName,AJSI.CopyName, AJSI.JobId
	PRINT 'Job Id'+ SPACE(5)+ 'Storage Policy Name' +SPACE(24) +'Copy Name'+SPACE(33) + 'Store Id' + SPACE(5) + 'Client Name'
	PRINT SPACE(136)
	OPEN print_row
	FETCH NEXT FROM print_row
	INTO @jobId2 ,@SPName2, @CopyName2, @StoreId2, @ClientName2
	WHILE @@FETCH_STATUS = 0
	BEGIN
		PRINT @jobId2 +SPACE(11 - LEN(@jobId2)) +  @SPName2 +SPACE(43 - LEN(@SPName2)) + @CopyName2 +SPACE(42 - LEN(@CopyName2)) + @StoreId2 + SPACE(13-LEN(@StoreId2))
			+  @ClientName2 +SPACE(25- LEN(@ClientName2))
		FETCH NEXT FROM print_row
		INTO @jobId2 ,@SPName2, @CopyName2, @StoreId2, @ClientName2
	END
	CLOSE print_row;
	DEALLOCATE print_row
END
ELSE IF @DeviceName <> ''
BEGIN
	INSERT	INTO @MountPathIdList
	SELECT	DISTINCT MP.MountPathId FROM MMLibrary ML WITH (READUNCOMMITTED)
			INNER JOIN MMMountPath MP WITH (READUNCOMMITTED) ON ML.LIbraryId = MP.LibraryId
			INNER JOIN MMMountPathToStorageDevice MPD WITH (READUNCOMMITTED) ON MPD.MountPathId = MP.MountPathId
			INNER JOIN MMDevice MD WITH (READUNCOMMITTED) ON MD.DeviceId = MPD.DeviceId
	WHERE	ML.AliasName = @LibraryName
	AND	MD.AliasName = @DeviceName
	SELECT @validation = 1 FROM @MountPathIdList
	IF @validation = 0
	BEGIN
			SET @localErrorMsg = 'Error: The Library-Device combination is not valid. Please recheck these inputs. '
			goto   ARGS_ERROR
	END
	DECLARE @jobId3 NVARCHAR(MAX)
	DECLARE @SPName3 NVARCHAR(MAX)
	DECLARE @CopyName3 NVARCHAR(MAX)
	DECLARE @StoreId3 NVARCHAR(MAX)
	DECLARE @ClientName3 NVARCHAR(MAX)
	DECLARE @MPName3 NVARCHAR(MAX)
	DECLARE print_row CURSOR
	FOR
		select distinct AJSI.JobId, AJSI.StoragePolicyName, AJSI.CopyName, AJSI.StoreId, AJSI.ClientName,MP.MountPathName
		from MMMountPath mp WITH (READUNCOMMITTED)
		inner join MMVolume mv WITH (READUNCOMMITTED) on mv.SIDBStoreId > 0 and mv.MediaSideId = mp.MediaSideId
		inner join archChunk ac WITH (READUNCOMMITTED) on ac.volumeId = mv.VolumeId
		inner join archChunkMapping acm WITH (READUNCOMMITTED) on acm.archChunkId = ac.id and ac.commcellid = acm.chunkcommcellid
		inner join archJobsOnStoreInfo ajsi WITH (READUNCOMMITTED) on ajsi.JobId = acm.jobId and ajsi.storeid = mv.sidbstoreid
		where mp.MountPathId  IN (SELECT MPId FROM @MountPathIdList)
		ORDER BY AJSI.StoragePolicyName,AJSI.CopyName, AJSI.JobId
	PRINT 'Job Id'+ SPACE(5)+ 'Storage Policy Name' +SPACE(24) +'Copy Name'+SPACE(33) + 'Store Id' + SPACE(5) + 'Client Name'+SPACE(15)+  'MountPath Name'
	PRINT SPACE(136)
	OPEN print_row
	FETCH NEXT FROM print_row
	INTO @jobId3 ,@SPName3, @CopyName3, @StoreId3, @ClientName3,@MPName3
	WHILE @@FETCH_STATUS = 0
	BEGIN
		PRINT @jobId3 +SPACE(11 - LEN(@jobId3)) +  @SPName3 +SPACE(43 - LEN(@SPName3)) + @CopyName3 +SPACE(42 - LEN(@CopyName3)) + @StoreId3 + SPACE(13-LEN(@StoreId3))
			+  @ClientName3 +SPACE(25- LEN(@ClientName3)) + @MPName3
		FETCH NEXT FROM print_row
		INTO @jobId3 ,@SPName3, @CopyName3, @StoreId3, @ClientName3,@MPName3
	END
	CLOSE print_row;
	DEALLOCATE print_row
END
ELSE IF @LibraryName <> ''
BEGIN
	SELECT @validation = 1 FROM MMLibrary WHERE AliasName = @LibraryName
	IF @validation = 0
	BEGIN
		SET @localErrorMsg = 'Error: The Libraryname is not valid. Please recheck the input. '
		goto   ARGS_ERROR
	END
	INSERT 	INTO @MountPathIdList
	SELECT 	DISTINCT MP.MountPathId FROM MMLibrary ML
			INNER JOIN MMMountPath MP ON ML.LIbraryId = MP.LibraryId
	WHERE	ML.AliasName = @LibraryName
	DECLARE @jobId4 NVARCHAR(MAX)
	DECLARE @SPName4 NVARCHAR(MAX)
	DECLARE @CopyName4 NVARCHAR(MAX)
	DECLARE @StoreId4 NVARCHAR(MAX)
	DECLARE @ClientName4 NVARCHAR(MAX)
	DECLARE @MPName4 NVARCHAR(MAX)
	DECLARE @DVName4 NVARCHAR(MAX)
	DECLARE print_row CURSOR
	FOR
		select distinct AJSI.JobId, AJSI.StoragePolicyName, AJSI.CopyName, AJSI.StoreId, AJSI.ClientName,MP.MountPathName, MD.AliasName
		from MMMountPath mp WITH (READUNCOMMITTED)
		inner join MMVolume mv WITH (READUNCOMMITTED) on mv.SIDBStoreId > 0 and mv.MediaSideId = mp.MediaSideId
		inner join archChunk ac WITH (READUNCOMMITTED) on ac.volumeId = mv.VolumeId
		inner join archChunkMapping acm WITH (READUNCOMMITTED) on acm.archChunkId = ac.id and ac.commcellid = acm.chunkcommcellid
		inner join archJobsOnStoreInfo ajsi WITH (READUNCOMMITTED) on ajsi.JobId = acm.jobId and ajsi.storeid = mv.sidbstoreid
		inner join mmmountpathtostoragedevice mpd WITH (READUNCOMMITTED) on mpd.mountpathid = mp.mountpathid
		inner join mmdevice md WITH (READUNCOMMITTED) on md.deviceid = mpd.deviceid
		where mp.MountPathId  IN (SELECT MPId FROM @MountPathIdList)
		ORDER BY AJSI.StoragePolicyName,AJSI.CopyName, AJSI.JobId
	PRINT 'Job Id'+ SPACE(5)+ 'Storage Policy Name' +SPACE(24) +'Copy Name'+SPACE(33) + 'Store Id' + SPACE(5) + 'Client Name'+SPACE(15)+  'Mount Path Name' + SPACE(30) + 'Device Name'
	PRINT SPACE(136)
	OPEN print_row
	FETCH NEXT FROM print_row
	INTO @jobId4 ,@SPName4, @CopyName4, @StoreId4, @ClientName4,@MPName4,@DVName4
	WHILE @@FETCH_STATUS = 0
	BEGIN
		PRINT @jobId4 +SPACE(11 - LEN(@jobId4)) +  @SPName4 +SPACE(43 - LEN(@SPName4)) + @CopyName4 +SPACE(42 - LEN(@CopyName4)) + @StoreId4 + SPACE(13-LEN(@StoreId4))
			+  @ClientName4 +SPACE(25- LEN(@ClientName4)) + @MPName4 + SPACE(45- LEN(@MPName4)) + @DVName4
		FETCH NEXT FROM print_row
		INTO @jobId4 ,@SPName4, @CopyName4, @StoreId4, @ClientName4,@MPName4,@DVName4
	END
	CLOSE print_row;
	DEALLOCATE print_row
END
ELSE
BEGIN
	SET @localErrorMsg = 'Error: Insufficient parameters. Please provide mountpathId OR LibraryName OR LibraryName-DeviceName OR LibraryName-DeviceName-MountPathName '
	goto   ARGS_ERROR
END
ARGS_ERROR:
IF @validation = 0
BEGIN
	Raiserror(@localErrorMsg , 15, 1)
	RETURN -1
END
RETURN 0
GO

IF EXISTS (select * from GxQscripts where name = 'QS_FindJobsOnStore')
	delete from GxQscripts where name = 'QS_FindJobsOnStore'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_FindJobsOnStore')
	delete from GXDBVersions where aliasname = 'QS_FindJobsOnStore'
GO

insert into GXDBVersions values(2, 'QS_FindJobsOnStore',  '00000000000000000000', 'QS_FindJobsOnStore', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_FindJobsOnStore',  3, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 	QS_FindJobsOnStore [-si <MountPathId>] [-si <LibraryName> ] [-si <DeviceName> ] [-si <MountPathName>] '
 + CHAR(10) + '--  Options: @MountPathId <> 0 : The jobs from all stores associated with the corresponding MountPath are listed. Other parameter values are not considered in this case.'
 + CHAR(10) + '--  Options: @MountPathId = 0 , LibraryName <> NULL : The jobs from all stores associated with MountPaths under this library are listed. '
 + CHAR(10) + '--  Options: @MountPathId = 0 , LibraryName <> NULL , Devicename <> NULL : The jobs from all stores associated with MountPaths under this library-device combination are listed. '
 + CHAR(10) + '--  Options: @MountPathId = 0 , LibraryName <> NULL ,  Devicename <> NULL , Mountpathname <> NULL: The jobs from all stores associated with MountPath identified by this combination are listed. '
 + CHAR(10) + '--  Options: All the required inputs can be obtained from LIbrary&Drive configuration GUI'
)
GO

