

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_ExtendRetainAllJobsInCycle.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_ExtendRetainAllJobsInCycle.sp,v $ $Id: QS_ExtendRetainAllJobsInCycle.sp,v 1.1.4.5 2018/03/22 00:57:12 jiechen Exp $";
-- 	+-------------------------------------------------------------------+
--	|			Stored Procedure: "QS_ExtendRetainAllJobsInCycle"							|
--	|-------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_ExtendRetainAllJobsInCycle <<<'

IF EXISTS (select * from sysobjects where name='QS_ExtendRetainAllJobsInCycle')
	drop procedure QS_ExtendRetainAllJobsInCycle
IF EXISTS (select * from GxQscripts where name='QS_ExtendRetainAllJobsInCycle')
	delete from GxQscripts where name = 'QS_ExtendRetainAllJobsInCycle'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ExtendRetainAllJobsInCycle')
	delete from GXDBVersions where aliasname = 'QS_ExtendRetainAllJobsInCycle'
GO
print '... Creating Procedure: QS_ExtendRetainAllJobsInCycle'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_ExtendRetainAllJobsInCycle
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @i_SPName NVARCHAR(MAX),
  @i_CopyName NVARCHAR(MAX),
  @i_AllJobsInCycle INTEGER = 2
AS
SET NOCOUNT ON
DECLARE @ErrorNumber INTEGER = 0
DECLARE @ErrorMessage NVARCHAR(MAX) = ''
DECLARE	@SPId INTEGER = 0
DECLARE	@CopyId INTEGER = 0
DECLARE	@modifiedTime INTEGER = dbo.GetUnixTime(GETUTCDATE())
BEGIN TRY
	--Validate Storage Policy
	SELECT @SPId = id FROM archGroup WITH (NOLOCK) WHERE name = @i_SPName
	IF @SPId = 0
	BEGIN
		SET @ErrorNumber = 1
		SET @ErrorMessage = N'Invalid Storage Policy Name.'
		GOTO SCRIPT_EXIT
	END
	--Validate Storage Policy Copy
	SELECT @CopyId = id FROM archGroupCopy WITH (NOLOCK) WHERE name = @i_CopyName AND archGroupId = @SPId
	IF @CopyId = 0
	BEGIN
		SET @ErrorNumber = 2
		SET @ErrorMessage = N'Invalid Storage Policy Copy Name.'
		GOTO SCRIPT_EXIT
	END
	--Validate @i_AllJobsInCycle
	IF (@i_AllJobsInCycle NOT IN (0, 1, 2))
	BEGIN
			SET @ErrorNumber = 3
			SET @ErrorMessage = N'Invalid value for AllJobsInCycle option.'
			GOTO SCRIPT_EXIT
	END
	--Set "ExtendRetainAllJobsInCycle" property
	IF EXISTS (SELECT 1 FROM MMEntityProp WITH (NOLOCK) WHERE EntityId = @CopyId AND EntityType = 2 AND PropertyName = 'ExtendRetainAllJobsInCycle')
	BEGIN
		UPDATE MMEntityProp SET intVal = @i_AllJobsInCycle, modified = @modifiedTime
		WHERE EntityId = @CopyId AND EntityType = 2 AND propertyName = 'ExtendRetainAllJobsInCycle'
	END
	ELSE
	BEGIN
		INSERT INTO MMEntityProp (EntityId, EntityType, propertyName, propDataType, intVal, longlongVal, stringVal, created, modified, CommCellId)
		VALUES (@CopyId, 2, 'ExtendRetainAllJobsInCycle', 1,  @i_AllJobsInCycle, 0, '', @modifiedTime, @modifiedTime, 2)
	END
	SET @ErrorNumber = @@ERROR
	IF @ErrorNumber != 0
	BEGIN
		SET @ErrorMessage = N'Failed to set the ExtendRetainAllJobsInCycle option to [' + CAST(@i_AllJobsInCycle AS NVARCHAR(10)) + '] for Storage Policy [' + @i_SPName + '] and Copy [' + @i_CopyName + '].'
	END
	ELSE
	BEGIN
		SET @ErrorMessage = N'Successfully set the ExtendRetainAllJobsInCycle option to [' + CAST(@i_AllJobsInCycle AS NVARCHAR(10)) + '] for Storage Policy [' + @i_SPName + '] and Copy [' + @i_CopyName + '].'
	END
	GOTO SCRIPT_EXIT
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SELECT @ErrorNumber = ERROR_NUMBER(), @ErrorMessage = ERROR_MESSAGE();
END CATCH;
SCRIPT_EXIT:
	IF @ErrorNumber != 0
		RAISERROR(@ErrorMessage,
							15,  	-- Severity (> 10 to force DOS Error Code = 1)
							1	 		-- State
							)
	ELSE
		PRINT @ErrorMessage
GO

IF EXISTS (select * from GxQscripts where name = 'QS_ExtendRetainAllJobsInCycle')
	delete from GxQscripts where name = 'QS_ExtendRetainAllJobsInCycle'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_ExtendRetainAllJobsInCycle')
	delete from GXDBVersions where aliasname = 'QS_ExtendRetainAllJobsInCycle'
GO

insert into GXDBVersions values(2, 'QS_ExtendRetainAllJobsInCycle',  '00010001000400050000', 'QS_ExtendRetainAllJobsInCycle', '00010001000400050000')
GO

insert into GxQscripts values(2,'QS_ExtendRetainAllJobsInCycle',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn QS_ExtendRetainAllJobsInCycle -si @i_SPName = ''SPName'' -si @i_CopyName = ''CopyName'' -si @i_AllJobsInCycle = 2
'
 + CHAR(10) + '-- 	script_name: QS_ExtendRetainAllJobsInCycle.'
 + CHAR(10) + '-- 	Retain all jobs in a cycle with selected Full job for Extended Retention.'
)
GO

