

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_EncryptionConfig.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_EncryptionConfig <<<'

IF EXISTS (select * from sysobjects where name='QS_EncryptionConfig')
	drop procedure QS_EncryptionConfig
IF EXISTS (select * from GxQscripts where name='QS_EncryptionConfig')
	delete from GxQscripts where name = 'QS_EncryptionConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_EncryptionConfig')
	delete from GXDBVersions where aliasname = 'QS_EncryptionConfig'
GO
print '... Creating Procedure: QS_EncryptionConfig'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_EncryptionConfig
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @clientName varchar(1024) = '%s',
  @subclientname varchar(1024)='%s',
  @opt varchar(1024) = '%s',
  @iEncryptionTypeStr varchar(1024) = '%s'
AS
SET QUOTED_IDENTIFIER ON
Set NOCOUNT ON
-------------------------------------------
-- INPUT :
-------------------------------------------
--DECLARE @ClientName			nvarchar(1024)
--SET		@ClientName			= N'%s'
--DECLARE @SubClientName		nvarchar(1024)
--SET		@SubClientName		= N'%s'
--DECLARE @OPT				varchar(1024)
--SET		@OPT				= '%s'
--DECLARE @iEncryptionTypeStr	varchar(512)
--SET		@iEncryptionTypeStr	= '%s'
---------------------------------------
--test
--SET		@ClientName			= 'all'
--SET		@SubClientName		= 'all'
--SET		@OPT				= 'get'
--SET		@iEncryptionType	= 0
---------------------------------------
---- Convenience Definitions    -----------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'EncryptionConfig'
DECLARE @nowTime				integer
SET     @nowTime				= dbo.GetUnixTime (GetUTCdate())
DECLARE @NoParameter			varchar(10)
SET		@NoParameter			='%'						-- Get Around QScript Parameter
SET		@NoParameter			=@NoParameter + 's'			-- .. Substitution
-------- Local Variables    -------------
DECLARE @clientId				integer
SET @clientId					= 0
DECLARE @subClientId			integer
SET @subClientId				= 0
DECLARE @lastError				integer
SET @lastError					= 0
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			= 'No error encountered when running script.'
DECLARE @iEncryptionType		INTEGER
SET		@iEncryptionType		= -1
DECLARE @tClients				TABLE	(	id	INTEGER)
DECLARE @tSubClients			TABLE	(	id	INTEGER)
DECLARE @tSCPSubClients			TABLE	(	id	INTEGER)
IF LOWER(@OPT) = 'set'
BEGIN
	IF @iEncryptionTypeStr = @NoParameter
	BEGIN
		SET @lastError = 1
		SET @localErrorMsg = 'Error. Parameter4 property value is not mentioned'
		goto ARGS_ERROR
	END
	SET @iEncryptionType = convert(integer, @iEncryptionTypeStr)
	IF @iEncryptionType < 0 OR @iEncryptionType > 3
	BEGIN
		PRINT N'Encryption Parameter is invalid'
		PRINT N'	0 - None'
		PRINT N'	1 - Media Only (Media Agent Side)'
		PRINT N'	2 - Network and Media (Agent Side)'
		PRINT N'	3 - Network Only (Agent Encrypts, Media Agent Decrypts)'
		SET @lastError = 1
		SET @localErrorMsg = 'Error. Invalid encryption type parameter.'
		goto ARGS_ERROR
	END
END
-- Parse Client Name parameter
IF LOWER(@ClientName) = N'all'
BEGIN
	INSERT @tClients(id) SELECT id FROM App_Client WHERE id > 1
END
ELSE
BEGIN
	IF LOWER(SUBSTRING(@ClientName, 1, 2)) = N'c='
	BEGIN
		set @clientId= ISNULL((SELECT TOP(1) id from APP_CLIENT WHERE name = (SELECT SUBSTRING(@ClientName, 3, LEN(@ClientName)-2))),0)
		IF @clientId = 0
		BEGIN
			SET @lastError = 2
			SET @localErrorMsg = 'Error.  Client ['+ (SELECT SUBSTRING(@ClientName, 3, LEN(@ClientName)-2)) + '] Does not exist.'
			goto ARGS_ERROR
		END
	END
	ELSE
	BEGIN
		SET @lastError = 3
		SET @localErrorMsg = 'Error.  Parameter1 must be specified as all or c=clientName.'
		goto ARGS_ERROR
	END
	INSERT @tClients(id)
	SELECT id from APP_CLIENT WHERE name = (SELECT SUBSTRING(@ClientName, 3, LEN(@ClientName)-2))
END
-- Parse Sub Client Name parameter
IF LOWER(@SubClientName) = N'all'
BEGIN
	INSERT @tSubClients(id) SELECT id FROM App_Application WHERE clientId IN (SELECT id AS clientId FROM @tClients)
END
ELSE
BEGIN
	IF LOWER(@ClientName) = N'all'
	BEGIN
		SET @lastError = 4
		SET @localErrorMsg = 'Error.  Parameter2 must be all when Parameter1 is all.'
		goto ARGS_ERROR
	END
	IF LOWER(SUBSTRING(@SubClientName, 1, 2)) = N's='
	BEGIN
		set @subClientId= ISNULL((SELECT TOP(1) id from App_Application WHERE subclientName = (SELECT SUBSTRING(@SubClientName, 3, LEN(@SubClientName)-2))
									AND clientId IN (SELECT id AS clientId FROM @tClients)),0)
		IF @subClientId = 0
		BEGIN
			SET @lastError = 5
			SET @localErrorMsg = 'Error.  Sub Client ['+ (SELECT SUBSTRING(@SubClientName, 3, LEN(@SubClientName)-2)) + '] Does not exist.'
			goto ARGS_ERROR
		END
	END
	ELSE
	BEGIN
		SET @lastError = 6
		SET @localErrorMsg = 'Error.  Parameter2 must be specified as all or s=subClientName.'
		goto ARGS_ERROR
	END
	INSERT @tSubClients(id)
	SELECT id from App_Application WHERE subclientName = (SELECT SUBSTRING(@SubClientName, 3, LEN(@SubClientName)-2))
		AND clientId IN (SELECT id AS clientId FROM @tClients)
	IF LOWER(@OPT) = 'set'
	BEGIN
		IF (SELECT COUNT(id)
		FROM @tSubClients
		WHERE id IN
			(
				(SELECT DISTINCT ComponentNameId FROM App_SubClientProp
				WHERE AttrName = 'Associated subclient Policy' AND Modified = 0)
				UNION
				(SELECT DISTINCT Id FROM App_Application WHERE AppTypeId = 1030)
			)) > 0
		BEGIN
			SELECT DISTINCT 'Error! can not modify sub client "' + A.subClientName + '", it has associated subclient policy.'
			FROM @tSubClients AS T INNER JOIN App_Application AS A ON T.id = A.id
			WHERE T.id IN
				(
					(SELECT DISTINCT ComponentNameId FROM App_SubClientProp
					WHERE AttrName = 'Associated subclient Policy' AND Modified = 0)
					UNION
					(SELECT DISTINCT Id FROM App_Application WHERE AppTypeId = 1030)
				)
			SET @lastError = 9
			SET @localErrorMsg = 'Error. Subclient policy is associated with mentioned sub client.'
			goto ARGS_ERROR
		END
	END
END
-- Remove hidden, dummy and deleted subclients
DELETE FROM @tSubClients
WHERE id IN
(
	SELECT Id FROM App_Application
	WHERE (subClientStatus & 0x4) <> 0 OR
		(subClientStatus & 0x10) <> 0 OR
		(subClientStatus & 0x20) <> 0
)
INSERT @tSCPSubClients(id)
SELECT id FROM @tSubClients
WHERE id IN
(
	SELECT DISTINCT ComponentNameId FROM App_SubClientProp
	WHERE AttrName = 'Associated subclient Policy' AND Modified = 0
)
DELETE FROM @tSubClients
WHERE id IN
(
	SELECT DISTINCT ComponentNameId FROM App_SubClientProp
	WHERE AttrName = 'Associated subclient Policy' AND Modified = 0
)
IF LOWER(@OPT) = 'get'
BEGIN
	-- To get encryption properties
	(
		SELECT	C.name AS ClientName,
				A.subclientName AS SubClientName,
				EncryptionType=
				CASE SP.attrVal
					WHEN 0 THEN 'None'
					WHEN 1 THEN 'Media Only (Media Agent Side)'
					WHEN 2 THEN 'Network and Media (Agent Side)'
					WHEN 3 THEN 'Network Only (Agent Encrypts, Media Agent Decrypts)'
					ELSE 'unknown'
				END
		FROM @tSubClients AS T INNER JOIN App_Application AS A ON T.id = A.Id
				INNER JOIN App_Client AS C ON C.id = A.clientId
				INNER JOIN App_SubClientProp AS SP ON A.id = SP.componentNameId
				WHERE SP.attrName = 'Encrypt: encryption' AND SP.attrType = 10 AND SP.modified = 0
	)
	UNION ALL
	(
		SELECT	C.name AS ClientName,
				A.subclientName AS SubClientName,
				EncryptionType=
				CASE SP.attrVal
					WHEN 0 THEN 'None'
					WHEN 1 THEN 'Media Only (Media Agent Side)'
					WHEN 2 THEN 'Network and Media (Agent Side)'
					WHEN 3 THEN 'Network Only (Agent Encrypts, Media Agent Decrypts)'
					ELSE 'unknown'
				END
		FROM App_Application AS A
			INNER JOIN App_Client AS C ON C.id = A.clientId
			INNER JOIN App_SubClientProp AS SP ON A.id = SP.componentNameId
			WHERE SP.attrName = 'Encrypt: encryption' AND SP.attrType = 10 AND SP.modified = 0
			AND A.id IN (
				SELECT attrVal AS id FROM App_SubClientProp
				WHERE AttrName = 'Associated subclient Policy' AND Modified = 0
				AND componentNameId IN (
					SELECT id FROM @tSCPSubClients
			)
		)
	)
END
ELSE IF LOWER(@OPT) = 'set'
BEGIN
	BEGIN TRY
		BEGIN TRANSACTION
			INSERT App_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
			SELECT componentNameId, attrName, attrType, @iEncryptionType, @nowTime, 0
			FROM App_SubClientProp AS SP
			WHERE SP.attrName = 'Encrypt: encryption' AND SP.attrType = 10 AND SP.modified = 0
				AND attrVal <> CONVERT(nvarchar(1024), @iEncryptionType)
				AND SP.componentNameId IN (SELECT id AS componentNameId FROM @tSubclients)
			UPDATE App_SubClientProp SET modified = @nowTime
			WHERE attrName = 'Encrypt: encryption' AND attrType = 10 AND modified = 0
				AND attrVal <> CONVERT(nvarchar(1024), @iEncryptionType)
				AND componentNameId IN (SELECT id AS componentNameId FROM @tSubclients)
		COMMIT TRANSACTION
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SELECT @lastError = ERROR_NUMBER(), @localErrorMsg = ERROR_MESSAGE()
		PRINT N'Error occured. ErrorNo(' + CAST(@lastError AS NVARCHAR) + N') ErrorMsg(' + @localErrorMsg + N').'
		IF (XACT_STATE()) <> 0
		BEGIN
			PRINT N'So Rolling back Transactions.'
			ROLLBACK TRANSACTION
		END
	END CATCH
END
ELSE
BEGIN
	SET @lastError = 7
	SET @localErrorMsg ='Error, Parameter3 must be set or get.'
	goto ARGS_ERROR
END
ARGS_ERROR:
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with '
         + ' Exit Code(' +convert(varchar(2), @lastError) + ').'
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_EncryptionConfig')
	delete from GxQscripts where name = 'QS_EncryptionConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_EncryptionConfig')
	delete from GXDBVersions where aliasname = 'QS_EncryptionConfig'
GO

insert into GXDBVersions values(2, 'QS_EncryptionConfig',  '00000000000000000000', 'QS_EncryptionConfig', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_EncryptionConfig',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	Examples:
'
 + CHAR(10) + '	To set the encryption to Media Only for subclient01 in client01:
'
 + CHAR(10) + '	Qoperation execscript -sn EncryptionConfig.sql -si c=client01 -si s=subclient01 -si set -si 1
'
 + CHAR(10) + '	To set the encryption to Network and Media for all subclients in client01:
'
 + CHAR(10) + '	Qoperation execscript -sn EncryptionConfig.sql -si c=client01 si all -si set -si 2
'
 + CHAR(10) + '	To set the encryption to Network Only for all subclients in a CommCell
'
 + CHAR(10) + '	Qoperation execscript -sn EncryptionConfig.sql -si all -si all -si set -si 3
'
 + CHAR(10) + '	To reset the encryption for subclient01 in client01:
'
 + CHAR(10) + '	Qoperation execscript -sn EncryptionConfig.sql -si c=client01 -si s=subclient01 -si set -si 0
'
 + CHAR(10) + '	To get the encryption for subclient01 in client01 - this will provide the encryption properties of the subclient as an output in the command console:
'
 + CHAR(10) + '	Qoperation execscript -sn EncryptionConfig.sql -si c=client01 -si s=subclient01 -si get
'
 + CHAR(10) + '--   script_name : EncryptionConfig'
)
GO

