

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_EnableTFAWithGroupInclusion.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_EnableTFAWithGroupInclusion.sp,v $ $Id: QS_EnableTFAWithGroupInclusion.sp,v 1.1.6.6 2020/07/06 16:13:12 pwang Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_EnableTFAWithGroupInclusion')
BEGIN
	print '>>> Drop Stored Procedure: QS_EnableTFAWithGroupInclusion <<<'
	drop procedure QS_EnableTFAWithGroupInclusion
END
IF EXISTS (select * from GxQscripts where name='QS_EnableTFAWithGroupInclusion')
	delete from GxQscripts where name = 'QS_EnableTFAWithGroupInclusion'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_EnableTFAWithGroupInclusion')
	delete from GXDBVersions where aliasname = 'QS_EnableTFAWithGroupInclusion'
GO
print '... Creating Procedure: QS_EnableTFAWithGroupInclusion'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_EnableTFAWithGroupInclusion
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- SP Input Params
  @enableTFA NVARCHAR(256) = ''		-- If no input parameter is provided, for backward compatibility will default to '2', which is enable TFA with user group inclusion 
AS
Set NOCOUNT ON
SET QUOTED_IDENTIFIER ON
------------ Convenience Definitions    -----------
	DECLARE @scriptName varchar(64)
    SET     @scriptName = 'QS_EnableTFAWithGroupInclusion'
    DECLARE @lastError  integer
    SET     @lastError  = 0
    DECLARE @localErrorMsg      varchar(512)
    SET     @localErrorMsg          ='Successful.'
	DECLARE @id integer = 0
    --------------Actual execution ------------------------
    BEGIN TRY
		IF @enableTFA IS NULL OR @enableTFA = '' OR @enableTFA = '2'
		BEGIN
			SET @enableTFA = '2'
			PRINT 'Enable two factor authentication with user group inclusion'
		END
		ELSE IF @enableTFA = '0'
		BEGIN
			PRINT 'Disable two factor authentication'
		END
		ELSE IF @enableTFA = '1'
		BEGIN
			PRINT 'Enable two factor authentication'
		END
		ELSE
		BEGIN
			SET @lastError = 1
			SET @localErrorMsg = 'Error. Input param must be a supported two factor authentication setting'
			GOTO PROC_ERROR
		END
		DECLARE @currentTFASettingCommcell INT = -1
		IF EXISTS(SELECT TOP 1 VALUE FROM GXGLOBALPARAM WHERE NAME = 'EnableTwoFactorAuthentication')
		BEGIN
			select TOP 1 @id = ID, @currentTFASettingCommcell = CAST(value AS INT) from GXGlobalParam where name = 'EnableTwoFactorAuthentication' ORDER BY ID DESC
			UPDATE GxGlobalParam SET VALUE = @enableTFA WHERE ID = @id
		END
		ELSE
		BEGIN
			INSERT INTO GXGLOBALPARAM(NAME, VALUE, CREATED, MODIFIED) VALUES('EnableTwoFactorAuthentication', @enableTFA, dbo.GetUnixTime (GETUTCDATE()), 0)
		END
		IF @enableTFA = '1'
		BEGIN
			DECLARE @tmptable TABLE (errorCode INT, errorString NVARCHAR(1024))
			INSERT INTO @tmptable
EXEC AppSetTFAForUserGroups 1, 0, 1, 0, 1
		END
		-- REMOVE PROPERTY 'DisableTwoFactorAuthentication' THAT HAS BEEN SET FOR COMMCELL USER GROUPS, BECAUSE LATER USER WILL USE QSCRIPT updateUserGroupUserPropertiesCap TO ENABLE TFA FOR SELECTED USER GROUPS,
		-- WHICH WILL ADD THIS PROPERTY TO SELECTED USER GROUPS
IF @currentTFASettingCommcell IS NOT NULL AND @currentTFASettingCommcell <> 2 AND CAST(@enableTFA AS INT) = 2
		BEGIN
			DELETE UMGP
			FROM UMGroupsProp UMGP
JOIN UMGroups UMP ON UMGP.attrName = 'DisableTwoFactorAuthentication' AND UMP.umdsproviderId = 0 AND UMGP.componentNameId = UMP.id
		END
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET @lastError = @@error
		SET @localErrorMsg = (SELECT ERROR_MESSAGE())
	END CATCH
	--------------On Error or completion ------------------
	PROC_ERROR:
		PRINT ''
		PRINT @scriptName + ' completed at '
						+ Convert(varchar(60), getdate())
						+ '. ErrorCode (' + Convert(varchar(2),@lastError) +').'
						+ ' ErrorMessage (' + @localErrorMsg + ')'
		if @lastError <> 0
			Raiserror(@localErrorMsg,
						15,  --Severity (> 10 to force DOS Error Code = 1)
						1	 --State
						)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_EnableTFAWithGroupInclusion')
	delete from GxQscripts where name = 'QS_EnableTFAWithGroupInclusion'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_EnableTFAWithGroupInclusion')
	delete from GXDBVersions where aliasname = 'QS_EnableTFAWithGroupInclusion'
GO

insert into GXDBVersions values(2, 'QS_EnableTFAWithGroupInclusion',  '00010001000600060000', 'QS_EnableTFAWithGroupInclusion', '00010001000600060000')
GO

insert into GxQscripts values(2,'QS_EnableTFAWithGroupInclusion',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn QS_EnableTFAWithGroupInclusion
'
 + CHAR(10) + '-- 	script_name: QS_EnableTFAWithGroupInclusion.'
 + CHAR(10) + '-- 	'
 + CHAR(10) + '--     Example: qoperation execscript -sn QS_EnableTFAWithGroupInclusion -si enableTFA'
)
GO

