

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_EnableSystemState.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_EnableSystemState <<<'

IF EXISTS (select * from sysobjects where name='QS_EnableSystemState')
	drop procedure QS_EnableSystemState
IF EXISTS (select * from GxQscripts where name='QS_EnableSystemState')
	delete from GxQscripts where name = 'QS_EnableSystemState'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_EnableSystemState')
	delete from GXDBVersions where aliasname = 'QS_EnableSystemState'
GO
print '... Creating Procedure: QS_EnableSystemState'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_EnableSystemState
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @CLIENTNAME varchar(1024) = '%s',
  @BACKUPSETNAME VARCHAR(1024) = '%s'
AS
SET QUOTED_IDENTIFIER ON
--DECLARE @CLIENTNAME     varchar(1024)
--DECLARE @BACKUPSETNAME  varchar(1024)
--SET		@ClientName		= '%s'
--SET		@BACKUPSETNAME	= '%s'
DECLARE @debug integer
SET @debug = 0
------- TEST DATA (FAKE OUT QSCRIPT  -----------------
--SET @debug = 1
--SET   @CLIENTNAME = 'allclients'
--SET   @CLIENTNAME = 'c=bingo_cn'
--SET	@BACKUPSETNAME = 'a'
------------------------------------------------------
-------------  Convenience Definitions  ---------------------
DECLARE @scriptName				varchar(40)
SET		@scriptName				= 'EnableSystemStateOnDefaultSubclient'
DECLARE @sysStateProp varchar(32)
SET @sysStateProp = 'System State'
DECLARE @nowTime   integer
SET		@nowTime  =   dbo.GetUnixTime (GetUTCdate())DECLARE @srcSubClientID   int
DECLARE @newValue varchar(5)
SET @newValue = '1'
DECLARE @allClientsOption		varchar(32)
set		@allClientsOption		= 'allClients'
DECLARE @oneClientOption		varchar(10)
SET		@oneClientOption		='c='
DECLARE @NoParameter            varchar(10)
SET     @NoParameter            ='%'                        -- Get Around QScript Parameter
SET     @NoParameter            =@NoParameter + 's'         -- .. Substitution
DECLARE @defaultStatusBit  integer
SET		@defaultStatusBit = 8						-- Default SubClient
DECLARE @invalidStatusBits  integer
SET		@invalidStatusBits = 4+2					-- DELETED, UNINSTALLED
DECLARE @lastError		int
SET		@lastError = 0							-- Be pessimistic
DECLARE	@errorString	varchar(1024)
set		@errorString = 'Error encountered when running script'
DECLARE @describeSC		varchar(1024)
set		@describeSC  = 'Unknown SubClient'
---------------------------------------
---  SPECIFIC CLIENT OR ALL CLIENTS ---
---------------------------------------
DECLARE @clientId    integer
IF @ClientName = @allClientsOption
	SET @clientId =0
ELSE
BEGIN
	IF SUBSTRING(@ClientName, 1, 2) = @oneClientOption
	BEGIN
		set @clientId= ISNULL((SELECT id from APP_CLIENT WHERE name = (SELECT SUBSTRING(@ClientName, 3, LEN(@ClientName)-2))),0)
		IF @clientId = 0
		BEGIN
			SET @errorString = 'Error.  Client ['+ (SELECT SUBSTRING(@ClientName, 3, LEN(@ClientName)-2)) + '] Does not exist.'
			Set @lastError = 1
			goto   ARGS_ERROR
		END
	END
	ELSE
	BEGIN
		SET @errorString = 'Error.  Parameter1 must be specified as allclients or c=clientName.'
		Set @lastError = 1
		goto   ARGS_ERROR
	END
END
IF @debug = 1
	SELECT 'clientId', @clientId
--IS BACKUPSETNAME PRESENT---
----------------------------------------------------------------------
DECLARE @backupSetId integer
IF @BACKUPSETNAME = @NoParameter
BEGIN
	SET @backupSetId = 0
END
ELSE
BEGIN
	SET @backupSetId = (Select DISTINCT BSN.id from APP_BACKUPSETNAME AS BSN, APP_APPLICATION AS APP
						  where
							APP.clientId = @clientId
							AND APP.backupSet = BSN.id
							AND BSN.name = @BACKUPSETNAME
							AND appTypeId in (1,11,33,34,42,43)
							)
	IF @backupSetId is NulL
	BEGIN
		Set @lastError = 1
		SET @errorString = 'Error : No backupset with name ['+@BACKUPSETNAME+'] exists.'
		goto ARGS_ERROR
	END
END
---DO NOT SET SYSTEM STATE WEHN BACKUPSET IS ASSOCIATED WITH SUBCLIENT POLICY
declare @SubclientPolicyBackupsets table(backupsetId integer)
INSERT INTO @SubclientPolicyBackupsets
SELECT DISTINCT(SC.backupset) FROM APP_Application SC JOIN APP_BackupSetName BS
		ON SC.backupset = BS.id JOIN APP_BackupsetProp BSPROP
		ON BS.id = BSPROP.componentnameid
		WHERE appTypeId in (1,11,33,34,42,43)
		  AND BSPROP.Attrname = 'Associated subclient Policy' AND BSPROP.modified = 0 AND BSPROP.AttrVal > 0
IF @backupSetId in (SELECT backupSetId FROM @SubclientPolicyBackupsets)
BEGIN
	Set @lastError = 1
	SET @errorString = 'Error : Backupset ['+@BACKUPSETNAME+'] is associated with a subclient policy. Cannot Enable System State.'
	goto ARGS_ERROR
END
IF @debug = 1
BEGIN
	SELECT 'backupSetId', @backupSetId
	SELECt 'SCP associated', * from @SubclientPolicyBackupsets SCP_bs, APP_backupsetNAme BS where scp_bs.backupsetId = BS.id
END
--------------------------------------------------------------
--GET LIST OF DEFAULT SUBCLIENTS TO ENABLE SYSTEM STATE
--AND LISt OF OTHER SUBCLIENTS THAT  ALREADY HAVE SYSTEM STATE ENABLED IN ORDER TO RESET
--------------------------------------------------------------
declare  @SetsubclientList table(subclientId integer)
declare  @ResetSubclientList table(subclientId integer)
IF @clientId <> 0 AND @backupSetId <> 0
BEGIN
	INSERT @SetsubclientList
	SELECT id FROM APP_Application
		WHERE clientId = @clientId
		  AND  backupSet = @backupSetId
	      AND  appTypeId in (1,11,33,34,42,43)
		  AND (subClientStatus & @defaultStatusBit) <> 0
		  AND (subClientStatus & @invalidStatusBits) =  0
		  AND backupSet NOT IN(SELECT backupsetId FROM  @SubclientPolicyBackupsets)
	INSERT @ResetsubclientList
	SELECT SC.id FROM APP_Application SC JOIN App_subclientProp  ScProp
		ON SC.id = ScProp.componentNameId
		WHERE SC.clientId = @clientId
		  AND  SC.backupSet = @backupSetId
	      AND  SC.appTypeId in (1,11,33,34,42,43)
		  AND (SC.subClientStatus & @defaultStatusBit) = 0
		  AND (SC.subClientStatus & @invalidStatusBits) =  0
		  AND ScProp.attrName like @sysStateProp
		  AND ScProp.modified = 0
		  AND ScProp.attrVal = '1'
		  AND SC.backupSet NOT IN(SELECT backupsetId FROM  @SubclientPolicyBackupsets)
END
ELSE IF @clientId <> 0 AND @backupSetId = 0
BEGIN
	INSERT @SetsubclientList
	SELECT id FROM APP_Application sc
		WHERE clientId = @clientId
	      AND  appTypeId in (1,11,33,34,42,43)
		  AND (subClientStatus & @defaultStatusBit) <> 0
		  AND (subClientStatus & @invalidStatusBits) =  0
		  AND backupSet NOT IN(SELECT backupsetId FROM  @SubclientPolicyBackupsets)
	INSERT @ResetsubclientList
	SELECT SC.id FROM APP_Application SC JOIN App_subclientProp  ScProp
		ON SC.id = ScProp.componentNameId
		WHERE clientId = @clientId
	      AND  appTypeId in (1,11,33,34,42,43)
		  AND (subClientStatus & @defaultStatusBit) = 0
		  AND (subClientStatus & @invalidStatusBits) =  0
		  AND ScProp.attrName like @sysStateProp
		  AND ScProp.modified = 0
		  AND ScProp.attrVal = '1'
		  AND SC.backupSet NOT IN(SELECT backupsetId FROM  @SubclientPolicyBackupsets)
END
ELSE IF @clientId = 0 AND @backupSetId = 0
BEGIN
	INSERT @SetsubclientList
	SELECT id FROM APP_Application SC
		WHERE  appTypeId in (1,11,33,34,42,43)
		  AND (subClientStatus & @defaultStatusBit) <> 0
		  AND (subClientStatus & @invalidStatusBits) =  0
		  AND backupSet NOT IN(SELECT backupsetId FROM  @SubclientPolicyBackupsets)
	INSERT @resetsubclientList
	SELECT SC.id FROM APP_Application SC JOIN App_subclientProp  ScProp
		ON SC.id = ScProp.componentNameId
		WHERE  appTypeId in (1,11,33,34,42,43)
		  AND (subClientStatus & @defaultStatusBit) = 0
		  AND (subClientStatus & @invalidStatusBits) =  0
		  AND ScProp.attrName like @sysStateProp
		  AND ScProp.modified = 0
		  AND ScProp.attrVal = '1'
		  AND SC.backupSet NOT IN(SELECT backupsetId FROM  @SubclientPolicyBackupsets)
END
ELSE
BEGIN
	Set @lastError = 1
	SET @errorString= 'No client['+@CLIENTNAME+ '], backupset['+@BACKUPSETNAME+'] found.'
	goto ARGS_ERROR
END
IF @debug = 1
BEGIN
	SELECT 'enable', sc.subclientId, app.subclientName, app.subclientStatus FROM @SetsubclientList sc, APP_Application app where sc.subclientId = app.id
	SELECT 'disable', sc.subclientId, app.subclientName, app.subclientStatus FROM @resetsubclientList sc, APP_Application app where sc.subclientId = app.id
END
DECLARE @scId integer
BEGIN TRAN
DECLARE subClientCursor CURSOR STATIC FOR
  SELECT subclientid from @SetsubclientList
    OPEN subClientCursor
    FETCH NEXT FROM subClientCursor INTO @scId
    WHILE @@FETCH_STATUS = 0
    BEGIN
		DECLARe @subclientNAme varchar(100)
		SET @subclientNAme = (select subclientname from app_application where id = @scid)
		IF @debug = 1
			Print 'subclient ['+@subclientNAme+'].'
		DECLARE @oldValue integer
		SET @oldValue  = ISNULL((SELECT attrVal FROM APP_SUBCLIENTPROP
				WHERE componentNameId = @scId
				AND   attrName = @sysStateProp
				AND   modified = 0), 0)
		IF @oldValue <> @newValue
		BEGIN
			UPDATE APP_SUBCLIENTPROP SET Modified = @nowTime WHERE componentNameId = @scId
					AND   attrName = @sysStateProp
					AND   modified = 0
			SET @lastError = @@error
			IF @lastError <> 0
			BEGIN
				SET @errorString	='    Error[' +convert(varchar(12), @lastError)
							+'] when attempting aging of property ['
							+ @sysStateProp
							+ ' for subClient '
							+ cast (@scId as nvarchar(10))
							+ 'All changes will be rolled back for this client.'
				GOTO TRANS_EXIT
			END
			INSERT APP_SUBCLIENTPROP(componentNameId, attrName, attrType, attrVal, created, modified)
						VALUES (@scId, @sysStateProp, 2, @newValue, @nowTime, 0)
			SET @lastError = @@error
			IF @lastError <> 0
			BEGIN
				SET @errorString	='    Error[' +convert(varchar(12), @lastError)
							+'] when attempting aging of property ['
							+ @sysStateProp
							+ ' for subClient '
							+ cast (@scId as nvarchar(10))
							+ 'All changes will be rolled back for this client.'
				GOTO TRANS_EXIT
			END
			IF @debug = 1
				PRINT 'Enabled successfully on subclient ['+ @subclientNAme +'].'
		END
		ELSE
		BEGIN
			IF @debug = 1
				Print 'No change for ['+@subclientNAme+'].'
			FETCH NEXT FROM subClientCursor INTO @scId
			CONTINUE
		END
		FETCH NEXT FROM subClientCursor INTO @scId
    END
IF @debug = 1
	PRINT 'Done enabling.'
DECLARE resetSubClientCursor CURSOR STATIC FOR
SELECT subclientid from @resetSubClientList
	IF @debug = 1
		PRINT 'Will disable on all other subclients'
    OPEN resetSubClientCursor
    FETCH NEXT FROM resetSubClientCursor INTO @scId
    WHILE @@FETCH_STATUS = 0
    BEGIN
		SET @subclientNAme = (select subclientname from app_application where id = @scid)
		IF @debug  = 1
			Print 'subclient ['+@subclientNAme+'].'
		SET @oldValue  = ISNULL((SELECT attrVal FROM APP_SUBCLIENTPROP
				WHERE componentNameId = @scId
				AND   attrName = @sysStateProp
				AND   modified = 0), 0)
		IF @oldValue  <> 0
		BEGIN
			UPDATE APP_SUBCLIENTPROP SET Modified = @nowTime WHERE componentNameId = @scId
					AND   attrName = @sysStateProp
					AND   modified = 0
			INSERT APP_SUBCLIENTPROP(componentNameId, attrName, attrType, attrVal, created, modified)
						VALUES (@scId, @sysStateProp, 2, 0, @nowTime, 0)
			SET @lastError = @@error
			IF @lastError <> 0
			BEGIN
				SET @errorString	='    Error[' +convert(varchar(12), @lastError)
							+'] when attempting aging of property ['
							+ @sysStateProp
							+ ' for subClient '
							+ cast (@scId as nvarchar(10))
							+ 'All changes will be rolled back for this client.'
				GOTO TRANS_EXIT
			END
			IF @debug  = 1
				PRINT 'Disabled successfully on subclient ['+ @subclientNAme +'].'
		END
		ELSE
		BEGIN
			IF @debug  = 1
				Print 'No change for ['+@subclientNAme+'].'
			FETCH NEXT FROM resetSubClientCursor INTO @scId
			CONTINUE
		END
		FETCH NEXT FROM resetSubClientCursor INTO @scId
    END
IF @debug = 1
	PRINT 'Done.'
TRANS_EXIT:
    CLOSE       subClientCursor
    DEALLOCATE  subClientCursor
    IF  CURSOR_STATUS('global', 'resetSubClientCursor') >= 0
    BEGIN
		CLOSE       resetSubClientCursor
		DEALLOCATE  resetSubClientCursor
	END
IF @LastError <> 0
	ROLLBACK TRAN
ELSE
BEGIN
	COMMIT TRAN
--ROLLBACK TRAN				-- (Use rollback for debugging purposes!)
END
PRINT Convert(varchar(60), getdate()) +' Complete ['+ @scriptName + ']. Exit Code(' +convert(varchar(2), @lastError) + ').'
ARGS_ERROR:
if @lastError <> 0
	Raiserror(@errorString,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
	)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_EnableSystemState')
	delete from GxQscripts where name = 'QS_EnableSystemState'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_EnableSystemState')
	delete from GXDBVersions where aliasname = 'QS_EnableSystemState'
GO

insert into GXDBVersions values(2, 'QS_EnableSystemState',  '00000000000000000000', 'QS_EnableSystemState', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_EnableSystemState',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn EnableSystemState -si allclients/c=clientName -si backupsetname
'
 + CHAR(10) + '--   script_name : EnableSystemState'
 + CHAR(10) + '	Use this script to enable system state on all default subclients across the CommServe.
'
 + CHAR(10) + '	This script can take client name and backup set name as inputs. (Both are optional.)
'
 + CHAR(10) + '	If both inputs are given, the default subclient under system state backup is enabled on the given client and backupset and disabled on all its peer subclients. If only the client name is given, the same is done on all active backupsets under the client. When ''allclients'' is used, the system state is enabled on all default subclients across the CommServe.
'
)
GO

