

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_EnableSubclientIndex.sp] ---------- 

-- ----------------------------------------------------------------------
-- Copyright (c) 2015 Commvault Systems, Inc.
-- All rights reserved.
--
-- This is unpublished proprietary source code of CommVault
-- Systems, Inc. The copyright notice above does not evidence
-- any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='QS_EnableSubclientIndex')
BEGIN
	print '>>> Drop Stored Procedure: QS_EnableSubclientIndex <<<'
	drop procedure QS_EnableSubclientIndex
END
IF EXISTS (select * from GxQscripts where name='QS_EnableSubclientIndex')
	delete from GxQscripts where name = 'QS_EnableSubclientIndex'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_EnableSubclientIndex')
	delete from GXDBVersions where aliasname = 'QS_EnableSubclientIndex'
GO
print '... Creating Procedure: QS_EnableSubclientIndex'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure QS_EnableSubclientIndex
  @param1 NVARCHAR(1024) = '%s',
  @agent NVARCHAR(128)  = '%s',
  @retSetting INT  = 2
AS
SET NOCOUNT ON
--
DECLARE @scriptName nvarchar(32) = 'EnableSubclientIndex';
DECLARE @errorCode int = 0;
DECLARE @errorString nvarchar(1024) = '';
IF @param1 = '%s'
BEGIN
	SET @errorCode = 1;
	SET @errorString = 'Error. Please provide client name or client group name as input.';
	GOTO ARGS_ERROR;
END
IF @agent = '%s'
BEGIN
	SET @errorCode = 1;
	SET @errorString = 'Error. Please provide agent id as input.';
	GOTO ARGS_ERROR;
END
DECLARE @clientNamePrefix nvarchar(8) = 'c=';
DECLARE @cGroupNamePrefix nvarchar(8)= 'cg=';
DECLARE @clientIdPrefix nvarchar(8) = 'cId=';
DECLARE @cGroupIdPrefix NVARCHAR(8) = 'cgId=';
DECLARE @agentTypePrefix NVARCHAR(16)='agentType='
DECLARE @clientId INT = 0
DECLARE @appTypeId INT = 0
DECLARE @cGroupId INT = 0
DECLARE @isClientGroup INT = 0
DECLARE @agentInput INT = 0
--
IF LEFT(@param1, 2) = @clientNamePrefix
BEGIN
	DECLARE @clientName nvarchar(1024) = RIGHT(@param1, LEN(@param1) - 2);
	SET @clientId = (SELECT C.id FROM APP_Client C WITH (NOLOCK) WHERE C.name = @clientName);
	IF @clientId IS NULL
	BEGIN
		SET @errorCode = 1;
		SET @errorString = 'Error. Client ['+ @clientName + '] does not exist.';
		GOTO ARGS_ERROR;
	END
END
ELSE IF LEFT(@param1, 3) = @cGroupNamePrefix
BEGIN
	DECLARE @cGroupName nvarchar(1024) = RIGHT(@param1, LEN(@param1) - 3);
	SET @cGroupId = (SELECT CG.id FROM APP_ClientGroup CG WITH (NOLOCK) WHERE CG.name = @cGroupName);
	IF @cGroupId IS NULL
	BEGIN
		SET @errorCode = 1;
		SET @errorString = 'Error. Client Group ['+ @cGroupName + '] does not exist.';
		GOTO ARGS_ERROR;
	END
	SET @isClientGroup = 1;
END
ELSE IF LEFT(@param1, 4) = @clientIdPrefix
BEGIN
	IF ISNUMERIC(RIGHT(@param1, LEN(@param1) - 4)) <> 1
	BEGIN
		SET @errorCode = 1;
		SET @errorString = 'Error. Invalid Client Id.';
		GOTO ARGS_ERROR;
	END
	SET @clientId = CAST(RIGHT(@param1, LEN(@param1) - 4) AS INT);
	IF NOT EXISTS(SELECT 1 FROM APP_Client C WITH (NOLOCK) WHERE C.id = @clientId)
	BEGIN
		SET @errorCode = 1;
		SET @errorString = 'Error. Client Id does not exist.';
		GOTO ARGS_ERROR;
	END
END
ELSE IF LEFT(@param1, 5) = @cGroupIdPrefix
BEGIN
	IF ISNUMERIC(RIGHT(@param1, LEN(@param1) - 5)) <> 1
	BEGIN
		SET @errorCode = 1;
		SET @errorString = 'Error. Invalid Client Group Id.';
		GOTO ARGS_ERROR;
	END
	SET @cGroupId = CAST(RIGHT(@param1, LEN(@param1) - 5) AS INT);
	IF NOT EXISTS(SELECT 1 FROM APP_ClientGroup CG WITH (NOLOCK) WHERE CG.id = @cGroupId)
	BEGIN
		SET @errorCode = 1;
		SET @errorString = 'Error. Client Group Id does not exist.';
		GOTO ARGS_ERROR;
	END
END
ELSE
BEGIN
	SET @errorCode = 1;
	SET @errorString = 'Error. Invalid input [' + @param1 + ']';
	GOTO ARGS_ERROR;
END
IF LEFT(@agent, 10) = @agentTypePrefix
BEGIN
	DECLARE @agentTypeId INT = RIGHT(@agent, LEN(@agent) - 10);
	SET @appTypeId = (SELECT T.type FROM APP_iDAType T  WITH (NOLOCK) WHERE T.type = @agentTypeId);
	IF @appTypeId IS NULL
	BEGIN
		SET @errorCode = 1;
		SET @errorString = 'Error. Agent Id ['+ @agentTypeId + '] does not exist.';
		GOTO ARGS_ERROR;
	END
END
ELSE IF @agent < 1 OR @agent >2
BEGIN
	SET @errorCode = 1;
	SET @errorString = 'Error. Invalid agent input [' + @agent + ']';
	GOTO ARGS_ERROR;
END
ELSE
	SET @agentInput = @agent
DECLARE @scIndexAttrName nvarchar(512) = 'Subclient Index'
DECLARE @curtime INT = dbo.GetUnixTime(GETUTCDATE())
IF object_id('tempdb.dbo.#tmpClients') IS NOT NULL DROP TABLE #tmpClients
CREATE TABLE #tmpClients(clientid INT, PRIMARY KEY(clientid))
IF @isClientGroup = 1
	INSERT INTO #tmpClients SELECT DISTINCT ACG.clientid FROM APP_ClientGroupAssoc ACG WITH (NOLOCK) WHERE ACG.clientGroupId = @cGroupId
ELSE
	INSERT INTO #tmpClients SELECT @clientId
--Allow subclient index only for cloud storage apps
IF @appTypeId <> 0 AND @appTypeId = 134
BEGIN
	DELETE #tmpClients FROM #tmpClients TC JOIN
APP_Application APP WITH (NOLOCK) ON TC.clientid = APP.clientId AND APP.appTypeId = 134
	JOIN APP_InstanceProp IP WITH (NOLOCK) ON IP.componentNameId = APP.instance
	AND IP.attrName = 'Cloud Apps Instance Type' AND IP.modified = 0 AND IP.attrVal NOT IN ('5', '6', '14', '15', '20', '21', '24', '25')
	IF NOT EXISTS (SELECT 1 FROM #tmpClients)
	BEGIN
		SET @errorCode = 1;
		SET @errorString = 'Error. Selected client/s do not support subclient indexing for [' + @agent + ']';
		GOTO ARGS_ERROR;
	END
END
UPDATE IDAP
SET IDAP.attrVal = '1'
FROM APP_IDAProp IDAP WITH (NOLOCK)
JOIN APP_IDAName IDA WITH (NOLOCK) ON IDA.id = IDAP.componentNameId
JOIN APP_Client C WITH (NOLOCK) ON C.id = IDA.clientId
JOIN #tmpClients TC ON C.id = TC.clientid
WHERE C.releaseId >= 16 AND IDAP.attrName = @scIndexAttrName AND
(
(@agent IS NULL AND (dbo.isFileSystemAppType(IDA.appTypeId) = 1 OR IDA.appTypeId = 13)) OR
(@appTypeId <> 0 AND IDA.appTypeId = @appTypeId AND (dbo.isFileSystemAppType(IDA.appTypeId) = 1 OR IDA.appTypeId IN (13, 134))) OR
	(@agentInput = 1 AND dbo.isFileSystemAppType(IDA.appTypeId) = 1) OR
(@agentInput = 2 AND IDA.appTypeId = 13)
)
INSERT INTO APP_IDAProp(componentNameId, attrName, attrType, attrVal, created, modified)
SELECT DISTINCT IDA.id, @scIndexAttrName, 2, 1, @curtime, 0
FROM APP_IDAName IDA WITH (NOLOCK)
JOIN APP_iDAType IDAT WITH (NOLOCK) ON IDA.appTypeId = IDAT.type
JOIN APP_Client C WITH (NOLOCK) ON C.id = IDA.clientId
JOIN #tmpClients TC ON C.id = TC.clientid
LEFT JOIN APP_IDAProp IDAP WITH (NOLOCK) ON IDAP.componentNameId = IDA.id AND IDAP.attrName = @scIndexAttrName
WHERE IDAP.componentNameId IS NULL AND C.releaseId >= 16 AND
(
(@agent IS NULL AND (dbo.isFileSystemAppType(IDA.appTypeId) = 1 OR IDA.appTypeId = 13)) OR
(@appTypeId <> 0 AND IDA.appTypeId = @appTypeId AND (dbo.isFileSystemAppType(IDA.appTypeId) = 1 OR IDA.appTypeId IN (13, 134))) OR
	(@agentInput = 1 AND dbo.isFileSystemAppType(IDA.appTypeId) = 1) OR
(@agentInput = 2 AND IDA.appTypeId = 13)
)
DECLARE @enablePruning VARCHAR(128) = 'Enable Index Pruning'
DECLARE @retCycle VARCHAR(128) = 'IndexPruning_DBRetentionCycle'
DECLARE @retDays VARCHAR(128) = 'IndexPruning_DBRetentionDays'
DECLARE @pruningType VARCHAR(128) = 'IndexPruning_Type'
IF NOT EXISTS(SELECT value FROM GXGlobalParam WITH (NOLOCK) WHERE name = @enablePruning and modified=0)
BEGIN
INSERT INTO GXGlobalParam(name,value,created,modified)
	VALUES
	(@enablePruning,1,@curtime,0),
	(@retCycle,-1,@curtime,0),
	(@retDays,-1,@curtime,0),
	(@pruningType,0,@curtime,0)
END
ELSE
	UPDATE GXGlobalParam SET value = 1,modified=0 WHERE name = @enablePruning
IF @retSetting = 0
	SET @retSetting = 2
DECLARE @temp TABLE(t_Name NVARCHAR(128),t_val INT)
INSERT INTO @temp
VALUES
(@enablePruning,1),
(@retCycle,@retSetting),
(@retDays,0),
(@pruningType,1)
IF object_id('tempdb.dbo.#bkpstAppidList') is not null
	DROP TABLE #bkpstAppidList
CREATE TABLE #bkpstAppidList ( t_bkpstId INT, t_appId INT)
-- Insert default 2 cycles for subclient under the agent where subclient index is enabled
--Flip pruning settings from backupset to subclient level
INSERT INTO #bkpstAppidList
SELECT DISTINCT App.backupSet, App.Id
FROM #tmpClients TC
JOIN APP_Application App WITH (NOLOCK) ON TC.clientId = App.clientId
JOIN APP_IDAName IDA WITH (NOLOCK) ON IDA.clientId = App.clientId AND IDA.appTypeId = App.appTypeId
JOIN APP_IDAProp IDAP WITH (NOLOCK) ON IDAP.componentNameId = IDA.id AND IDAP.attrName = @scIndexAttrName
WHERE App.subclientName NOT IN ('IndexingSubclient','DDBBackup','DR Subclient') AND
(
(@agent IS NULL AND (dbo.isFileSystemAppType(IDA.appTypeId) = 1 OR IDA.appTypeId = 13)) OR
(@appTypeId <> 0 AND IDA.appTypeId = @appTypeId AND (dbo.isFileSystemAppType(IDA.appTypeId) = 1 OR IDA.appTypeId IN (13, 134))) OR
	(@agentInput = 1 AND dbo.isFileSystemAppType(IDA.appTypeId) = 1) OR
(@agentInput = 2 AND IDA.appTypeId = 13)
)
MERGE APP_SubClientProp T
USING (
SELECT bkpAppid.t_appId as appId, tmp.t_Name, tmp.t_val
FROM  @temp tmp, #bkpstAppidList bkpAppid ) S
ON T.componentNameId = S.appId AND T.attrName = S.t_name
WHEN MATCHED
	THEN UPDATE SET T.attrVal = S.t_val
WHEN NOT MATCHED BY TARGET
    THEN INSERT (componentNameId,attrName,attrType,attrVal,created,modified, ccpId)
	VALUES (S.appId, S.t_name , 7, S.t_val , @curtime, 0, 0)
;
-- index server of subclient should be what backupset was having. Load balancing or manual intervention can later change that.
INSERT INTO App_IndexDbInfo(dbName,type,idxDbEngineType,backupSetId,currentIdxServer,backupSetGUID,properties,isPrimary, committedTransactionId, archGroupId, flags)
SELECT App.Guid, info.type, info.idxDbEngineType, tmp.t_bkpstId, info.currentIdxServer, info.backupSetGUID, info.properties, info.isPrimary, info.committedTransactionId, info.archGroupId, info.flags
FROM #bkpstAppidList tmp
JOIN App_IndexDbInfo info ON tmp.t_bkpstId = info.backupSetId AND info.idxDbEngineType = 1
JOIN APP_Application App WITH (NOLOCK) ON tmp.t_appId = App.Id
--Remove the property from backupset level
DELETE FROM APP_BackupSetProp
FROM #bkpstAppidList bkpAppid WHERE bkpAppid.t_bkpstId = componentNameId AND
attrName IN (@enablePruning, @retCycle, @retDays, @pruningType)
IF object_id('tempdb.dbo.#bkpstAppidList') is not null
	DROP TABLE #bkpstAppidList
--
ARGS_ERROR:
 SELECT @scriptName + ' completed at ' + CONVERT(nvarchar(60), GETDATE())
+ '. Error Code ['+ CONVERT(nvarchar(2), @errorCode) +'].'
IF @errorCode <> 0
	RAISERROR(@errorString, 15 /* Severity > 10 to force DOS error code 1 */, 1);
GO
GO

IF EXISTS (select * from GxQscripts where name = 'QS_EnableSubclientIndex')
	delete from GxQscripts where name = 'QS_EnableSubclientIndex'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_EnableSubclientIndex')
	delete from GXDBVersions where aliasname = 'QS_EnableSubclientIndex'
GO

insert into GXDBVersions values(2, 'QS_EnableSubclientIndex',  '00000000000000000000', 'QS_EnableSubclientIndex', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_EnableSubclientIndex',  0, GETDATE(), GETDATE(), '' + CHAR(10) + ' Enables indexing at subclient level on input client or input client group for the given input agent type.
'
 + CHAR(10) + ' 
'
 + CHAR(10) + '--  qoperation execscript -sn EnableSubclientIndex.sql -si c=client_name -si <agent> -si <retentionCycle>'
 + CHAR(10) + '--  qoperation execscript -sn EnableSubclientIndex.sql -si cg=client_group_name -si <agent> -si <retentionCycle>'
 + CHAR(10) + '--  qoperation execscript -sn EnableSubclientIndex.sql -si cId=client_id -si <agent> -si <retentionCycle>'
 + CHAR(10) + '--  qoperation execscript -sn EnableSubclientIndex.sql -si cgId=client_group_id -si <agent> -si <retentionCycle>'
 + CHAR(10) + '--  Agent Mapping'
 + CHAR(10) + '--  1	-	FileSystem'
 + CHAR(10) + '--  2	-	NAS'
 + CHAR(10) + ' 
'
)
GO

