

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_EnableSearchEngineNode.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_EnableSearchEngineNode.sp,v $ $Id: QS_EnableSearchEngineNode.sp,v 1.2.14.4 2018/03/27 09:09:10 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_EnableSearchEngineNode <<<'

IF EXISTS (select * from sysobjects where name='QS_EnableSearchEngineNode')
	drop procedure QS_EnableSearchEngineNode
IF EXISTS (select * from GxQscripts where name='QS_EnableSearchEngineNode')
	delete from GxQscripts where name = 'QS_EnableSearchEngineNode'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_EnableSearchEngineNode')
	delete from GXDBVersions where aliasname = 'QS_EnableSearchEngineNode'
GO
print '... Creating Procedure: QS_EnableSearchEngineNode'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_EnableSearchEngineNode
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- SP Input Params
  @searchEngineClientName nvarchar(1024)
AS
Set NOCOUNT ON
------------ Convenience Definitions    -----------
	DECLARE @scriptName	varchar(32)
	SET		@scriptName	= 'QS_EnableSearchEngineNode'
	DECLARE @lastError	integer
	SET		@lastError	= 0
	DECLARE @localErrorMsg	varchar(512)
	SET		@localErrorMsg	='Error Encountered when running script.'
	DECLARE @now				integer
	DECLARE @userId				integer
	SET @now = dbo.GetUnixTime(GETDATE())
	SET @userId	 = 1	-- Until we find a way to fetch from Qcommand!
-----------------------validate parameters------------------------------
	DECLARE @clientId integer
	SET @clientId = ISNULL((SELECT id FROM APP_Client WITH (NOLOCK) WHERE name = @searchEngineClientName), 0)
	IF @clientId = 0
	BEGIN
		SET @lastError = 1
		SET @localErrorMsg = 'Error. Client ['+ @searchEngineClientName +'] does not exist.'
		GOTO PROC_ERROR
	END
------------------------Check if Search engine exists or not------------------------
	DECLARE @coreId INT  = ISNULL((SELECT CoreId FROM DM2SearchServerCoreInfo WITH (NOLOCK) WHERE clientid = @clientId AND cloudType = 3),0)
	IF @coreId = 0
	BEGIN
		SET @lastError = 2;
		SET @localErrorMsg = 'Error. Search Engine node ['+ @searchEngineClientName +'] does not exists.'
		GOTO PROC_ERROR
	END
BEGIN TRY
BEGIN TRAN
	------------------------Enable search engine node------------------------
	IF EXISTS ( SELECT * FROM DM2SearchServerCoreInfo WITH (NOLOCK) WHERE coreId = @coreId AND enabled = 0 AND cloudType = 3)
	BEGIN
		UPDATE DM2SearchServerCoreInfo
		SET Enabled = 1
		WHERE coreId = @coreId
		--need to restart CVD service on SE to get INDEX role back
	END
END TRY
BEGIN CATCH
	SET @lastError = @@error
	SET @localErrorMsg = (SELECT ERROR_MESSAGE())
END CATCH
IF @lastError <> 0
	ROLLBACK TRAN
ELSE
	COMMIT TRAN
PROC_ERROR:
	PRINT ''
	PRINT @scriptName + ' completed at '
					+ Convert(varchar(60), getdate())+' with parameters '
					+ 'Search Engine node ['+ @searchEngineClientName + '].'
					+ ' ErrorCode (' + Convert(varchar(2),@lastError) +').'
	if @lastError <> 0
		Raiserror(@localErrorMsg,
					15,  --Severity (> 10 to force DOS Error Code = 1)
					1	 --State
					)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_EnableSearchEngineNode')
	delete from GxQscripts where name = 'QS_EnableSearchEngineNode'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_EnableSearchEngineNode')
	delete from GXDBVersions where aliasname = 'QS_EnableSearchEngineNode'
GO

insert into GXDBVersions values(2, 'QS_EnableSearchEngineNode',  '00010002001400040000', 'QS_EnableSearchEngineNode', '00010002001400040000')
GO

insert into GxQscripts values(2,'QS_EnableSearchEngineNode',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn QS_EnableSearchEngineNode -si ''clientName''
'
 + CHAR(10) + '	script_name: QS_EnableSearchEngineNode.
'
 + CHAR(10) + '	clientName - client name of the Search Engine node to be enabled.
'
)
GO

