

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_EnableDisablePruningStatusMonitor.sp] ---------- 

SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_EnableDisablePruningStatusMonitor')
BEGIN
	print '>>> Drop Stored Procedure: QS_EnableDisablePruningStatusMonitor <<<'
	drop procedure QS_EnableDisablePruningStatusMonitor
END
IF EXISTS (select * from GxQscripts where name='QS_EnableDisablePruningStatusMonitor')
	delete from GxQscripts where name = 'QS_EnableDisablePruningStatusMonitor'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_EnableDisablePruningStatusMonitor')
	delete from GXDBVersions where aliasname = 'QS_EnableDisablePruningStatusMonitor'
GO
print '... Creating Procedure: QS_EnableDisablePruningStatusMonitor'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_EnableDisablePruningStatusMonitor
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @i_option NVARCHAR(64) =N'',
  @i_StartTime NVARCHAR(1024) =N'',
  @i_IntervalInHrs NVARCHAR(10)
AS
Set NOCOUNT ON
DECLARE @NoParameter	NVARCHAR(10)
SET     @NoParameter	=N''
DECLARE @scriptName NVARCHAR(100)
SET @scriptName = N'QS_EnableDisablePruningStatusMonitor'
DECLARE @errorCode INT
SET @errorCode = 0
DECLARE @StartUnixTime INT = 0
DECLARE @nextRunTime INT = 0
DECLARE @now int = dbo.getUnixTime(GETUTCDATE())
DECLARE @errorString NVARCHAR(1024)
-----------------------invalid parameters------------------------------
SET @i_option = LTRIM(RTRIM(@i_option))
SET @i_StartTime = LTRIM(RTRIM(@i_StartTime))
SET @i_IntervalInHrs = LTRIM(RTRIM(@i_IntervalInHrs))
IF @i_option = @NoParameter
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error: Insufficient command line parameters. Please refer to the readme file and retry with necessary parameters'
	GOTO SCRIPT_EXIT
END
------------------------------------------------------------------------
IF @i_option <> 'ENABLE' AND @i_option <> 'DISABLE'
BEGIN
	SET @errorCode = 2
	SET @errorString = 'Error. Invalid option parameter [' + @i_option + '] specified.'
	GOTO SCRIPT_EXIT
END
----------------- Enable or Disable Pruning Monitor --------------
IF @i_option = 'ENABLE'
BEGIN
SET @StartUnixTime = dbo.getUnixTime(dbo.CellLocalToUTCTime(@i_StartTime, 2))
IF @StartUnixTime < @now
BEGIN
	SET @errorCode = 3
	SET @errorString = 'Error. Invalid Start time [' + @i_StartTime + '] specified. Start time has to be future time.'
	GOTO SCRIPT_EXIT
END
SET @nextRunTime = @StartUnixTime + (@i_IntervalInHrs * 60 * 60)
UPDATE MMEntityProp
SET longlongVal = @StartUnixTime
WHERE EntityType = 14
AND propertyName = 'CollectionTime'
IF @@ROWCOUNT = 0
BEGIN
	INSERT  INTO MMEntityProp (EntityId, EntityType, propertyName, propDataType, intVal, longlongVal, stringVal, created, modified, CommCellId)
SELECT 0, 14, 'CollectionTime', 1, 0, @StartUnixTime, '', @now, @now, 2
END
UPDATE MMEntityProp
SET intVal = @i_IntervalInHrs
WHERE EntityType = 15
AND propertyName = 'CollectionTimeIntervalHours'
IF @@ROWCOUNT = 0
BEGIN
	INSERT  INTO MMEntityProp (EntityId, EntityType, propertyName, propDataType, intVal, longlongVal, stringVal, created, modified, CommCellId)
SELECT 0, 15, 'CollectionTimeIntervalHours', 1, @i_IntervalInHrs, 0, '', @now, @now, 2
END
END
ELSE IF @i_option = 'DISABLE'
BEGIN
UPDATE MMEntityProp
SET longlongVal = 0,
modified = @now
WHERE EntityType = 14
AND propertyName = 'CollectionTime'
UPDATE MMEntityProp
SET intVal = 0,
modified = @now
WHERE EntityType = 15
AND propertyName = 'CollectionTimeIntervalHours'
END
------------------------------------------------------
	SET @errorString = 'Successfully ' + lower(@i_option) +'d Pruning Monitor Feature'
	PRINT @errorString
	RETURN
SCRIPT_EXIT:
	SET @errorString = @errorString + '. Error Code [' + CAST(@errorCode AS NVARCHAR(64)) + ']'
	PRINT @errorString
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'QS_EnableDisablePruningStatusMonitor')
	delete from GxQscripts where name = 'QS_EnableDisablePruningStatusMonitor'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_EnableDisablePruningStatusMonitor')
	delete from GXDBVersions where aliasname = 'QS_EnableDisablePruningStatusMonitor'
GO

insert into GXDBVersions values(2, 'QS_EnableDisablePruningStatusMonitor',  '00000000000000000000', 'QS_EnableDisablePruningStatusMonitor', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_EnableDisablePruningStatusMonitor',  3, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn EnableDisablePruningStatusMonitor -si <ENABLE\DISABLE> -si <StartTime> -si <IntervalInHours>
'
 + CHAR(10) + '-- 	script_name: QS_EnableDisablePruningStatusMonitor'
 + CHAR(10) + '-- 	 Qscript to enable or disable Pruning Status Monitor feature on CommServer'
)
GO

