

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_EnableCIForClientsInClientGroup.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_EnableCIForClientsInClientGroup.sp,v $ $Id: QS_EnableCIForClientsInClientGroup.sp,v 1.3.60.2 2018/03/22 01:46:03 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_EnableCIForClientsInClientGroup <<<'

IF EXISTS (select * from sysobjects where name='QS_EnableCIForClientsInClientGroup')
	drop procedure QS_EnableCIForClientsInClientGroup
IF EXISTS (select * from GxQscripts where name='QS_EnableCIForClientsInClientGroup')
	delete from GxQscripts where name = 'QS_EnableCIForClientsInClientGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_EnableCIForClientsInClientGroup')
	delete from GXDBVersions where aliasname = 'QS_EnableCIForClientsInClientGroup'
GO
print '... Creating Procedure: QS_EnableCIForClientsInClientGroup'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_EnableCIForClientsInClientGroup
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- SP Input Params
  @clientGrpName nvarchar(1024)
AS
Set NOCOUNT ON
------------ Convenience Definitions    -----------
	DECLARE @scriptName	varchar(64)
	SET		@scriptName	= 'EnableCIForClientsInClientGroup'
	DECLARE @lastError	integer
	SET		@lastError	= 0
	DECLARE @localErrorMsg		varchar(512)
	SET		@localErrorMsg			='Successful.'
	DECLARE @now				integer
	SET @now = dbo.GetUnixTime(GETUTCDATE())
	DECLARE @NoParameter		varchar(4)
	SET     @NoParameter            ='%'                        -- Get Around QScript Parameter
	SET     @NoParameter            =@NoParameter + 's'         -- .. Substitution
------------------------Check if client group exists or not------------------------
	IF NOT EXISTS(SELECT * FROM APP_ClientGroup WHERE name=@clientGrpName )
	BEGIN
		SET @lastError = 2
		SET @localErrorMsg = 'Error. Client Group ['+CAST(@clientGrpName AS VARCHAR(64))+'] does not exists.'
		GOTO PROC_ERROR
	END
BEGIN TRY
BEGIN TRAN
	------------------------Enable CI option for all clients belong to the client group------------------------
	DECLARE @clientList TABLE (t_clientid INT)
	DECLARE @clientId INT
	INSERT INTO @clientList
	SELECT CGA.clientId FROM APP_ClientGroupAssoc CGA, APP_ClientGroup CG
	WHERE CG.name = @clientGrpName AND  CGA.clientGroupId = CG.id
	IF NOT EXISTS (SELECT * FROM @clientList)
	BEGIN
		SET @lastError = 3
		SET @localErrorMsg = 'Error. No clients are associated to Client Group ['+CAST(@clientGrpName AS VARCHAR(64))+'].'
		GOTO TRANS_EXIT
	END
	WHILE EXISTS (SELECT * FROM @clientList)
	BEGIN
		SET @clientId = (SELECT TOP 1 t_clientid FROM @clientList)
		IF EXISTS (SELECT * FROM APP_ClientProp WHERE attrName = 'Content Indexing Enabled' AND attrVal = '0' AND modified =0 AND componentnameid = @clientId)
			UPDATE APP_ClientProp
			SET attrVal = '1'
			WHERE componentnameid = @clientId and attrName = 'Content Indexing Enabled' AND attrVal = '0' AND modified =0
		ELSE IF NOT EXISTS (SELECT * FROM APP_ClientProp WHERE attrName = 'Content Indexing Enabled' AND attrVal = '1' AND modified =0 AND componentnameid = @clientId)
			INSERT INTO APP_ClientProp
			VALUES (@clientId, 'Content Indexing Enabled', 2, '1', @now,0,0)
		DELETE FROM @clientList WHERE t_clientid = @clientId
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @lastError = @@error
	SET @localErrorMsg = (SELECT ERROR_MESSAGE())
	goto PROC_ERROR
END CATCH
TRANS_EXIT:
IF @lastError <> 0
	ROLLBACK TRAN
ELSE
	COMMIT TRAN
PROC_ERROR:
	PRINT ''
	PRINT @scriptName + ' completed at '
					+ Convert(varchar(60), getdate())+' with parameters '
					+ 'Client Group ['+ @clientGrpName + '].'
					+ ' ErrorCode (' + Convert(varchar(2),@lastError) +').'
	if @lastError <> 0
		Raiserror(@localErrorMsg,
					15,  --Severity (> 10 to force DOS Error Code = 1)
					1	 --State
					)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_EnableCIForClientsInClientGroup')
	delete from GxQscripts where name = 'QS_EnableCIForClientsInClientGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_EnableCIForClientsInClientGroup')
	delete from GXDBVersions where aliasname = 'QS_EnableCIForClientsInClientGroup'
GO

insert into GXDBVersions values(2, 'QS_EnableCIForClientsInClientGroup',  '00010003006000020000', 'QS_EnableCIForClientsInClientGroup', '00010003006000020000')
GO

insert into GxQscripts values(2,'QS_EnableCIForClientsInClientGroup',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn EnableCIForClientsInClientGroup -si ''clientGroupName''
'
 + CHAR(10) + '	script_name: EnableCIForClientsInClientGroup.
'
 + CHAR(10) + '	clientGroupName - Enable CI option for all clients belong to the client Group name.
'
)
GO

