

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_EligibleJobsForAgingByTimeRange.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_EligibleJobsForAgingByTimeRange <<<'

IF EXISTS (select * from sysobjects where name='QS_EligibleJobsForAgingByTimeRange')
	drop procedure QS_EligibleJobsForAgingByTimeRange
IF EXISTS (select * from GxQscripts where name='QS_EligibleJobsForAgingByTimeRange')
	delete from GxQscripts where name = 'QS_EligibleJobsForAgingByTimeRange'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_EligibleJobsForAgingByTimeRange')
	delete from GXDBVersions where aliasname = 'QS_EligibleJobsForAgingByTimeRange'
GO
print '... Creating Procedure: QS_EligibleJobsForAgingByTimeRange'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_EligibleJobsForAgingByTimeRange
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @i_startDate VARCHAR(32),
  @i_endDate VARCHAR(32),
  @i_outputType INT = 1,
  @clientName VARCHAR(32) = 'Not Applicable',
  @storagePolicyName VARCHAR(32) = 'Not Applicable',
  @storagePolicyCopyName VARCHAR(32) = 'Not Applicable'
AS
SET NOCOUNT ON
IF OBJECT_ID('tempdb.dbo.#tempJobsToProcessForRetention') IS NOT NULL	DROP TABLE #tempJobsToProcessForRetention
CREATE TABLE #tempJobsToProcessForRetention (jobId INT, commCellID INT, archGrpCopyId INT, appId INT, retentionEndTime BIGINT)
IF OBJECT_ID('tempdb.dbo.#tblResultDaCalculateRetentionTimeForJobs') IS NOT NULL 	DROP TABLE #tblResultDaCalculateRetentionTimeForJobs
CREATE TABLE #tblResultDaCalculateRetentionTimeForJobs (retVal int)
DECLARE	@startUnixTime	BIGINT
DECLARE	@endUnixTime	BIGINT
DECLARE	@retVal		INT = 0
DECLARE @retCode	INT = 0
DECLARE @errorCode int
SET @errorCode = 0
DECLARE @errorString NVARCHAR(1024)
SET @errorString = ''
DECLARE @startDate	DATETIME
DECLARE @endDate 	DATETIME
DECLARE @clientId				INT = 0
DECLARE	@storagePolicyId		INT = 0
DECLARE	@storagePolicyCopyId	INT = 0
SET @startDate 	= CONVERT (DATETIME, @i_startDate,101)
SET @retVal = @@ERROR
IF  @retVal <> 0
BEGIN
	SET @errorString = 'Error when converting start date.'
	GOTO CX_EXIT
END
SET @endDate  	= CONVERT (DATETIME, @i_endDate,101)
SET @retVal = @@ERROR
IF  @retVal <> 0
BEGIN
	SET @errorString = 'Error when converting end date.'
	GOTO CX_EXIT
END
SET	@startUnixTime = dbo.GetUnixTimeBig(dbo.LocalToUTCTime(@startDate,dbo.GetClientTimeZone(2)))
SET @retVal = @@ERROR
IF  @retVal <> 0
BEGIN
	SET @errorString = 'Error when setting startUnixTime.'
	GOTO CX_EXIT
END
SET	@endDate 	=	DATEADD(DAY, DATEDIFF(DAY, 0, @endDate), '23:59:59')
SET	@endUnixTime = dbo.GetUnixTimeBig(dbo.LocalToUTCTime(@endDate,dbo.GetClientTimeZone(2)))
SET @retVal = @@ERROR
IF  @retVal <> 0
BEGIN
	SET @errorString = 'Error when setting endUnixTime.'
	GOTO CX_EXIT
END
IF @i_outputType <> 1 AND @i_outputType <> 2 AND @i_outputType <> 3
BEGIN
	SET @errorString = 'Output type not valid.'
	SET	@retVal = 1
	GOTO CX_EXIT
END
IF @startUnixTime > @endUnixTime
BEGIN
	SET @errorString = 'Start time should be greater than end time.'
	SET	@retVal = 1
	GOTO CX_EXIT
END
IF NOT EXISTS(
			SELECT	name
			FROM	APP_Client WITH (NOLOCK)
			WHERE	name = @clientName
) AND @clientName <> 'Not Applicable'
BEGIN
	SET @retVal = 2
	SET @errorString = 'Invalid Client Name.'
	GOTO CX_EXIT
END
ELSE IF @clientName <> 'Not Applicable'
BEGIN
	SELECT	@clientId = id
	FROM	App_Client WITH (NOLOCK)
	WHERE	name = @clientName
END
IF @storagePolicyName = 'Not Applicable' AND @storagePolicyCopyName <> 'Not Applicable'
BEGIN
	SET @retVal = 2
	SET @errorString = 'Invalid Input. Provide storage policy name along with copy name.'
	GOTO CX_EXIT
END
IF NOT EXISTS(
			SELECT	name
			FROM	archGroup WITH (NOLOCK)
			WHERE	name = @storagePolicyName
) AND @storagePolicyName <> 'Not Applicable'
BEGIN
	SET @retVal = 2
	SET @errorString = 'Invalid Storage Policy Name.'
	GOTO CX_EXIT
END
ELSE IF @storagePolicyName <> 'Not Applicable'
BEGIN
	SELECT	@storagePolicyId = id
	FROM	archGroup WITH (NOLOCK)
	WHERE	name = @storagePolicyName
END
IF NOT EXISTS(
			SELECT	AGC.name
			FROM	archGroup AG WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK)
			WHERE	AG.id = AGC.archGroupId
				AND	AG.name = @storagePolicyName AND AGC.name = @storagePolicyCopyName
) AND @storagePolicyName <> 'Not Applicable' AND @storagePolicyCopyName <> 'Not Applicable'
BEGIN
	SET @retVal = 2
	SET @errorString = 'Invalid Storage Policy Copy Name.'
	GOTO CX_EXIT
END
ELSE IF @storagePolicyName <> 'Not Applicable' AND @storagePolicyCopyName <> 'Not Applicable'
BEGIN
	SELECT	@storagePolicyId = AG.id , @storagePolicyCopyId = AGC.id
	FROM	archGroup AG WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK)
	WHERE	AG.id = AGC.archGroupId
		AND	AG.name = @storagePolicyName AND AGC.name = @storagePolicyCopyName
END
IF @clientId <> 0
BEGIN
	INSERT INTO #tempJobsToProcessForRetention
	SELECT	DISTINCT JDS.jobId,JDS.commCellId,JDS.archGrpCopyId,JDS.appId,0
	FROM	JMJobDataStats JDS WITH (NOLOCK), JMBkpStats JBS WITH (NOLOCK), APP_Application AAP WITH (NOLOCK)
	WHERE	JDS.jobId = JBS.jobId AND JDS.commCellId = JBS.commCellId
		AND JDS.status IN (100,102,103)
AND JDS.disabled & 256 = 0
		AND	AAP.id = JDS.appId
		AND	(@storagePolicyCopyId = JDS.archGrpCopyId OR @storagePolicyCopyId = 0)
		AND	(@storagePolicyId = JDS.archGrpId OR @storagePolicyId = 0)
		AND	@clientId = AAP.clientId
	SET @retVal = @@ERROR
	IF  @retVal <> 0 GOTO CX_EXIT
	-- Insert admin jobs.
	INSERT INTO #tempJobsToProcessForRetention
	SELECT	DISTINCT JDS.jobId,JDS.commCellId,JDS.archGrpCopyId,JDS.appId,0
	FROM	JMJobDataStats JDS WITH (NOLOCK), JMAdminJobStatsTable JBS WITH (NOLOCK), APP_Application AAP WITH (NOLOCK)
	WHERE	JDS.jobId = JBS.jobId AND JDS.commCellId = JBS.commCellId
		AND JDS.status IN (100,102,103)
AND JDS.disabled & 256 = 0
		AND	AAP.id = JDS.appId
		AND	(@storagePolicyCopyId = JDS.archGrpCopyId OR @storagePolicyCopyId = 0)
		AND	(@storagePolicyId = JDS.archGrpId OR @storagePolicyId = 0)
		AND	@clientId = AAP.clientId
	SET @retVal = @@ERROR
	IF  @retVal <> 0 GOTO CX_EXIT
END
EXEC @retVal = daCalculateRetentionTimeForJobs  @storagePolicyCopyId,@storagePolicyId , 0
IF  @retVal <> 0
BEGIN
	SET @errorString = 'Error when executing daCalculateRetentionTimeForJobs stored proc.'
	GOTO CX_EXIT
END
DELETE	FROM  #tempJobsToProcessForRetention
WHERE	retentionEndTime NOT BETWEEN @startUnixTime AND @endUnixTime
SET @retVal = @@ERROR
IF  @retVal <> 0
BEGIN
	SET @errorString = 'Failed to delete entries from the temp table.'
	GOTO CX_EXIT
END
PRINT 'Selected Time Range ' + @i_startDate + ' to ' + @i_endDate
PRINT ''
IF @clientName <> 'Not Applicable'
BEGIN
	PRINT 'Client Name : ' + @clientName
	PRINT ''
END
IF @storagePolicyName <> 'Not Applicable'
BEGIN
	PRINT 'Storage Policy Name : ' + @storagePolicyName
	PRINT ''
END
IF @storagePolicyCopyName <> 'Not Applicable'
BEGIN
	PRINT 'Storage Policy Copy Name : ' + @storagePolicyCopyName
	PRINT ''
END
IF 	@i_outputType = 1
BEGIN
	SELECT	DISTINCT J.jobId												AS	[Job ID],
			AC.name															AS 	[Client Name],
			AIT.displayName													AS	[App Type],
			ABSN.name														AS	[Backupset Name],
			AAP.subclientName												AS	[Subclient Name],
			AG.name															AS	[Storage Policy Name],
			AGC.name														AS	[Storage Policy Copy Name],
			dbo.UTCToCellLocalTime( dbo.GetDateTimeBig(retentionEndTime),2)	AS	[Retention End Time]
	FROM	#tempJobsToProcessForRetention J,APP_Application AAP WITH (NOLOCK), APP_Client AC WITH (NOLOCK), APP_BackupSetName ABSN WITH (NOLOCK),APP_iDAType AIT WITH (NOLOCK), archGroup AG WITH (NOLOCK),archGroupCopy AGC WITH (NOLOCK)
	WHERE	J.appId = AAP.id
		AND	AAP.clientId = AC.id
		AND	ABSN.id = AAP.backupSet
		AND	AIT.type = AAP.appTypeId
		AND	AGC.id = J.archGrpCopyId
		AND	AGC.archGroupId = AG.id
	ORDER BY J.jobId, AC.name, AIT.displayName, ABSN.name, AAP.subclientName, AG.name, AGC.name
END
ELSE IF @i_outputType = 2
BEGIN
	SELECT	AC.name					AS 	[Client Name],
			AIT.displayName			AS	[App Type],
			ABSN.name				AS	[Backupset Name],
			AAP.subclientName		AS	[Subclient Name],
			COUNT(DISTINCT jobId)	AS [Job Count]
	FROM	#tempJobsToProcessForRetention J,APP_Application AAP WITH (NOLOCK), APP_Client AC WITH (NOLOCK), APP_BackupSetName ABSN WITH (NOLOCK),APP_iDAType AIT WITH (NOLOCK)
	WHERE	J.appId = AAP.id
		AND	AAP.clientId = AC.id
		AND	ABSN.id = AAP.backupSet
		AND	AIT.type = AAP.appTypeId
	GROUP BY AC.name, AIT.displayName, ABSN.name, AAP.subclientName
	ORDER BY AC.name, AIT.displayName, ABSN.name, AAP.subclientName
END
ELSE IF @i_outputType = 3
BEGIN
	SELECT	CAST(J.jobId AS NVARCHAR(30))									+ ',' +
			AC.name															+ ',' +
			AIT.displayName													+ ',' +
			ABSN.name														+ ',' +
			AAP.subclientName												+ ',' +
			AG.name															+ ',' +
			AGC.name														+ ',' +
			CAST(dbo.UTCToCellLocalTime( dbo.GetDateTimeBig(retentionEndTime),2) AS NVARCHAR(40))	 AS [JobID,ClientName,AppType,BackupsetName,SubclientName,StoragePolicyName,StoragePolicyCopyName,RetentionEndTime]
	FROM	#tempJobsToProcessForRetention J,APP_Application AAP WITH (NOLOCK), APP_Client AC WITH (NOLOCK), APP_BackupSetName ABSN WITH (NOLOCK),APP_iDAType AIT WITH (NOLOCK), archGroup AG WITH (NOLOCK),archGroupCopy AGC WITH (NOLOCK)
	WHERE	J.appId = AAP.id
		AND	AAP.clientId = AC.id
		AND	ABSN.id = AAP.backupSet
		AND	AIT.type = AAP.appTypeId
		AND	AGC.id = J.archGrpCopyId
		AND	AGC.archGroupId = AG.id
	ORDER BY J.jobId, AC.name, AIT.displayName, ABSN.name, AAP.subclientName, AG.name, AGC.name
END
CX_EXIT:
IF OBJECT_ID('tempdb.dbo.#tempJobsToProcessForRetention') IS NOT NULL	DROP TABLE #tempJobsToProcessForRetention
IF OBJECT_ID('tempdb.dbo.#tblResultDaCalculateRetentionTimeForJobs') IS NOT NULL 	DROP TABLE #tblResultDaCalculateRetentionTimeForJobs
IF @retVal <> 0
	PRINT 'Error Code : ' + CAST(@retVal AS VARCHAR(2)) + ' Error String : ' + @errorString
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'QS_EligibleJobsForAgingByTimeRange')
	delete from GxQscripts where name = 'QS_EligibleJobsForAgingByTimeRange'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_EligibleJobsForAgingByTimeRange')
	delete from GXDBVersions where aliasname = 'QS_EligibleJobsForAgingByTimeRange'
GO

insert into GXDBVersions values(2, 'QS_EligibleJobsForAgingByTimeRange',  '00000000000000000000', 'QS_EligibleJobsForAgingByTimeRange', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_EligibleJobsForAgingByTimeRange',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '--       qoperation execscript -sn QS_EligibleJobsForAgingByTimeRange -si startTime -si endTime [-si outputType -si @clientName = ''Client Name'' -si @storagePolicyName = ''Storage Policy Name'' -si @storagePolicyCopyName = ''Storage Policy Copy Name'']'
 + CHAR(10) + '-- 		Example :'
 + CHAR(10) + '-- 		qoperation execscript -sn QS_EligibleJobsForAgingByTimeRange -si ''2015/12/24'' -si ''2016/03/13'' -si 1 '
 + CHAR(10) + '-- 		qoperation execscript -sn QS_EligibleJobsForAgingByTimeRange -si ''2015/12/24'' -si ''2016/03/13'' -si 1  -si @clientName = ''Client Name'''
 + CHAR(10) + '-- 		qoperation execscript -sn QS_EligibleJobsForAgingByTimeRange -si ''2015/12/24'' -si ''2016/03/13'' -si 1  -si @storagePolicyName = ''Storage Policy Name'''
 + CHAR(10) + '-- 		qoperation execscript -sn QS_EligibleJobsForAgingByTimeRange -si ''2015/12/24'' -si ''2016/03/13'' -si 2  -si @storagePolicyName = ''Storage Policy Name'' -si @storagePolicyCopyName = ''Storage Policy Copy Name'''
 + CHAR(10) + '-- 		qoperation execscript -sn QS_EligibleJobsForAgingByTimeRange -si ''2015/12/24'' -si ''2016/03/13'' -si 3  -si @clientName = ''Client Name''  -si @storagePolicyName = ''Storage Policy Name'' -si @storagePolicyCopyName = ''Storage Policy Copy Name'''
)
GO

