

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_DiskLibMigration.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2016  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_DiskLibMigration.sp,v $ $Id: QS_DiskLibMigration.sp,v 1.1.2.8 2020/08/27 18:13:34 pveeravalli Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_DiskLibMigration')
BEGIN
	print '>>> Drop Stored Procedure: QS_DiskLibMigration <<<'
	drop procedure QS_DiskLibMigration
END
IF EXISTS (select * from GxQscripts where name='QS_DiskLibMigration')
	delete from GxQscripts where name = 'QS_DiskLibMigration'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_DiskLibMigration')
	delete from GXDBVersions where aliasname = 'QS_DiskLibMigration'
GO
print '... Creating Procedure: QS_DiskLibMigration'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_DiskLibMigration
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- Stored Procedure Inputs
  @i_libraryAlias NVARCHAR(1024) = N'',
  @i_deviceType NVARCHAR(1024) = N''
AS
Set NOCOUNT ON
/*Locale variables*/
DECLARE @l_errorMessage   NVARCHAR(MAX) = N''
DECLARE @l_errorNumber INTEGER = 0
DECLARE @l_deviceTypeValue   INTEGER = 0
DECLARE @l_libraryId INTEGER = 0
DECLARE @licenseMissingMAs NVARCHAR(MAX)
IF NULLIF(@i_libraryAlias,'') IS NULL OR NULLIF(@i_deviceType,'') IS NULL
BEGIN
	SET @l_errorMessage = N'Arguments missing.'
	SET @l_errorNumber = 1
	GOTO PROC_ERROR
END
/**********Check library name**********/
SELECT @l_libraryId = LibraryId FROM MMLibrary(NOLOCK) WHERE AliasName = @i_libraryAlias
IF @l_libraryId = 0
BEGIN
	SET @l_errorMessage = N'Unidentified Library [' + @i_libraryAlias + '].'
	SET @l_errorNumber = 1
	GOTO PROC_ERROR
END
/**********Check device type**********/
IF ISNUMERIC(@i_deviceType) = 1
	SET @l_deviceTypeValue = CONVERT(INTEGER, @i_deviceType)
ELSE
BEGIN
	SET @l_deviceTypeValue =
		CASE  	@i_deviceType
WHEN	'AliCloud Object Storage Service'		THEN	23
WHEN	'Amazon S3'								THEN	2
WHEN	'AT&T Synaptic'							THEN	10
WHEN	'China Mobile oNest'					THEN	16
WHEN	'EMC Atmos'								THEN	9
WHEN	'Google Cloud Storage'					THEN	19
WHEN	'HDS HCP'								THEN	12
WHEN	'HGST Storage'							THEN	15
WHEN	'Microsoft Azure Storage'				THEN	3
WHEN	'OpenStack Object Storage'				THEN	14
WHEN	'Oracle Storage Cloud Service'			THEN	21
WHEN	'Oracle Storage Cloud Archive Service'	THEN	22
WHEN	'Rackspace Cloud Files'					THEN	5
WHEN	'VMWare Cloud Storage'					THEN	20
		ELSE	0
		END
END
IF 	@l_deviceTypeValue = 0
BEGIN
	SET @l_errorMessage = N'Unidentified Device Type [' + @i_deviceType + '].'
	SET @l_errorNumber = 1
	GOTO PROC_ERROR
END
SELECT	@licenseMissingMAs = COALESCE(@licenseMissingMAs + ', ', '') + DATA.displayName
FROM
(SELECT	DISTINCT  AC.displayName
FROM 	MMMountPath(NOLOCK) MP
JOIN 	MMMountPathToStorageDevice(NOLOCK) MSD ON MSD.MountPathId = MP.MountPathId
JOIN 	MMDeviceController(NOLOCK) MD ON MD.DeviceId = MSD.DeviceId
JOIN 	APP_Client(NOLOCK) AC ON AC.id = MD.ClientId
LEFT JOIN LicUsage(NOLOCK) LIC ON LIC.CId = AC.id
					AND LIC.LicType = 190
					AND OpType = 'Install'
WHERE 	MP.LibraryId = @l_libraryId
AND 	LIC.name IS NULL
) DATA
IF	@licenseMissingMAs IS NOT NULL
BEGIN
	SET @l_errorMessage = N'Cloud Storage License detected to be not consumed for the following MediaAgents to which the Library will be attached - [' + @licenseMissingMAs + '].'
	SET @l_errorNumber = 1
	GOTO PROC_ERROR
END
UPDATE	MP
SET		MountPathTypeId = 7, -- MOUNT_PATH_EXTERNAL_REMOTE_HOST
		MaxConcurrentWriters = 0
FROM	MMMountPath(NOLOCK) MP
WHERE	MP.LibraryId = @l_libraryId
IF @@ERROR <> 0
BEGIN
	SET @l_errorMessage = N'Error updating mount path type'
	SET @l_errorNumber = 1
	GOTO PROC_ERROR
END
UPDATE	D
SET     DeviceTypeId = (CASE @l_deviceTypeValue WHEN 400 THEN 3
                          ELSE @l_deviceTypeValue END),
        DisplayDeviceTypeId = @l_deviceTypeValue
FROM	MMDevice(NOLOCK) D
JOIN	MMMountPathToStorageDevice(NOLOCK) PSD ON PSD.DeviceId = D.DeviceId
JOIN	MMMountPath(NOLOCK) MP ON MP.MountPathId = PSD.MountPathId
WHERE	MP.LibraryId = @l_libraryId
AND		D.DeviceTypeId = 1
IF @@ERROR <> 0
BEGIN
	SET @l_errorMessage = N'Error updating device type'
	SET @l_errorNumber = 1
	GOTO PROC_ERROR
END
UPDATE	AFC
SET		AFC.flags = (AFC.flags | 512)
FROM    archFileCopy(NOLOCK) AFC
JOIN    archchunkmapping(NOLOCK) ACM ON ACM.archFileId = AFC.archFileId
                                        AND ACM.archCopyId = AFC.archCopyId
                                       AND ACM.commCellId = AFC.commCellId
JOIN    archChunk(NOLOCK) AC ON AC.id = ACM.archChunkId
                            AND AC.commCellId = ACM.chunkCommCellId
JOIN    MMVolume(NOLOCK) V ON V.VolumeId = AC.volumeId
JOIN    MMMedia(NOLOCK) M ON M.MediaId = V.MediaId
JOIN 	archCopySIDBStore(NOLOCK) S ON AFC.archCopyId = S.CopyId
WHERE   M.LibraryId = @l_libraryId
AND 	S.SIDBStoreId > 0
IF @@ERROR <> 0
BEGIN
	SET @l_errorMessage = N'Error updating webstorage flag'
	SET @l_errorNumber = 1
	GOTO PROC_ERROR
END
GOTO PROC_EXIT
PROC_ERROR:
if @l_errorNumber <> 0
	Raiserror(@l_errorMessage,
                15,  --Severity (> 10 to force DOS Error Code = 1)
                1    --State)
			)
PROC_EXIT:
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_DiskLibMigration')
	delete from GxQscripts where name = 'QS_DiskLibMigration'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_DiskLibMigration')
	delete from GXDBVersions where aliasname = 'QS_DiskLibMigration'
GO

insert into GXDBVersions values(2, 'QS_DiskLibMigration',  '00010001000200080000', 'QS_DiskLibMigration', '00010001000200080000')
GO

insert into GxQscripts values(2,'QS_DiskLibMigration',  2, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 		qoperation execscript -sn DiskLibMigration -si <LIBRARY_ALIAS_NAME> -si <DEVICE_TYPE>'
 + CHAR(10) + '-- 		Example: qoperation execscript -sn DiskLibMigration -si ''Lib'' -si ''Amazon S3'''
 + CHAR(10) + '-- 		'
 + CHAR(10) + '-- 		Device IDs can also be provided directly instead of the Device Type Name. But the latter is recommended.'
 + CHAR(10) + '-- 	'
 + CHAR(10) + '-- 		Device Types:'
 + CHAR(10) + '-- 		------------'
 + CHAR(10) + '-- 		AliCloud Object Storage Service'
 + CHAR(10) + '-- 		Amazon S3'
 + CHAR(10) + '-- 		AT&T Synaptic'
 + CHAR(10) + '-- 		China Mobile oNest'
 + CHAR(10) + '-- 		EMC Atmos'
 + CHAR(10) + '-- 		Google Cloud Storage'
 + CHAR(10) + '-- 		HDS HCP'
 + CHAR(10) + '-- 		HGST Storage'
 + CHAR(10) + '-- 		Microsoft Azure Storage'
 + CHAR(10) + '-- 		OpenStack Object Storage'
 + CHAR(10) + '-- 		Oracle Storage Cloud Service'
 + CHAR(10) + '-- 		Oracle Storage Cloud Archive Service'
 + CHAR(10) + '-- 		Rackspace Cloud Files'
 + CHAR(10) + '-- 		VMWare Cloud Storage'
)
GO

