

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_DisableSearchEngineNode.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_DisableSearchEngineNode.sp,v $ $Id: QS_DisableSearchEngineNode.sp,v 1.5.44.4 2018/03/22 01:42:14 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_DisableSearchEngineNode <<<'

IF EXISTS (select * from sysobjects where name='QS_DisableSearchEngineNode')
	drop procedure QS_DisableSearchEngineNode
IF EXISTS (select * from GxQscripts where name='QS_DisableSearchEngineNode')
	delete from GxQscripts where name = 'QS_DisableSearchEngineNode'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_DisableSearchEngineNode')
	delete from GXDBVersions where aliasname = 'QS_DisableSearchEngineNode'
GO
print '... Creating Procedure: QS_DisableSearchEngineNode'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_DisableSearchEngineNode
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- SP Input Params
  @searchEngineClientName nvarchar(1024)
AS
Set NOCOUNT ON
------------ Convenience Definitions    -----------
	DECLARE @scriptName	varchar(32)
	SET		@scriptName	= 'DisableSearchEngineNode'
	DECLARE @lastError	integer
	SET		@lastError	= 0
	DECLARE @localErrorMsg	varchar(512)
	SET		@localErrorMsg	='Error Encountered when running script.'
	DECLARE @now				integer
	DECLARE @userId				integer
	SET @now = dbo.GetUnixTime(GETDATE())
	SET @userId	 = 1	-- Until we find a way to fetch from Qcommand!
-----------------------validate parameters------------------------------
	DECLARE @clientId integer
	SET @clientId = ISNULL((SELECT id FROM APP_Client (NOLOCK) WHERE name = @searchEngineClientName), 0)
	IF @clientId = 0
	BEGIN
		SET @lastError = 1
		SET @localErrorMsg = 'Error. Client ['+ @searchEngineClientName +'] does not exist.'
		GOTO PROC_ERROR
	END
------------------------Check if Search engine exists or not------------------------
	DECLARE @coreId INT  = ISNULL((SELECT CoreId FROM DM2SearchServerCoreInfo (NOLOCK) WHERE clientid = @clientId AND cloudType =3),0)
	IF @coreId = 0
	BEGIN
		SET @lastError = 2;
		SET @localErrorMsg = 'Error. Search Engine node ['+ @searchEngineClientName +'] does not exists.'
		GOTO PROC_ERROR
	END
BEGIN TRY
BEGIN TRAN
	------------------------disable search engine node------------------------
	IF EXISTS ( SELECT 1 FROM DM2SearchServerCoreInfo (NOLOCK) WHERE coreId = @coreId AND enabled = 1 AND cloudType =3)
	BEGIN
		-- mark node as READ ONLY (remove INDEX role)
		UPDATE DM2SearchServerCoreInfo
		SET Enabled = 0,
CoreRoles = CoreRoles & (~16)
		WHERE coreId = @coreId
		UPDATE APP_ComponentProp
SET longVal = longVal & (~16)
		WHERE propertyTypeId = 1009 AND  modified = 0 AND
			componentId = (SELECT id FROM APP_ComponentProp
							WHERE propertyTypeId = 1008 and longVal = @clientId AND modified = 0)
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @lastError = @@error
	SET @localErrorMsg = (SELECT ERROR_MESSAGE())
END CATCH
IF @lastError <> 0
	ROLLBACK TRAN
ELSE
	COMMIT TRAN
PROC_ERROR:
	PRINT ''
	PRINT @scriptName + ' completed at '
					+ Convert(varchar(60), getdate())+' with parameters '
					+ 'Search Engine node ['+ @searchEngineClientName + '].'
					+ ' ErrorCode (' + Convert(varchar(2),@lastError) +').'
	if @lastError <> 0
		Raiserror(@localErrorMsg,
					15,  --Severity (> 10 to force DOS Error Code = 1)
					1	 --State
					)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_DisableSearchEngineNode')
	delete from GxQscripts where name = 'QS_DisableSearchEngineNode'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_DisableSearchEngineNode')
	delete from GXDBVersions where aliasname = 'QS_DisableSearchEngineNode'
GO

insert into GXDBVersions values(2, 'QS_DisableSearchEngineNode',  '00010005004400040000', 'QS_DisableSearchEngineNode', '00010005004400040000')
GO

insert into GxQscripts values(2,'QS_DisableSearchEngineNode',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn DisableSearchEngineNode -si ''clientName''
'
 + CHAR(10) + '	script_name: DisableSearchEngineNode.
'
 + CHAR(10) + '	clientName - client name of the Search Engine node to be disabled.
'
)
GO

