

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_DisableQuickRunTools.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_DisableQuickRunTools.sp,v $ $Id: QS_DisableQuickRunTools.sp,v 1.1.2.4 2018/03/22 01:15:56 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_DisableQuickRunTools <<<'

IF EXISTS (select * from sysobjects where name='QS_DisableQuickRunTools')
	drop procedure QS_DisableQuickRunTools
IF EXISTS (select * from GxQscripts where name='QS_DisableQuickRunTools')
	delete from GxQscripts where name = 'QS_DisableQuickRunTools'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_DisableQuickRunTools')
	delete from GXDBVersions where aliasname = 'QS_DisableQuickRunTools'
GO
print '... Creating Procedure: QS_DisableQuickRunTools'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_DisableQuickRunTools
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
AS
BEGIN
	SET NOCOUNT ON
	-- if trigger exist drop it.  Cannot update configuration if it is inplace.
	-- Remove the check / drop for the old SP in a future modification.
	IF EXISTS (SELECT 1 FROM sys.sysobjects where id = object_id(N'[dbo].[APP_AdvanceSettings_allowToolsToExecuteOnServerOrClient]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
	BEGIN
		DROP TRIGGER [dbo].[APP_AdvanceSettings_allowToolsToExecuteOnServerOrClient]
	END
	IF EXISTS (SELECT 1 FROM sys.sysobjects where id = object_id(N'[dbo].[APP_AdvanceSettings_allowToolsToExecuteOnServerOrClient_CUSTOMOBJ]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
	BEGIN
		DROP TRIGGER [dbo].[APP_AdvanceSettings_allowToolsToExecuteOnServerOrClient_CUSTOMOBJ]
	END
	DECLARE @nowTime	INT =  DATEDIFF(second, '01/01/1970', GETUTCDATE())
	IF EXISTS (SELECT 1 FROM APP_AdvanceSettings WHERE entityId = 2 AND entityType = 3 AND keyName = N'allowToolsToExecuteOnServerOrClient')
	BEGIN
		DELETE APP_AdvanceSettings
		WHERE
			entityId = 2
			AND entityType = 3
			AND keyName = N'allowToolsToExecuteOnServerOrClient'
	END
	INSERT INTO APP_AdvanceSettings([entityId],[keyName],[type],[relativePath],[value],[enabled],[deleted],[entityType],[sourceId],[sourceEntityType])
		VALUES (2, N'allowToolsToExecuteOnServerOrClient', N'INTEGER', N'EventManager', N'8', 1, 0, 3, 0, 0)
	INSERT INTO APP_WorkQueueRequest([clientId],[remoteClient],[workToken],[workTokenParams],[createTime],[lastUpdateTime],[retryCount],[flag])
		VALUES (2, -1, 6, N'', @nowTime, 0, 0, 0)
	DECLARE @cmd	NVARCHAR(MAX) = N'
		CREATE TRIGGER APP_AdvanceSettings_allowToolsToExecuteOnServerOrClient_CUSTOMOBJ
		ON APP_AdvanceSettings
		AFTER INSERT, UPDATE, DELETE
		AS
		BEGIN
			SET NOCOUNT ON
			DECLARE @foundIt INT = 0
			-- Inserted / updated allowToolsToExecuteOnServerOrClient row
			SELECT TOP 1
				@foundIt = 1
			FROM INSERTED i
			WHERE
				i.entityId = 2
				AND i.entityType = 3
				AND i.keyName = N''allowToolsToExecuteOnServerOrClient''
				--AND CAST(i.value AS NVARCHAR(12)) <> N''8''	-- ntext column not allowed to use in trigger
			IF (@foundIt = 0)
			BEGIN
				-- deleted allowToolsToExecuteOnServerOrClient row
				SELECT TOP 1
					@foundIt = 1
				FROM DELETED d
				WHERE
					d.entityId = 2
					AND d.entityType = 3
					AND d.keyName = N''allowToolsToExecuteOnServerOrClient''
					--AND CAST(d.value AS NVARCHAR(12)) = N''8''	-- ntext column not allowed to use in trigger
			END
			-- Someone is trying to change
			IF (@foundIt = 1)
			BEGIN
				-- generate error to cause failure for tyring to change allowToolsToExecuteOnServerOrClient
				DECLARE @pgm	NVARCHAR(255) = ''''
				DECLARE @ntUser	NVARCHAR(255) = ''''
				DECLARE @lname	NVARCHAR(255) = ''''
				SELECT
					@pgm = ISNULL(RTRIM(p.program_name), ''?''),
					@ntUser = ISNULL(RTRIM(p.nt_username), ''?''),
					@lname = ISNULL(RTRIM(p.loginame), ''?'')
				FROM sys.sysprocesses p with (nolock)
				WHERE spid = @@SPID
				DECLARE	@currentTime DATETIME = GetUTCDate()
				DECLARE @msg VARCHAR(2048) = ''Error: Modifying allowToolsToExecuteOnServerOrClient is NOT allowed in the CommServ..APP_AdvanceSettings Table! DateTime[''
					+ CAST(@currentTime AS VARCHAR(50)) + ''] Hostname['' + ISNULL(HOST_NAME(), ''?'') + ''] User['' + @lname + ''] SPID['' + CAST(@@SPID AS VARCHAR(12)) + ''] Program['' + @pgm + ''] NTUser['' + @ntUser + '']''
				-- raise error and log it to the SQL Server log file as well
				RAISERROR(@msg, 18, 255) WITH LOG, SETERROR
				ROLLBACK TRANSACTION
			END
		END
'
	-- Install the trigger
	EXEC(@cmd)
END
GO

IF EXISTS (select * from GxQscripts where name = 'QS_DisableQuickRunTools')
	delete from GxQscripts where name = 'QS_DisableQuickRunTools'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_DisableQuickRunTools')
	delete from GXDBVersions where aliasname = 'QS_DisableQuickRunTools'
GO

insert into GXDBVersions values(2, 'QS_DisableQuickRunTools',  '00010001000200040000', 'QS_DisableQuickRunTools', '00010001000200040000')
GO

insert into GxQscripts values(2,'QS_DisableQuickRunTools',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn DisableQuickRunTools.sql
'
 + CHAR(10) + '-- 	script_name: DisableQuickRunTools'
 + CHAR(10) + '-- 	 Qscript to Disable Quick Run Tools on the CommCell, CommServer, and Clients.  Once disabled, can only re-enable manually via SQL Administrator.'
)
GO

