

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_DisablePreviousJobsOnNewFull.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_DisablePreviousJobsOnNewFull.sp,v $ $Id: QS_DisablePreviousJobsOnNewFull.sp,v 1.3.14.2 2018/03/20 19:44:44 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	|			Stored Procedure: "QS_DisablePreviousJobsOnNewFull"							|
--	|																		|
--	|-------------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_DisablePreviousJobsOnNewFull <<<'

IF EXISTS (select * from sysobjects where name='QS_DisablePreviousJobsOnNewFull')
	drop procedure QS_DisablePreviousJobsOnNewFull
IF EXISTS (select * from GxQscripts where name='QS_DisablePreviousJobsOnNewFull')
	delete from GxQscripts where name = 'QS_DisablePreviousJobsOnNewFull'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_DisablePreviousJobsOnNewFull')
	delete from GXDBVersions where aliasname = 'QS_DisablePreviousJobsOnNewFull'
GO
print '... Creating Procedure: QS_DisablePreviousJobsOnNewFull'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_DisablePreviousJobsOnNewFull
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @i_SPName nvarchar(max),
  @i_CopyName nvarchar(max),
  @i_Set integer = 0
AS
 set nocount on
DECLARE @ErrorNumber INTEGER
DECLARE @ErrorMessage NVARCHAR(MAX)
DECLARE	@SPId INTEGER = 0
DECLARE	@DestCopyId INTEGER = 0
DECLARE	@modifyTime INTEGER = dbo.GetUnixTime(GetUTCDate())
BEGIN TRY
SELECT @SPId = id from ARCHGROUP WHERE NAME = @i_SPName
IF @SPId = 0
BEGIN
	SET @ErrorNumber = 1
	SET @ErrorMessage = N'Invalid Storage policy name'
	GOTO SCRIPT_EXIT
END
SELECT @DestCopyId = id from ARCHGROUPCOPY WHERE NAME = @i_CopyName AND archgroupid = @SPId and isActive = 1
IF @DestCopyId = 0
BEGIN
	SET @ErrorNumber = 2
	SET @ErrorMessage = N'Invalid Storage policy copy name'
	GOTO SCRIPT_EXIT
END
--This is supported only for SELECTIVE COPY with manual job selection
IF NOT EXISTS (SELECT 1 FROM archSelectiveCopy WHERE CopyId = @DestCopyId AND type = 8)
BEGIN
	SET @ErrorNumber = 3
	SET @ErrorMessage = N'This operation is supported only for selective copy with do not automatically select.'
	GOTO SCRIPT_EXIT
END
IF (@i_Set NOT IN (0, 1))
BEGIN
		PRINT 'Invalid Set option, 0 - to unset, 1 - to set'
		SET @ErrorNumber = 4
		SET @ErrorMessage = N'Invalid Set option, 0 - to unset, 1 - to set'
		GOTO SCRIPT_EXIT
END
IF EXISTS (SELECT 1 FROM MMEntityProp where EntityId = @DestCopyId and propertyName = 'DisablePreviousJobsOnNewFull' and EntityType = 2)
BEGIN
	UPDATE MMEntityProp SET intVal = @i_Set, modified = @modifyTime
	WHERE EntityId = @DestCopyId AND EntityType = 2 AND propertyName = 'DisablePreviousJobsOnNewFull' AND propDataType = 1 AND CommCellId = 2
END
ELSE
BEGIN
	INSERT INTO MMEntityProp (EntityId, EntityType, propertyName, propDataType, intVal, longlongVal, stringVal, created, modified, CommCellId)
	VALUES (@DestCopyId, 2, 'DisablePreviousJobsOnNewFull', 1,  @i_Set,  0, '', @modifyTime, @modifyTime, 2)
END
IF @@ERROR <> 0
BEGIN
	SELECT @ErrorNumber = ERROR_NUMBER(), @ErrorMessage = ERROR_MESSAGE()
	GOTO SCRIPT_EXIT
END
END TRY
BEGIN CATCH
	SELECT @ErrorNumber = ERROR_NUMBER(), @ErrorMessage = ERROR_MESSAGE();
END CATCH;
SCRIPT_EXIT:
IF @ErrorNumber <> 0
	Raiserror(@ErrorMessage,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
ELSE
	PRINT 'Successfully added entry'
GO

IF EXISTS (select * from GxQscripts where name = 'QS_DisablePreviousJobsOnNewFull')
	delete from GxQscripts where name = 'QS_DisablePreviousJobsOnNewFull'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_DisablePreviousJobsOnNewFull')
	delete from GXDBVersions where aliasname = 'QS_DisablePreviousJobsOnNewFull'
GO

insert into GXDBVersions values(2, 'QS_DisablePreviousJobsOnNewFull',  '00010003001400020000', 'QS_DisablePreviousJobsOnNewFull', '00010003001400020000')
GO

insert into GxQscripts values(2,'QS_DisablePreviousJobsOnNewFull',  3, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn QS_DisablePreviousJobsOnNewFull -si @i_SPName = ''SPName'' -si @i_CopyName=''CopyName''  -si @i_Set = ''0/1''
'
 + CHAR(10) + '-- 	script_name: QS_DisablePreviousJobsOnNewFull.'
 + CHAR(10) + '-- 	Mark previous cycle jobs as do not copy when most recent full job option is selected during auxcopy job'
)
GO

