

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_DisablePhysicalPruningOnLibraryList.sp] ---------- 

/* ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
--Updated for checkin
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_DisablePhysicalPruningOnLibraryList')
BEGIN
	print '>>> Drop Stored Procedure: QS_DisablePhysicalPruningOnLibraryList <<<'
	drop procedure QS_DisablePhysicalPruningOnLibraryList
END
IF EXISTS (select * from GxQscripts where name='QS_DisablePhysicalPruningOnLibraryList')
	delete from GxQscripts where name = 'QS_DisablePhysicalPruningOnLibraryList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_DisablePhysicalPruningOnLibraryList')
	delete from GXDBVersions where aliasname = 'QS_DisablePhysicalPruningOnLibraryList'
GO
print '... Creating Procedure: QS_DisablePhysicalPruningOnLibraryList'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_DisablePhysicalPruningOnLibraryList
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- Stored Procedure Inputs
  @PARAM1 varchar(1024) = ''
AS
Set NOCOUNT ON
---------------Input variables---------------------
 DECLARE @i_filePath VARCHAR(1024)
------------ Convenience Definitions    -----------
DECLARE @scriptName	varchar(32)
SET		@scriptName	= 'DisablePhysicalPruningOnLibraryList'
DECLARE @lastError	integer
SET		@lastError	= 0
DECLARE @localErrorMsg	varchar(512)
SET		@localErrorMsg	='Error Encountered when running script.'
DECLARE @NoParameter			varchar(10)
SET     @NoParameter			=''
DECLARE @SQLString 		NVARCHAR(MAX) = N''
DECLARE @InvlidNames	NVARCHAR(MAX) = N''
BEGIN TRY
BEGIN TRAN
	IF(@PARAM1 = @NoParameter) --Requires both clientName and destination cs host name
	BEGIN
		SELECT usage FROM GxQscripts
		WHERE name = 'QS_DisablePhysicalPruningOnLibraryList'
		SET @localErrorMsg = 'Error: Insufficient command line parameters'
		SET @lastError = 1
		GOTO SCRIPT_EXIT
	END
	SET @i_filePath = @PARAM1
	IF OBJECT_ID('tempdb..#LibraryList') IS NOT NULL
        DROP TABLE #LibraryList
	CREATE TABLE #LibraryList(LibName VARCHAR(1024))
	SET @SQLString= 'BULK INSERT #LibraryList FROM '''+ @i_filePath + ''' WITH (ROWTERMINATOR = ''\n'')'
	EXEC sp_executesql @SQLString
	IF @@ERROR > 0
	BEGIN
		SET @localErrorMsg = N'ERROR: Please check whether file path is valid -- bulk insert error.'
		SET @lastError = 1
		GOTO SCRIPT_EXIT
	END
	--Validate library names
	IF EXISTS(	SELECT 1 FROM #LibraryList A
				LEFT OUTER JOIN MMLibrary B ON A.LibName = B.AliasName
				WHERE B.AliasName IS NULL )
	BEGIN
		SELECT  @InvlidNames = @InvlidNames + A.LibName + + ', '
		FROM	#LibraryList A
				LEFT OUTER JOIN MMLibrary B ON A.LibName = B.AliasName
		WHERE B.AliasName IS NULL
		SET @localErrorMsg	=	'Error: There are some invalid library names ['+ @InvlidNames +'] exists, please delete them from the input first then try again the operation.'
		SET	@lastError		=	1
		GOTO SCRIPT_EXIT
	END
	UPDATE MMDeviceController
	SET DeviceAccessible = 0,
		DeviceAccessType = 0,
		DeviceControllerActive = 0,
		DeviceControllerEnabled = 0,
		UserName = '',
		UserPassword = '',
		CredentialAssocId = 0,
		Folder = ''
	FROM #LibraryList TL
		INNER JOIN MMLibrary L ON TL.LibName = L.AliasName
		INNER JOIN MMMountPath MP ON L.LibraryId = MP.LibraryId
		INNER JOIN MMMountPathToStorageDevice SD ON SD.MountPathId = MP.MountPathId
		INNER JOIN MMDeviceController DC ON DC.DeviceId = SD.DeviceId
	IF @@ERROR > 0
	BEGIN
		SET @localErrorMsg = N'ERROR: Failed to update the device controller.'
		SET @lastError = 1
		GOTO SCRIPT_EXIT
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @lastError = @@ERROR
	SET @localErrorMsg = ISNULL(ERROR_MESSAGE(), 'UNKNOWN ERROR')
	goto SCRIPT_EXIT
END CATCH
SCRIPT_EXIT:
	IF @lastError <> 0
	BEGIN
		ROLLBACK TRAN
		Raiserror(@localErrorMsg,
						15,  --Severity (> 10 to force DOS Error Code = 1)
						1	 --State
						)
	END
	ELSE
	BEGIN
		COMMIT TRAN
		SELECT 'Successfully disabled the physical pruning for all the given libraries.'
	END
Set NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_DisablePhysicalPruningOnLibraryList')
	delete from GxQscripts where name = 'QS_DisablePhysicalPruningOnLibraryList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_DisablePhysicalPruningOnLibraryList')
	delete from GXDBVersions where aliasname = 'QS_DisablePhysicalPruningOnLibraryList'
GO

insert into GXDBVersions values(2, 'QS_DisablePhysicalPruningOnLibraryList',  '00000000000000000000', 'QS_DisablePhysicalPruningOnLibraryList', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_DisablePhysicalPruningOnLibraryList',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 	qoperation execscript -sn DisablePhysicalPruningOnLibraryList -si <LibraryList FilePath>'
)
GO

