

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_DenyListUserGroup.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  QS_DenyListUserGroup()
--  | Description:  Allows to set or remove denied flag on user group
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_DenyListUserGroup.sp,v $ $Id: QS_DenyListUserGroup.sp,v 1.1.2.1 2020/09/24 14:33:39 jswaminathan Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_DenyListUserGroup')
BEGIN
	print '>>> Drop Stored Procedure: QS_DenyListUserGroup <<<'
	drop procedure QS_DenyListUserGroup
END
IF EXISTS (select * from GxQscripts where name='QS_DenyListUserGroup')
	delete from GxQscripts where name = 'QS_DenyListUserGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_DenyListUserGroup')
	delete from GXDBVersions where aliasname = 'QS_DenyListUserGroup'
GO
print '... Creating Procedure: QS_DenyListUserGroup'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_DenyListUserGroup
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--QScript Usage. Do not use special char in HTML
  @userGroupName NVARCHAR(256),
  @denyList NVARCHAR(256)
AS
SET NOCOUNT ON
DECLARE @errorCode    INTEGER
DECLARE @errorString	NVARCHAR(1024)
DECLARE @canManageProvider INT
BEGIN TRY
	-- local variables
	DECLARE @nowTime AS integer = dbo.GetUnixTime (GetUTCdate())
	DECLARE @providerId INTEGER
	DECLARE @providerName NVARCHAR(1024)
	DECLARE @userGroupId INTEGER
	DECLARE @ownerCompany INTEGER
	DECLARE @grpFlags INTEGER
	--INSERT/UPDATE Operation
	BEGIN
		SET @errorCode = 0
		SET @errorString = 'Successful'
        -- USER VALIDATION
		--Existence of table and fetching of top 1 userId is done for safety measures
		IF OBJECT_ID('tempdb.dbo.#tempQSUser') IS NULL
		BEGIN
			SET @errorCode = 1
			SET @errorString = 'No logged in user found.'
			goto   SCRIPT_EXIT
		END
		DECLARE @userId INT
		SET @userId = 0
		SET @userId =  ISNULL( (select TOP 1 userId from #tempQSUser),0)
		IF @userId = 0
		BEGIN
			SET @errorCode = 2
			SET @errorString = 'No logged in user found.'
			goto   SCRIPT_EXIT
		END
		--Input validation and assignation--
		--1. Null and empty check
		IF(@userGroupName IS NULL OR @userGroupName = N'' )
		BEGIN
			SET @errorCode = 3
			SET @errorString = 'Invalid user group name.'
			GOTO SCRIPT_EXIT
		END
		--2. Checking if organization is passed
		IF CHARINDEX('\',@userGroupName) > 0
		BEGIN
			SELECT @providerName = RTRIM(LTRIM(Substring(@userGroupName,0,CHARINDEX('\',@userGroupName))))
			SELECT @userGroupName = RTRIM(LTRIM(Substring(@userGroupName,CHARINDEX('\',@userGroupName)+1,LEN(@userGroupName))))
			SET @providerId = ISNULL((SELECT umdsProviderId FROM UMGroups WHERE umdsProviderId in (SELECT id FROM UMDSProviders  WITH(NOLOCK)  WHERE domainName = @providerName) AND name = @userGroupName),-1)
			IF @providerId <> -1
			BEGIN
				SET @ownerCompany = dbo.AppGetCompanyForProvider(@providerId)
EXEC sec_checkPermissionOnEntity  @userId, 1, @canManageProvider OUTPUT, 61, @ownerCompany
				IF @canManageProvider <> 1
				BEGIN
					set @errorCode = 4
					set @errorString = 'Logged in user does not have rights to modify user group settings for Company.'
					GOTO SCRIPT_EXIT
				END
				SET @userGroupId = ISNULL((SELECT id FROM UMGroups WHERE umdsProviderId = @providerId AND name = @userGroupName),-1)
			END
		END
		ELSE
		BEGIN
EXEC sec_checkPermissionOnEntity @userId, 1 /*EV_SCHEDULE_ADMIN*/, @canManageProvider OUTPUT, 1 /*COMMCELL_ENTITY*/, 2
            IF @canManageProvider <> 1
            BEGIN
                set @errorCode = 4
                set @errorString = 'Logged in user does not have rights to modify user group settings.'
                GOTO SCRIPT_EXIT
            END
			SET @userGroupId = ISNULL((SELECT id FROM UMGroups WHERE name = @userGroupName AND umdsProviderId = 0 ),-1)
		END
            IF @userGroupId <> -1
            BEGIN
                SET @grpFlags = (SELECT groupFlags FROM UMGroups WHERE  id = @userGroupId)
                IF RTRIM(LTRIM(@denylist)) = N'1'
                BEGIN
SET @grpFlags = (@grpFlags | CAST(0x20000 AS INTEGER))
                END
                ELSE IF RTRIM(LTRIM(@denylist)) = N'0'
                BEGIN
SET @grpFlags = (@grpFlags & ~CAST(0x20000 AS INTEGER))
                END
                UPDATE  UMGroups  SET groupFlags = @grpFlags
                 WHERE  id = @userGroupId
            END
            ELSE
            BEGIN
                SET @errorCode = 6
                SET @errorString = 'User group not found, please specify domain if applicable Ex:[Domain\Group Name]'
                GOTO SCRIPT_EXIT
            END
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    set @errorCode = ERROR_NUMBER()
    set @errorString = ERROR_MESSAGE()
END CATCH
SCRIPT_EXIT:
PRINT ' completed at '
            + Convert(varchar(60), getdate())
            + ' with Parameters: ['+@userGroupName+'], ['+@denyList+']. Execution('+ @errorString +').'
IF @errorCode <> 0
BEGIN
  RAISERROR(@errorString,
                15,  --Severity (> 10 to force DOS Error Code = 1)
                1    --State
                )
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_DenyListUserGroup')
	delete from GxQscripts where name = 'QS_DenyListUserGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_DenyListUserGroup')
	delete from GXDBVersions where aliasname = 'QS_DenyListUserGroup'
GO

insert into GXDBVersions values(2, 'QS_DenyListUserGroup',  '00010001000200010000', 'QS_DenyListUserGroup', '00010001000200010000')
GO

insert into GxQscripts values(2+8,'QS_DenyListUserGroup',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '    To deny a user group belonging to commcell
'
 + CHAR(10) + '    Example: qoperation execscript -sn DenyListUserGroup.sql -si "userGroupName" -si 1
'
 + CHAR(10) + '    To deny a user group belonging to organization
'
 + CHAR(10) + '    Example: qoperation execscript -sn DenyListUserGroup.sql -si "Domain\userGroupName" -si 1
'
 + CHAR(10) + '    To allow a user group belonging to commcell
'
 + CHAR(10) + '    Example: qoperation execscript -sn DenyListUserGroup.sql -si "userGroupName" -si 0
'
 + CHAR(10) + '    To allow a user group belonging to organization
'
 + CHAR(10) + '    Example: qoperation execscript -sn DenyListUserGroup.sql -si "Domain\userGroupName" -si 0
'
)
GO

