

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_DeleteVirtualMachineGUIDs.sp] ---------- 

SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_DeleteVirtualMachineGUIDs <<<'

IF EXISTS (select * from sysobjects where name='QS_DeleteVirtualMachineGUIDs')
	drop procedure QS_DeleteVirtualMachineGUIDs
IF EXISTS (select * from GxQscripts where name='QS_DeleteVirtualMachineGUIDs')
	delete from GxQscripts where name = 'QS_DeleteVirtualMachineGUIDs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_DeleteVirtualMachineGUIDs')
	delete from GXDBVersions where aliasname = 'QS_DeleteVirtualMachineGUIDs'
GO
print '... Creating Procedure: QS_DeleteVirtualMachineGUIDs'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_DeleteVirtualMachineGUIDs
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @clientName nvarchar(2048) = N''
AS
Set NOCOUNT ON
DECLARE @NoParameter	nvarchar(10)
SET     @NoParameter	=N''
DECLARE @scriptName NVARCHAR(100)
SET @scriptName = N'QS_DeleteVirtualMachineGUIDs'
DECLARE @errorCode int
SET @errorCode = 0
DECLARE @errorString NVARCHAR(1024)
SET @errorString = N'Succeeded'
DECLARE @CommCellNumber		INTEGER = 0
DECLARE @Authenticate		INTEGER = 0
-----------------------invalid parameters------------------------------
IF(@clientName = @NoParameter )
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error: client name parameter is required.'
	GOTO SCRIPT_EXIT
END
------------------------------------------------------------------------
-----------------Validation of client---------------------
DECLARE @ClientID AS int
SET @ClientID = ISNULL((SELECT id FROM APP_Client WHERE name = @clientname),0)
IF @ClientID = 0
BEGIN
	SET @errorCode = 2
	SET @errorString = 'Error. Invalid client name [' + @clientname + '] specified.'
	GOTO SCRIPT_EXIT
END
BEGIN TRAN
	BEGIN TRY
		  DELETE FROM app_clientprop where componentNameID = @ClientID and attrName in ( 'Virtual Machine GUID','Virtual Machine Instance UUID')
	END TRY
	BEGIN CATCH
		SET @errorCode = ERROR_NUMBER ()
		SET @errorString = ERROR_MESSAGE ()
        	ROLLBACK TRAN
		GOTO SCRIPT_EXIT
	END CATCH
COMMIT TRAN
SCRIPT_EXIT:
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: ['+@clientName + ']. Exit Code(' +convert(varchar(2), @ErrorCode) + ').'
IF @ErrorCode <> 0
Raiserror(@ErrorString,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_DeleteVirtualMachineGUIDs')
	delete from GxQscripts where name = 'QS_DeleteVirtualMachineGUIDs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_DeleteVirtualMachineGUIDs')
	delete from GXDBVersions where aliasname = 'QS_DeleteVirtualMachineGUIDs'
GO

insert into GXDBVersions values(2, 'QS_DeleteVirtualMachineGUIDs',  '00000000000000000000', 'QS_DeleteVirtualMachineGUIDs', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_DeleteVirtualMachineGUIDs',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn QS_DeleteVirtualMachineGUIDs.sql -si ''clientName'' 
'
 + CHAR(10) + '-- 	script_name: QS_DeleteVirtualMachineGUIDs'
 + CHAR(10) + '-- 	Qscript to delete virtual machine guid and instance UUID client properties. '
 + CHAR(10) + '-- 	This script can be used to delete incorrect instance UUID assigned to the VM client, Next VM Backup job will match the client based on the host name and will assign proper guid and instance UUID values.'
)
GO

