

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_DeleteStaleSnapsforRepset.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_DeleteStaleSnapsforRepset <<<'

IF EXISTS (select * from sysobjects where name='QS_DeleteStaleSnapsforRepset')
	drop procedure QS_DeleteStaleSnapsforRepset
IF EXISTS (select * from GxQscripts where name='QS_DeleteStaleSnapsforRepset')
	delete from GxQscripts where name = 'QS_DeleteStaleSnapsforRepset'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_DeleteStaleSnapsforRepset')
	delete from GXDBVersions where aliasname = 'QS_DeleteStaleSnapsforRepset'
GO
print '... Creating Procedure: QS_DeleteStaleSnapsforRepset'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_DeleteStaleSnapsforRepset
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @PARAM1 varchar(1024) = '%s'
AS
Set NOCOUNT ON
-------------------------------------------
-- INPUT :
-------------------------------------------
--DECLARE @PARAM1	varchar(1024)
--SET		@PARAM1 = '%s'
---- Convenience Definitions    -----------
DECLARE @scriptName	varchar(32)
SET	@scriptName	= 'DeleteStaleSnapsForRepset'
DECLARE @NoParameter varchar(4)
SET     @NoParameter            ='%'                        -- Get Around QScript Parameter
SET     @NoParameter            =@NoParameter + 's'         -- .. Substitution
-----------------------error handling----
DECLARE @errorCode int
SET @errorCode = 0
DECLARE @errorString NVARCHAR(1024)
SET @errorString = ''
---------------------------------------
--test
--SET		@PARAM1= '674'
---------------------------------------
IF @PARAM1 = @NoParameter
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Repset id is not provided.'
	GOTO ARGS_ERROR
END
declare @RepSetId  INT
set @RepSetId = CONVERT(INT, @PARAM1)
BEGIN
	DECLARE @sRepId				nvarchar(128)
	DECLARE @sQuery				nvarchar(1024)
--begin transaction
IF object_id('tempdb.dbo.#cvTempSnaps') IS NOT Null DROP TABLE #cvTempSnaps
CREATE table #cvTempSnaps( nSnapID int, nRPID int)  -- to keep the snap id and RPIDs to be deleted
-- figure out the sna[s to be deleted
DECLARE @Quote nvarchar(4)
SET @Quote = ''''
set @sRepId	= CAST(@RepSetId  as nvarchar(128))
-- Do not delete fan in Rps
set @sQuery = ' select id, consistencyPointId from QRFLRSnapShot where consistencyPointId  in ( select id from QRFLRConsistencyPoint where FLRSetid = ' + @sRepId + ' and type <> 1 )'
insert into #cvTempSnaps EXEC dbo.sp_executesql @sQuery
begin transaction
-- delete netwrok shares of concerned mount points of snaps to be deleted
delete QRFLRSnapNetworkshare where mountPointId in( select id from QRFLRSnapMountPoint where SnapshotId in ( select nSnapID from #cvTempSnaps ))
-- Now delete entries from QRFLRSnapMountPoint
delete QRFLRSnapMountPoint where SnapshotId in ( select nSnapID from #cvTempSnaps )
-- we have one more dependency for QRFLRSnapShot on QRFLRSnapPair. deleing entries from it
delete QRFLRSnapPair where snapshotid in  ( select nSnapID from #cvTempSnaps )
-- now we can remove entries from QRFLRSnapshot
delete QRFLRSnapShot where id in   ( select nSnapID from #cvTempSnaps )
-- finally remove all CP info from DB
delete QRFLRConsistencypoint where id in (select DISTINCT nRPID from #cvTempSnaps)
commit transaction
-- Now delete the temo table
delete #cvTempSnaps
END_PROC:
--rollback transaction
END
ARGS_ERROR:
print @scriptName + ' completed at '	+ Convert(varchar(60), getdate())+'. ErrorCode ('+	Convert(varchar(2),@errorCode) +').'
if @errorCode <> 0
	Raiserror(@errorString,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_DeleteStaleSnapsforRepset')
	delete from GxQscripts where name = 'QS_DeleteStaleSnapsforRepset'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_DeleteStaleSnapsforRepset')
	delete from GXDBVersions where aliasname = 'QS_DeleteStaleSnapsforRepset'
GO

insert into GXDBVersions values(2, 'QS_DeleteStaleSnapsforRepset',  '00000000000000000000', 'QS_DeleteStaleSnapsforRepset', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_DeleteStaleSnapsforRepset',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	Qoperation execscript -sn DeleteStaleSnapsForRepset.sql -si RepsetId
'
 + CHAR(10) + '--   script_name : DeleteStaleSnapsforRepset'
)
GO

