

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_DeleteSearchEngineNode.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_DeleteSearchEngineNode.sp,v $ $Id: QS_DeleteSearchEngineNode.sp,v 1.3.60.3 2019/09/29 00:32:33 pankajkumar Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_DeleteSearchEngineNode')
BEGIN
	print '>>> Drop Stored Procedure: QS_DeleteSearchEngineNode <<<'
	drop procedure QS_DeleteSearchEngineNode
END
IF EXISTS (select * from GxQscripts where name='QS_DeleteSearchEngineNode')
	delete from GxQscripts where name = 'QS_DeleteSearchEngineNode'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_DeleteSearchEngineNode')
	delete from GXDBVersions where aliasname = 'QS_DeleteSearchEngineNode'
GO
print '... Creating Procedure: QS_DeleteSearchEngineNode'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_DeleteSearchEngineNode
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- SP Input Params
  @NodeclientName nvarchar(1024)
AS
Set NOCOUNT ON
------------ Convenience Definitions    -----------
	DECLARE @scriptName	varchar(64)
	SET		@scriptName	= 'QS_DeleteSearchEngineNode'
	DECLARE @lastError	integer
	SET		@lastError	= 0
	DECLARE @localErrorMsg		varchar(512)
	SET		@localErrorMsg			='Successful.'
	DECLARE @now				integer
	SET @now = dbo.GetUnixTime(GETUTCDATE())
	DECLARE @NoParameter		varchar(4)
	SET     @NoParameter            ='%'                        -- Get Around QScript Parameter
	SET     @NoParameter            =@NoParameter + 's'         -- .. Substitution
	DECLARE @clientId INT
	DECLARE @noOfNodesInCloud INT
------------------------Check if node client exists or not------------------------
	IF NOT EXISTS(SELECT * FROM APP_Client WHERE name=@NodeclientName )
	BEGIN
		SET @lastError = 2
		SET @localErrorMsg = 'Error. Node client ['+CAST(@NodeclientName AS VARCHAR(64))+'] does not exists.'
		GOTO PROC_ERROR
	END
	SET @clientId = ISNULL((SELECT id FROM APP_Client WHERE name=@NodeclientName),0)
	SET @noOfNodesInCloud = (
							SELECT COUNT(*) FROM APP_ComponentProp with (nolock)
							WHERE componentId in
								( SELECT componentId from APP_ComponentProp  with (nolock) where longVal= @clientId
									and propertyTypeId=1008 AND modified = 0
								)
							and propertyTypeId=1008 AND modified = 0
							)
	IF @noOfNodesInCloud = 0
	BEGIN
		SET @lastError = 3
		SET @localErrorMsg = 'Error. Search engine node is not installed on the client ['+CAST(@NodeclientName AS VARCHAR(64))+'].'
		GOTO PROC_ERROR
	END
	IF @noOfNodesInCloud = 1
	BEGIN
		SET @lastError = 4
		SET @localErrorMsg = 'Error. Only one search engine node is present in the cloud. Cannot delete node ['+CAST(@NodeclientName AS VARCHAR(64))+']. Please delete the Search Engine cloud instead.'
		GOTO PROC_ERROR
	END
BEGIN TRY
BEGIN TRAN
------------------------Delete all associated entries for the specified node------------------------
IF EXISTS (SELECT * FROM archContentIndexingRestart WHERE ciEngineClientId = @clientId)
BEGIN
	DELETE FROM archContentIndexingRestart WHERE ciEngineClientId = @clientId
	IF (@@ERROR <> 0)
	BEGIN
		SET @lastError = @@ERROR
		SET @localErrorMsg = 'Failed to delete rows from archContentIndexingRestart.'
		GOTO ERROR_EXIT
	END
END
IF EXISTS (SELECT * FROM DM2SearchServerCoreInfo WHERE clientId = @clientId)
BEGIN
	DELETE FROM DM2SearchServerCoreInfo WHERE clientId = @clientId
	IF (@@ERROR <> 0)
	BEGIN
		SET @lastError = @@ERROR
		SET @localErrorMsg = 'Failed to delete rows from DM2SearchServerCoreInfo.'
		GOTO ERROR_EXIT
	END
END
IF EXISTS (SELECT * FROM APP_clientProp WHERE componentNameId = @clientId AND (attrName like 'FAST%' OR attrName IN ('CLOUD_ID','CLOUD_TYPE')))
BEGIN
	DELETE FROM APP_clientProp WHERE componentNameId = @clientId AND (attrName like 'FAST%' OR attrName IN ('CLOUD_ID','CLOUD_TYPE'))
	IF (@@ERROR <> 0)
	BEGIN
		SET @lastError = @@ERROR
		SET @localErrorMsg = 'Failed to delete rows from APP_clientProp.'
		GOTO ERROR_EXIT
	END
END
IF EXISTS (SELECT * FROM APP_componentProp WHERE propertyTypeId = 1008 AND longVal = @clientId)
BEGIN
	DELETE FROM APP_ComponentProp WHERE (propertyTypeId = 1008 AND longVal = @clientId)
			or (componentType = 3
					AND (componentId in (select id from APP_ComponentProp  with (nolock) where propertyTypeId = 1008 and longVal =@clientId)
						OR 	(componentId = @clientId AND propertyTypeId IN (1025, 1026, 1027, 1028) )
					)
				)
	IF (@@ERROR <> 0)
	BEGIN
		SET @lastError = @@ERROR
		SET @localErrorMsg = 'Failed to delete rows from APP_componentProp.'
		GOTO ERROR_EXIT
	END
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @lastError = @@error
	SET @localErrorMsg = (SELECT ERROR_MESSAGE())
	goto PROC_ERROR
END CATCH
ERROR_EXIT:
IF @lastError <> 0
	ROLLBACK TRAN
ELSE
	COMMIT TRAN
PROC_ERROR:
	PRINT ''
	PRINT @scriptName + ' completed at '
					+ Convert(varchar(60), getdate())+' with parameters '
					+ 'Client ['+ @NodeclientName + '].'
					+ ' ErrorCode (' + Convert(varchar(2),@lastError) +').'
	if @lastError <> 0
		Raiserror(@localErrorMsg,
					15,  --Severity (> 10 to force DOS Error Code = 1)
					1	 --State
					)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_DeleteSearchEngineNode')
	delete from GxQscripts where name = 'QS_DeleteSearchEngineNode'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_DeleteSearchEngineNode')
	delete from GXDBVersions where aliasname = 'QS_DeleteSearchEngineNode'
GO

insert into GXDBVersions values(2, 'QS_DeleteSearchEngineNode',  '00010003006000030000', 'QS_DeleteSearchEngineNode', '00010003006000030000')
GO

insert into GxQscripts values(2,'QS_DeleteSearchEngineNode',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn QS_DeleteSearchEngineNode -si ''NodeclientName''
'
 + CHAR(10) + '    Example: qoperation execscript -sn QS_DeleteSearchEngineNode -si solr56 -si 970168066
'
 + CHAR(10) + '	script_name: QS_DeleteSearchEngineNode.
'
 + CHAR(10) + '	NodeclientName - Delete the Search Engine Node from multi-node cloud.
'
)
GO

