

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_DeleteScheduleTemplate.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_DeleteScheduleTemplate <<<'

IF EXISTS (select * from sysobjects where name='QS_DeleteScheduleTemplate')
	drop procedure QS_DeleteScheduleTemplate
IF EXISTS (select * from GxQscripts where name='QS_DeleteScheduleTemplate')
	delete from GxQscripts where name = 'QS_DeleteScheduleTemplate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_DeleteScheduleTemplate')
	delete from GXDBVersions where aliasname = 'QS_DeleteScheduleTemplate'
GO
print '... Creating Procedure: QS_DeleteScheduleTemplate'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_DeleteScheduleTemplate
--QScript is enabled
--Set Audit Level:  NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--Qscript usage. Use no special char in HTML
--SP Input Params
  @schedName varchar(1024) = '%s'
AS
Set NOCOUNT ON
-------------------------------------------
-- INPUT :
-------------------------------------------
--DECLARE @schedName       varchar(1024)
--SET	@schedName         = '%s'
--SET	@schedName         = 'Mypolicy'
---------------------------------------
--test
--SET		@schedName	= 'Mypolicy'
---------------------------------------
------------ Convenience Definitions    -----------
DECLARE @scriptName	varchar(32)
SET		@scriptName	= 'DeleteScheduleTemplate'
DECLARE @NoParameter varchar(4)
SET     @NoParameter            ='%'                        -- Get Around QScript Parameter
SET     @NoParameter            =@NoParameter + 's'         -- .. Substitution
DECLARE @nowTime	integer
SET     @nowTime	= dbo.GetUnixTime (GetUTCdate())
DECLARE @lastError				integer
SET     @lastError  = 0									-- Be optimistic
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
----------------------- check inputs -----------------
IF @schedName = @NoParameter
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. Schedule policy name Expected as parameter 1.'
	GOTO ARGS_ERROR
END
------------ validate subclient id ----------------
DECLARE @taskId INT = 0
DECLARE @flags INT = 0
SELECT @taskId = ISNULL(taskId, 0), @flags = ISNULL(flags, 0) FROM TM_Task WHERE taskName COLLATE Latin1_General_CS_AS = @schedName and taskType = 4
IF @taskId = 0
BEGIN
	SET @lastError = 1
	SET @localErrorMsg = 'Error. Schedule Policy [' +@schedName +'] not found.'
	GOTO ARGS_ERROR
END
IF @flags&4 > 0
BEGIN
	SET @lastError = 2
	SET @localErrorMsg = 'Error. System created schedule policy cannot be deleted.'
	GOTO ARGS_ERROR
END
BEGIN TRAN
	UPDATE TM_Task SET deleted = 1 WHERE taskId = @taskId
TRANS_EXIT:
IF @lastError <> 0
	ROLLBACK TRAN
ELSE
	COMMIT TRAN
ARGS_ERROR:
PRINT ''
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: ['+@schedName+
         + ']. Exit Code(' +convert(varchar(2), @lastError) + ').'
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_DeleteScheduleTemplate')
	delete from GxQscripts where name = 'QS_DeleteScheduleTemplate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_DeleteScheduleTemplate')
	delete from GXDBVersions where aliasname = 'QS_DeleteScheduleTemplate'
GO

insert into GXDBVersions values(2, 'QS_DeleteScheduleTemplate',  '00000000000000000000', 'QS_DeleteScheduleTemplate', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_DeleteScheduleTemplate',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn DeleteScheduleTemplate.sql -si schedulepolicy_name
'
 + CHAR(10) + '--   script_name : DeleteScheduleTemplate'
)
GO

