

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_DeleteOrphanDatasourcesForCloud.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='QS_DeleteOrphanDatasourcesForCloud')
BEGIN
	print '>>> Drop Stored Procedure: QS_DeleteOrphanDatasourcesForCloud <<<'
	drop procedure QS_DeleteOrphanDatasourcesForCloud
END
IF EXISTS (select * from GxQscripts where name='QS_DeleteOrphanDatasourcesForCloud')
	delete from GxQscripts where name = 'QS_DeleteOrphanDatasourcesForCloud'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_DeleteOrphanDatasourcesForCloud')
	delete from GXDBVersions where aliasname = 'QS_DeleteOrphanDatasourcesForCloud'
GO
print '... Creating Procedure: QS_DeleteOrphanDatasourcesForCloud'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure QS_DeleteOrphanDatasourcesForCloud
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- SP Input Params
  @i_CloudId INT = 0,
  @i_NodeClientId INT = 0
AS
Set NOCOUNT ON
------------ Convenience Definitions -----------
    DECLARE @scriptName varchar(64)
    SET     @scriptName = 'QS_DeleteOrphanDatasourcesForCloud'
    DECLARE @lastError  integer
    SET     @lastError  = 0
    DECLARE @localErrorMsg      varchar(512)
    SET     @localErrorMsg          ='Successful.'
    IF OBJECT_ID('tempdb.dbo.#datasourceIdsTbl') IS NOT NULL
        DROP TABLE #datasourceIdsTbl
    CREATE TABLE #datasourceIdsTbl (
        dsId   INT
    )
------------ Check if cloudId is valid -----------
    IF @i_CloudId = 0
    BEGIN
        SET @lastError = 2
        SET @localErrorMsg = 'Error. Cloud id not provided'
        GOTO PROC_ERROR
    END
    IF EXISTS(SELECT 1 FROM DM2Cloud DMC WITH(NOLOCK) WHERE DMC.cloudId = @i_CloudId)
    BEGIN
        IF @i_NodeClientId = 0
        BEGIN
            SET @lastError = 3
            SET @localErrorMsg = 'Error. This is a valid index server'
            GOTO PROC_ERROR
        END
        ELSE IF @i_NodeClientId <> 0 AND EXISTS(SELECT 1 FROM DM2Cloud DMC WITH(NOLOCK), DM2SearchServerCoreInfo DMS WITH(NOLOCK)  WHERE DMC.cloudId = DMS.CloudId AND DMC.cloudId = @i_CloudId AND DMS.ClientId = @i_NodeClientId)
        BEGIN
            SET @lastError = 4
            SET @localErrorMsg = 'Error. This is a valid index server node'
            GOTO PROC_ERROR
        END
    END
------------ Delete file indexing association at client, subclient & backupset level ------------
    INSERT INTO #datasourceIdsTbl
    SELECT DISTINCT DS.DataSourceId
    FROM SEDataSource DS WITH (NOLOCK)
    INNER JOIN SECollectionInfo C WITH (NOLOCK) ON DS.CoreId = C.CoreId AND C.CloudID = @i_CloudId AND (@i_NodeClientId = 0 OR ClientId = @i_NodeClientId)
    DELETE APP_ClientProp WHERE attrName = 'indexing datasource id' AND attrval IN (SELECT dsId FROM #datasourceIdsTbl)
    DELETE APP_subclientProp WHERE attrName = 'indexing datasource id' AND attrval IN (SELECT dsId FROM #datasourceIdsTbl)
    DELETE APP_BackupSetProp WHERE attrName = 'indexing datasource id' AND attrval IN (SELECT dsId FROM #datasourceIdsTbl)
------------ Delete data sources for given cloudId ------------
    DECLARE @rowCount   integer
    DELETE FROM SECollectionInfo
    WHERE CloudID = @i_CloudId AND (@i_NodeClientId = 0 OR ClientId = @i_NodeClientId)
    SET @rowCount = (SELECT @@ROWCOUNT)
PROC_ERROR:
    IF OBJECT_ID('tempdb.dbo.#datasourceIdsTbl') IS NOT NULL
        DROP TABLE #datasourceIdsTbl
    PRINT ''
    PRINT @scriptName + ' completed at '
                    + Convert(varchar(60), getdate())+' with parameters'
                    + ' CloudId ['+ Convert(varchar(8), @i_CloudId) + '].'
                    + ' NodeClientId ['+ Convert(varchar(8), @i_NodeClientId) + '].'
                    + ' ErrorCode (' + Convert(varchar(2),@lastError) +').'
                    + ' Deleted rows (' + Convert(varchar(4),@rowCount) +').'
    if @lastError <> 0
        Raiserror(@localErrorMsg,
                    15,  --Severity (> 10 to force DOS Error Code = 1)
                    1    --State
                    )
GO

IF EXISTS (select * from GxQscripts where name = 'QS_DeleteOrphanDatasourcesForCloud')
	delete from GxQscripts where name = 'QS_DeleteOrphanDatasourcesForCloud'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_DeleteOrphanDatasourcesForCloud')
	delete from GXDBVersions where aliasname = 'QS_DeleteOrphanDatasourcesForCloud'
GO

insert into GXDBVersions values(2, 'QS_DeleteOrphanDatasourcesForCloud',  '00000000000000000000', 'QS_DeleteOrphanDatasourcesForCloud', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_DeleteOrphanDatasourcesForCloud',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '    qoperation execscript -sn QS_DeleteOrphanDatasourcesForCloud -si CloudId -si NodeClientId
'
 + CHAR(10) + '    Example: qoperation execscript -sn QS_DeleteOrphanDatasourcesForCloud -si 2 -si 5
'
 + CHAR(10) + '    script_name: QS_DeleteOrphanDatasourcesForCloud.
'
 + CHAR(10) + '    CloudId - The cloudId of the index server.
'
 + CHAR(10) + '    NodeClientId - The client id of the index server node.
'
)
GO

