

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_DeleteMultipleClientsNetworkConfiguration.sp] ---------- 

--  +========================================================================+
--  |                Name:  QS_DeleteMultipleClientsNetworkConfiguration
--  | Description:  Clears all Network Configuration for the clients in
--  |				the specified group
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_DeleteMultipleClientsNetworkConfiguration.sp,v $ $Id: QS_DeleteMultipleClientsNetworkConfiguration.sp,v 1.1.2.1 2019/10/30 17:46:42 sneralla Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_DeleteMultipleClientsNetworkConfiguration')
BEGIN
	print '>>> Drop Stored Procedure: QS_DeleteMultipleClientsNetworkConfiguration <<<'
	drop procedure QS_DeleteMultipleClientsNetworkConfiguration
END
IF EXISTS (select * from GxQscripts where name='QS_DeleteMultipleClientsNetworkConfiguration')
	delete from GxQscripts where name = 'QS_DeleteMultipleClientsNetworkConfiguration'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_DeleteMultipleClientsNetworkConfiguration')
	delete from GXDBVersions where aliasname = 'QS_DeleteMultipleClientsNetworkConfiguration'
GO
print '... Creating Procedure: QS_DeleteMultipleClientsNetworkConfiguration'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_DeleteMultipleClientsNetworkConfiguration
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--QScript Usage. Do not use special char in HTML
  @param1 NVARCHAR(260)
AS
SET NOCOUNT ON
DECLARE @errorCode              INTEGER
DECLARE @errorString            NVARCHAR(1024)
DECLARE @canManage              INTEGER
DECLARE @clientgroupName        NVARCHAR(256)
DECLARE @clientgroupId          INTEGER = 0
DECLARE @weStartedTransaction   INTEGER = 0
BEGIN TRY
    BEGIN
        SET @errorCode = 0
        SET @errorString = 'Successful'
		IF (@param1 IS NULL) OR (@param1 = '') OR (@param1 NOT LIKE 'cg=%')
            BEGIN
                SET @ErrorCode = 1
                SET @ErrorString = 'Invalid parameters : Please refer usage (cg=clientgroupName)'
                GOTO SCRIPT_EXIT
            END
            ELSE
            BEGIN
				-- USER VALIDATION
				--Existence of table and fetching of top 1 userId is done for safety measures
				IF OBJECT_ID('tempdb.dbo.#tempQSUser') IS NULL
				BEGIN
					SET @errorCode = 2
					SET @errorString = 'No logged in user found.'
					goto   SCRIPT_EXIT
				END
				DECLARE @userId INT
				SET @userId = 0
				SET @userId =  ISNULL( (select TOP 1 userId from #tempQSUser),0)
				IF @userId = 0
				BEGIN
					SET @errorCode = 2
					SET @errorString = 'No logged in user found.'
					goto   SCRIPT_EXIT
				END
                SET @clientgroupName = SUBSTRING(@param1,LEN('cg=')+1,LEN(@param1)-LEN('cg='))
                SET @ClientgroupId = ISNULL((SELECT id FROM APP_ClientGroup WHERE name = @clientgroupName),0)
                IF @ClientgroupId = 0
                BEGIN
                    SET @ErrorCode = 3
                    SET @ErrorString = 'Error. Invalid clientgroup [' + @clientgroupName + '] specified.'
                    GOTO SCRIPT_EXIT
                END
EXEC sec_checkPermissionOnEntity  @userId, 1, @canManage OUTPUT, 28, @clientgroupId
                IF @canManage <> 1
                BEGIN
                    set @errorCode = 4
                    set @errorString = 'Logged in user does not have rights to set property for clientgroup'
                    GOTO SCRIPT_EXIT
                END
				IF @@TRANCOUNT = 0
				BEGIN
					BEGIN TRANSACTION ThisSPInitiatedTransaction
					SET @weStartedTransaction = 1
				END
				-- Delete the required network information
				DECLARE @clients TABLE (clientId INT PRIMARY KEY)
				INSERT INTO @clients
				SELECT clientId
				FROM APP_ClientGroupAssoc WHERE clientGroupId=@clientgroupId
				-- App_Firewall routes (Network incoming section in Java console)
				DELETE AF
				FROM APP_Firewall AF
				INNER JOIN @clients C
				ON AF.clientId=C.clientId
				DELETE AF
				FROM APP_Firewall AF
				INNER JOIN @clients C
				ON AF.forClientId=C.clientId
				-- App_FWOutGoingRoutes (Network outgoing routes section in Java console)
				DELETE AFOR
				FROM App_FWOutGoingRoutes AFOR
				INNER JOIN @clients C
				ON AFOR.clientId=C.clientId
				DELETE AFOR
				FROM App_FWOutGoingRoutes AFOR
				INNER JOIN @clients C
				ON AFOR.forClientId=C.clientId
				-- The client can be a proxy in one of the outgoing routes
				DELETE AFOR
				FROM App_FWOutGoingRoutes AFOR
				CROSS APPLY AFOR.fwOutGoingRouteOptions.nodes('/App_FireWallOutGoingRouteOptions/remoteProxy') Options(proxyGroupId)
				INNER JOIN @clients C
				ON proxyGroupId.value('@clientId', 'integer')=C.clientId
				-- Firewall Additional ports
				DELETE AFWR
				FROM APP_FWPortRange AFWR
				INNER JOIN @clients C
				ON AFWR.clientId=C.clientId
				-- DIPs
				DELETE APL
				FROM archPipeline APL
				INNER JOIN @clients C
				ON APL.srcClientId=C.clientId
				DELETE APL
				FROM archPipeline APL
				INNER JOIN @clients C
				ON APL.destClientId=C.clientId
				-- Firewall Options
				DELETE AFO
				FROM App_FirewallOptions AFO
				INNER JOIN @clients C
				ON AFO.clientId=C.clientId
				-- Firewall Trivial Configuration
				DELETE AFTC
				FROM App_FWTrivialConfig AFTC
				INNER JOIN @clients C
				ON AFTC.clientId=C.clientId
				DELETE AFTC
				FROM App_FWTrivialConfig AFTC
				WHERE AFTC.proxyClientIdCS IN (SELECT clientId FROM @clients) OR AFTC.proxyClientIdMA IN (SELECT clientId FROM @clients)
				-- Network Throttle
				DELETE ANTO
				FROM APP_NetworkThrottleOptions ANTO
				INNER JOIN @clients C
				ON ANTO.clientId=C.clientId
				DELETE ANT
				FROM APP_NetworkThrottle ANT
				INNER JOIN @clients C
				ON ANT.clientId=C.clientId
            END
    END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    set @errorCode = ERROR_NUMBER()
    set @errorString = ERROR_MESSAGE()
END CATCH
SCRIPT_EXIT:
IF @weStartedTransaction = 1
BEGIN
    IF @errorCode=0
        COMMIT TRAN ThisSPInitiatedTransaction
    ELSE
        ROLLBACK TRAN ThisSPInitiatedTransaction
END
PRINT ' completed at '
            + Convert(varchar(60), getdate())
            + ' with Parameters: ['+@param1+']. Execution('+ @errorString +').'
IF @errorCode <> 0
BEGIN
  RAISERROR(@errorString,
                15,  --Severity (> 10 to force DOS Error Code = 1)
                1    --State
                )
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_DeleteMultipleClientsNetworkConfiguration')
	delete from GxQscripts where name = 'QS_DeleteMultipleClientsNetworkConfiguration'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_DeleteMultipleClientsNetworkConfiguration')
	delete from GXDBVersions where aliasname = 'QS_DeleteMultipleClientsNetworkConfiguration'
GO

insert into GXDBVersions values(2, 'QS_DeleteMultipleClientsNetworkConfiguration',  '00010001000200010000', 'QS_DeleteMultipleClientsNetworkConfiguration', '00010001000200010000')
GO

insert into GxQscripts values(2+8,'QS_DeleteMultipleClientsNetworkConfiguration',  1, GETDATE(), GETDATE(), '' + CHAR(10) + '    To delete network configuration of clients in a group
'
 + CHAR(10) + '    Example: qoperation execscript  -sn QS_DeleteMultipleClientsNetworkConfiguration.sql -si cg=ClientGroupName
'
)
GO

