

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_DeleteMediaFromList.sp] ---------- 

-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_DeleteMediaFromList')
BEGIN
	print '>>> Drop Stored Procedure: QS_DeleteMediaFromList <<<'
	drop procedure QS_DeleteMediaFromList
END
IF EXISTS (select * from GxQscripts where name='QS_DeleteMediaFromList')
	delete from GxQscripts where name = 'QS_DeleteMediaFromList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_DeleteMediaFromList')
	delete from GXDBVersions where aliasname = 'QS_DeleteMediaFromList'
GO
print '... Creating Procedure: QS_DeleteMediaFromList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_DeleteMediaFromList
--Stored procedure inputs
  @FilePath NVARCHAR(1024) = N''
AS
SET NOCOUNT ON
DECLARE @CommcellNumber INTEGER = 0
DECLARE @Authenticate   INTEGER = 0
DECLARE @ScriptName     NVARCHAR(32) = N'QS_DeleteMediaFromList'
DECLARE @Barcode 		NVARCHAR(1024) = N''
DECLARE @MediaId 		INTEGER = 0
DECLARE @SQLString 		NVARCHAR(MAX) = N''
DECLARE @retCode 		INTEGER = 0
DECLARE @TempErrorNumber    INTEGER = 0
DECLARE @ErrorNumber INTEGER = 0
DECLARE @ErrorMessage   NVARCHAR(MAX) = N''
DECLARE @DeleteSuccessList TABLE (BarCode NVARCHAR(1024))
DECLARE @DeleteFailedList TABLE (BarCode NVARCHAR(1024),errorCode INT, errorString NVARCHAR(MAX))
DECLARE @bMediaDeleteSuccess INTEGER = 0
DECLARE @bMediaDeleteFailed INTEGER = 0
IF @FilePath = N''	-- If input file path not passed
BEGIN
        SET @ErrorMessage = N'Input file path not passed, Need to pass file path which has list of barcode need to be delete.'
        SET @ErrorNumber = 1
        GOTO ERROR_EXIT
END
DECLARE @isDAEnabled INTEGER
SET @isDAEnabled = dbo.isDataAgingActivityEnabled(2)
IF (@isDAEnabled = 0)
BEGIN
		SET @ErrorMessage = N'DataAging activity is not enabled. Please enable and try again.'
        SET @ErrorNumber = 1
        GOTO ERROR_EXIT
END
IF OBJECT_ID('tempdb..#BarCodeList') IS NOT NULL
	DROP TABLE #BarCodeList
CREATE TABLE #BarCodeList(BarCode NVARCHAR(1024))
SET @SQLString= 'BULK INSERT #BarCodeList FROM '''+ @FilePath +''' WITH (ROWTERMINATOR = ''\n'')'
EXEC sp_executesql @SQLString
IF  @@ERROR > 0
BEGIN
	SET @ErrorMessage = N'ERROR: Please check whether file path is valid -- bulk insert error.'
	SET @ErrorNumber = 1
	GOTO ERROR_EXIT
END
IF OBJECT_ID('tempdb..#tmpResutSetForMMS2DeleteMediaByMediaId') IS NOT NULL
	DROP TABLE #tmpResutSetForMMS2DeleteMediaByMediaId
CREATE TABLE #tmpResutSetForMMS2DeleteMediaByMediaId(retCode INT, errorString NVARCHAR(MAX))
DECLARE BarcodeListCur CURSOR FOR
SELECT DISTINCT BarCode FROM #BarcodeList WHERE BarCode IS NOT NULL
OPEN BarcodeListCur
FETCH NEXT FROM BarcodeListCur INTO @BarCode
WHILE @@FETCH_STATUS = 0
BEGIN
	IF LTRIM(RTRIM(@BarCode)) <> 'CV_MAGNETIC'
	BEGIN
		SET @MediaId = ISNULL((SELECT MediaId FROM MMMedia WHERE BarCode=LTRIM(RTRIM(@BarCode))),0)
		IF @MediaId = 0
		BEGIN
			SET @ErrorMessage = N'Invalid barcode['+@BarCode+'].'
			SET @ErrorNumber = 1
			SET @bMediaDeleteFailed = 1
			INSERT INTO @DeleteFailedList SELECT @BarCode, @ErrorNumber, @ErrorMessage
			SET @ErrorMessage= N'Failed to delete some of the media which are mentioned in the file ['+@FilePath+'].'
		END
		ELSE
		BEGIN
			IF EXISTS (SELECT * FROM MMResource(NOLOCK) WHERE MediaId = @MediaId)
			BEGIN
				DECLARE @JobId INTEGER
				SELECT TOP 1 @JobId = JobId_l FROM MMResourceToJob R2JOB, MMResource R WHERE R.MediaId = @MediaId AND R.ReservationId = R2JOB.ReservationId
				SET @ErrorMessage = N'Media['+@BarCode+'] reserved by job['+CONVERT(NVARCHAR(1024), @JobId)+'].'
				SET @ErrorNumber = 1
				SET @bMediaDeleteFailed = 1
				INSERT INTO @DeleteFailedList SELECT @BarCode, @ErrorNumber, @ErrorMessage
				SET @ErrorMessage= N'Failed to delete some of the media which are mentioned in the file ['+@FilePath+'].'
			END
			ELSE
			BEGIN
				BEGIN TRANSACTION TRAN_DELETE_MEDIA
				DELETE FROM #tmpResutSetForMMS2DeleteMediaByMediaId
				SET @retCode = 0
				EXEC MMS2DeleteMEdiaByMediaId @MediaId
				SELECT top 1 @retCode = retCode, @ErrorMessage = errorString FROM #tmpResutSetForMMS2DeleteMediaByMediaId
				IF @retCode <> 0
				BEGIN
					SET @bMediaDeleteFailed = 1
					INSERT INTO @DeleteFailedList SELECT @BarCode,@retCode,@ErrorMessage
					SET @ErrorNumber = 1
					SET @ErrorMessage  = N'Failed to delete some of the media which are mentioned in the file ['+@FilePath+'].'
					IF @@TRANCOUNT > 0
						ROLLBACK TRANSACTION TRAN_DELETE_MEDIA
				END
				ELSE
				BEGIN
					SET @bMediaDeleteSuccess = 1
					INSERT INTO @DeleteSuccessList SELECT @BarCode
					IF @@TRANCOUNT > 0
						COMMIT TRANSACTION TRAN_DELETE_MEDIA
				END
			END
		END
	END
	ELSE
	BEGIN
		SET @ErrorMessage = N'Invalid barcode['+@BarCode+']. Please try to delete only tape media.'
		SET @ErrorNumber = 1
		SET @bMediaDeleteFailed = 1
		INSERT INTO @DeleteFailedList SELECT @BarCode, @ErrorNumber, @ErrorMessage
		SET @ErrorMessage= N'Failed to delete some of the media which are mentioned in the file ['+@FilePath+'].'
	END
	FETCH NEXT FROM BarcodeListCur INTO @Barcode
END
CLOSE BarcodeListCur
DEALLOCATE BarcodeListCur
IF @bMediaDeleteSuccess = 0 AND @bMediaDeleteFailed = 1
BEGIN
	SET @ErrorMessage= N'Failed to delete all the media which are mentioned in the file ['+@FilePath+'].'
	SET @ErrorNumber = 1
	GOTO ERROR_EXIT
END
-- GUI AUDIT
DECLARE @UserId 	INTEGER = 1  --- Admin
DECLARE @opMsgId    INTEGER
DECLARE @opEvMsgId  INTEGER
DECLARE @opId       INTEGER
DECLARE @paramMsgId INTEGER
DECLARE @SuccessMediaList NVARCHAR(MAX) = N''
-- SET GUI AUDIT OPERATION
SET @opMsgId = (51 | (CAST(POWER(2, 24) AS BIGINT) * 84))
EXEC EvGuiAuditSetOperation @opMsgId, @UserId, @opEvMsgId OUTPUT, @opId OUTPUT
IF @@ERROR != 0
BEGIN
	SET @ErrorMessage= N'Failed to audit delete media operation by script DeleteMediaFromList.'
	SET @ErrorNumber = 2
	GOTO ERROR_EXIT
END
-- SET GUI AUDIT PARAMETER
SET @paramMsgId  = (468 | (CAST(POWER(2, 24) AS BIGINT) * 85))
EXEC EvGuiAuditSetParamData @opId, @ScriptName, 0
IF @@ERROR != 0
BEGIN
	SET @ErrorMessage= N'Failed to audit delete media operation by script ' + @ScriptName
	SET @ErrorNumber = 2
	GOTO ERROR_EXIT
END
EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @UserId
IF @@ERROR != 0
BEGIN
	SET @ErrorMessage = N'Failed to audit delete media operation by script ' + @ScriptName
	SET @ErrorNumber  = 2
	GOTO ERROR_EXIT
END
SET @paramMsgId = (5 | (CAST(POWER(2, 24) AS BIGINT) * 85))
IF @bMediaDeleteSuccess = 1
BEGIN
	SELECT @SuccessMediaList = coalesce(@SuccessMediaList + ', ',' ') + BarCode FROM @DeleteSuccessList
	SET @SuccessMediaList = N'List of deleted media - ' + @SuccessMediaList
	EXEC EvGuiAuditSetParamData @opId, @SuccessMediaList, 0
	IF @@ERROR != 0
	BEGIN
		SET @ErrorMessage= N'Failed to audit delete media operation by script ' + @ScriptName
		SET @ErrorNumber = 2
		GOTO ERROR_EXIT
	END
	EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @UserId
	IF @@ERROR != 0
	BEGIN
		SET @ErrorMessage = N'Failed to audit delete media operation by script ' + @ScriptName
		SET @ErrorNumber  = 2
		GOTO ERROR_EXIT
	END
END
ERROR_EXIT:
	IF OBJECT_ID('tempdb..#tmpResutSetForMMS2DeleteMediaByMediaId') IS NOT NULL
		DROP TABLE #tmpResutSetForMMS2DeleteMediaByMediaId
	IF OBJECT_ID('tempdb..#BarCodeList') IS NOT NULL
		DROP TABLE #BarCodeList
	IF @bMediaDeleteFailed = 1
		SELECT Barcode + ' - Error: ' + CONVERT(VARCHAR(10), errorCode) + ', Message: ' + errorString AS 'Failed to delete barcode list' FROM @DeleteFailedList
	IF @ErrorNumber <> 0
		SELECT @ErrorMessage
	ELSE
		SELECT 'Successfully deleted list of media which are mentioned in the file ['+@FilePath+'].'
	DELETE @DeleteFailedList
	DELETE @DeleteSuccessList
GO

IF EXISTS (select * from GxQscripts where name = 'QS_DeleteMediaFromList')
	delete from GxQscripts where name = 'QS_DeleteMediaFromList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_DeleteMediaFromList')
	delete from GXDBVersions where aliasname = 'QS_DeleteMediaFromList'
GO

insert into GXDBVersions values(2, 'QS_DeleteMediaFromList',  '00000000000000000000', 'QS_DeleteMediaFromList', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_DeleteMediaFromList',  1, GETDATE(), GETDATE(), '' + CHAR(10) + '--   QOperation execscript -sn QS_DeleteMediaFromList -si BarCodeListFilePath'
)
GO

