

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_DeleteFASTDanglingRow.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_DeleteFASTDanglingRow.sp,v $ $Id: QS_DeleteFASTDanglingRow.sp,v 1.3.60.2 2018/03/22 01:42:39 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_DeleteFASTDanglingRow <<<'

IF EXISTS (select * from sysobjects where name='QS_DeleteFASTDanglingRow')
	drop procedure QS_DeleteFASTDanglingRow
IF EXISTS (select * from GxQscripts where name='QS_DeleteFASTDanglingRow')
	delete from GxQscripts where name = 'QS_DeleteFASTDanglingRow'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_DeleteFASTDanglingRow')
	delete from GXDBVersions where aliasname = 'QS_DeleteFASTDanglingRow'
GO
print '... Creating Procedure: QS_DeleteFASTDanglingRow'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_DeleteFASTDanglingRow
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- SP Input Params
  @NodeclientName nvarchar(1024),
  @AuthCode NVARCHAR(64)
AS
Set NOCOUNT ON
------------ Convenience Definitions    -----------
	DECLARE @scriptName	varchar(64)
	SET		@scriptName	= 'QS_DeleteFASTDanglingRow'
	DECLARE @lastError	integer
	SET		@lastError	= 0
	DECLARE @localErrorMsg		varchar(512)
	SET		@localErrorMsg			='Successful.'
	DECLARE @now				integer
	SET @now = dbo.GetUnixTime(GETUTCDATE())
	DECLARE @NoParameter		varchar(4)
	SET     @NoParameter            ='%'                        -- Get Around QScript Parameter
	SET     @NoParameter            =@NoParameter + 's'         -- .. Substitution
	DECLARE @clientId INT
	DECLARE @noOfNodesInCloud INT
	DECLARE @CommCellNumber		INTEGER = 0
	DECLARE @Authenticate		INTEGER = 0
------------------------Check if node client exists or not------------------------
	IF NOT EXISTS(SELECT TOP 1 * FROM APP_Client WHERE name=@NodeclientName )
	BEGIN
		SET @lastError = 1
		SET @localErrorMsg = 'Error. Node client ['+CAST(@NodeclientName AS VARCHAR(64))+'] does not exists.'
		GOTO PROC_ERROR
	END
	SET @clientId = ISNULL((SELECT id FROM APP_Client WHERE name=@NodeclientName),0)
	IF @clientId = 0
	BEGIN
		SET @localErrorMsg = N'Invalid Client. Please provide correct client name.'
		SET @lastError = 2
		GOTO PROC_ERROR
	END
	SELECT @CommCellNumber = number from APP_CommCell where id = 2
	IF @AuthCode = N'%s' --IF Authentication code is not passed
	BEGIN
		SET @localErrorMsg = N'No Authorization code passed. Authorization code required.'
		SET @lastError = 3
		GOTO PROC_ERROR
	END
	ELSE
	BEGIN
		SET @Authenticate = CONVERT(INTEGER, @AuthCode)
		IF ((CHECKSUM(HASHBYTES('SHA1', '<' + @ScriptName + '><' + CAST(@clientId AS VARCHAR(100)) + '><' + CAST(@CommCellNumber AS VARCHAR(100)) + '><COMMVAULT>')) & 2147483646) <> @Authenticate)
		BEGIN
			SET @localErrorMsg = N'Wrong Authorization code passed [' + @AuthCode + '].'
			SET @lastError = 4
			GOTO PROC_ERROR
		END
	END
BEGIN TRY
BEGIN TRAN
------------------------Delete all associated entries for the specified node------------------------
DECLARE @cloudId INT
SET @cloudId = ISNULL((SELECT CAST(attrval AS INT) FROM APP_ClientProp WHERE componentNameId= @clientId AND modified = 0 AND attrname = 'CLOUD_ID'),0)
IF @cloudId != 0
BEGIN
	IF EXISTS (SELECT * FROM archContentIndexingRules WHERE cloudId = @cloudId)
	BEGIN
		DELETE FROM archContentIndexingRules WHERE cloudId = @cloudId
		IF (@@ERROR <> 0)
		BEGIN
			SET @lastError = @@ERROR
			SET @localErrorMsg = 'Failed to delete rows from archContentIndexingRules.'
			GOTO ERROR_EXIT
		END
	END
	IF EXISTS (SELECT * FROM archContentIndexingAged WHERE cloudId = @cloudId)
	BEGIN
		DELETE FROM archContentIndexingAged WHERE cloudId = @cloudId
		IF (@@ERROR <> 0)
		BEGIN
			SET @lastError = @@ERROR
			SET @localErrorMsg = 'Failed to delete rows from archContentIndexingAged.'
			GOTO ERROR_EXIT
		END
	END
	IF EXISTS (SELECT * FROM archContentIndexingRestart WHERE cloudId = @cloudId)
	BEGIN
		DELETE FROM archContentIndexingRestart WHERE cloudId = @cloudId
		IF (@@ERROR <> 0)
		BEGIN
			SET @lastError = @@ERROR
			SET @localErrorMsg = 'Failed to delete rows from archContentIndexingRestart.'
			GOTO ERROR_EXIT
		END
	END
	IF EXISTS (SELECT * FROM APP_componentProp WHERE Id = @cloudId OR componentId = @cloudId)
	BEGIN
		DELETE FROM APP_ComponentProp WHERE Id = @cloudId OR componentId = @cloudId
		IF (@@ERROR <> 0)
		BEGIN
			SET @lastError = @@ERROR
			SET @localErrorMsg = 'Failed to delete rows from APP_componentProp.'
			GOTO ERROR_EXIT
		END
	END
END
IF EXISTS (SELECT * FROM APP_clientProp WHERE componentNameId = @clientId AND (attrName like 'FAST%' OR attrName IN ('CLOUD_ID','CLOUD_TYPE', 'Content Index Server')))
BEGIN
	DELETE FROM APP_clientProp WHERE componentNameId = @clientId AND (attrName like 'FAST%' OR attrName IN ('CLOUD_ID','CLOUD_TYPE','Content Index Server'))
	IF (@@ERROR <> 0)
	BEGIN
		SET @lastError = @@ERROR
		SET @localErrorMsg = 'Failed to delete rows from APP_clientProp.'
		GOTO ERROR_EXIT
	END
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @lastError = @@error
	SET @localErrorMsg = (SELECT ERROR_MESSAGE())
	goto PROC_ERROR
END CATCH
ERROR_EXIT:
IF @lastError <> 0
	ROLLBACK TRAN
ELSE
	COMMIT TRAN
PROC_ERROR:
	PRINT ''
	PRINT @scriptName + ' completed at '
					+ Convert(varchar(60), getdate())+' with parameters '
					+ 'Client ['+ @NodeclientName + '].'
					+ ' ErrorCode (' + Convert(varchar(2),@lastError) +').'
	if @lastError <> 0
		Raiserror(@localErrorMsg,
					15,  --Severity (> 10 to force DOS Error Code = 1)
					1	 --State
					)
GO

IF EXISTS (select * from GxQscripts where name = 'QS_DeleteFASTDanglingRow')
	delete from GxQscripts where name = 'QS_DeleteFASTDanglingRow'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_DeleteFASTDanglingRow')
	delete from GXDBVersions where aliasname = 'QS_DeleteFASTDanglingRow'
GO

insert into GXDBVersions values(2, 'QS_DeleteFASTDanglingRow',  '00010003006000020000', 'QS_DeleteFASTDanglingRow', '00010003006000020000')
GO

insert into GxQscripts values(2,'QS_DeleteFASTDanglingRow',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn QS_DeleteFASTDanglingRow -si ''NodeclientName'' -si AuthenticationCode
'
 + CHAR(10) + '    Example: qoperation execscript -sn QS_DeleteFASTDanglingRow -si solr56 -si 970168066
'
 + CHAR(10) + '	script_name: QS_DeleteFASTDanglingRow.
'
 + CHAR(10) + '	NodeclientName - Delete dangling rows from Commserv database for which FAST cloud is already deleted.
'
 + CHAR(10) + '	AuthenticationCode - Authentication Code.
'
)
GO

