

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_DeleteDataSet.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_DeleteDataSet.sp,v $ $Id: QS_DeleteDataSet.sp,v 1.3.178.2 2018/03/22 01:12:49 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_DeleteDataSet <<<'

IF EXISTS (select * from sysobjects where name='QS_DeleteDataSet')
	drop procedure QS_DeleteDataSet
IF EXISTS (select * from GxQscripts where name='QS_DeleteDataSet')
	delete from GxQscripts where name = 'QS_DeleteDataSet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_DeleteDataSet')
	delete from GXDBVersions where aliasname = 'QS_DeleteDataSet'
GO
print '... Creating Procedure: QS_DeleteDataSet'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_DeleteDataSet
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- Stored Procedure Inputs
  @PARAM1 varchar(1024) = '',
  @PARAM2 varchar(1024) = ''
AS
Set NOCOUNT ON
/*Input variables*/
DECLARE @i_DataSetId INT = 0
DECLARE @i_Authenticate INT
/*Locale variables*/
DECLARE @l_commCellNumber INT
DECLARE @ErrorString	VARCHAR(1000) = ''
DECLARE @ErrorCode		INT = 0
/************Queries to generate Authentication code***************
--please copy this commented code and run in sql studio
DECLARE @i_DataSetId INT = 0
DECLARE @l_commCellNumber INT
SELECT @l_commCellNumber = number from APP_CommCell where id = 2
select
(checksum(HASHBYTES('SHA1','<'+CAST(@l_commCellNumber AS VARCHAR(100))+'><DeleteDataSet><'+CAST(@i_DataSetId AS VARCHAR(100))+'><COMMVAULT>')) & 2147483646)+1
*/
---- Convenience Definitions    -----------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'DeleteDataSet'
DECLARE @lastError				integer
SET		@lastError				= 0
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
DECLARE @NoParameter			varchar(10)
SET     @NoParameter			=''
IF (@PARAM1 = @NoParameter OR @PARAM2 = @NoParameter) --Requires minimum 2 params
BEGIN
	SET @ErrorString	=	'Error: Insufficient command line parameters. Please refer to the readme file and retry with necessary parameters'
	SET	@ErrorCode		=	1
	GOTO SCRIPT_EXIT
END
SELECT @l_commCellNumber = number from APP_CommCell where id = 2
SET @i_DataSetId = convert(INT, @PARAM1)
SELECT	@ErrorCode = @@ERROR
IF (@ErrorCode <> 0)
BEGIN
	SET @ErrorString	=	'Error: Invalid DataSet ID'
	SET	@ErrorCode		=	5
	GOTO SCRIPT_EXIT
END
/*
 -- Remove comments to test
 SET @PARAM2 = CAST(((checksum(HASHBYTES('SHA1','<'+CAST(@l_commCellNumber AS VARCHAR(100))+'><DeleteDataSet><'+CAST(@i_DataSetId AS VARCHAR(100))+'><COMMVAULT>')) & 2147483646)+1) AS VARCHAR)
*/
SET @i_Authenticate = convert(INT, @PARAM2)
IF (((checksum(HASHBYTES('SHA1','<'+CAST(@l_commCellNumber AS VARCHAR(100))+'><DeleteDataSet><'+CAST(@i_DataSetId AS VARCHAR(100))+'><COMMVAULT>')) & 2147483646)+1) <> @i_Authenticate)
BEGIN
	SET @ErrorString	=	'Error: Incorrect Authentication code passed'
	SET	@ErrorCode		=	2
	GOTO SCRIPT_EXIT
END
DECLARE @jobList TABLE(SPID int, SPCID int, JobID int, CommCellId int)
INSERT INTO @jobList
SELECT	DISTINCT J.archGrpId, J.archGrpCopyId, J.jobId, J.commCellId
FROM	SMDataSetToSubClientMap D WITH (NOLOCK),
		SMCopyToRelationMap R WITH (NOLOCK),
		JMJobDataStats J  WITH (NOLOCK)
WHERE	D.DataSetId = @i_DataSetId
		AND D.ControlHostId = R.ControlHostId
		AND D.SMRelationId = R.SMRelationId
		AND J.appId = D.AppId
		AND R.ArchGroupCopyId = J.archGrpCopyId
		AND J.status = 100
		AND J.disabled & 256 = 0
IF NOT EXISTS ( SELECT * FROM SMDataSetToSubClientMap
				WHERE	DataSetId = @i_DataSetId)
BEGIN
	SET @ErrorString	=	'Error: Incorrect DataSet ID passed '
	SET	@ErrorCode		=	3
	GOTO SCRIPT_EXIT
END
DELETE FROM SMDataSetToSubClientMap
WHERE	DataSetId = @i_DataSetId
SELECT	@ErrorCode = @@ERROR
IF (@ErrorCode <> 0)
BEGIN
	SET @ErrorString	=	'Error: Deleting DataSet ID'
	SET	@ErrorCode		=	4
	GOTO SCRIPT_EXIT
END
-- List all jobs that are affected
SELECT 'Following jobs may not be restorable due to DataSet deletion'
SELECT '------------------------------------------------------------'
SELECT ' '
SELECT	AG.name AS 'Storage Policy',
		AGC.name AS 'Storage Policy Copy',
		J.JobID AS 'JobId',
		J.CommCellId AS 'CommCellId'
FROM	@jobList J
			LEFT OUTER JOIN archGroup AG WITH (NOLOCK) ON J.SPID = AG.id
			LEFT OUTER JOIN archGroupCopy AGC WITH (NOLOCK) ON J.SPCID = AGC.id
SCRIPT_EXIT:
IF @ErrorCode <> 0
	Raiserror(@ErrorString,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
set nocount off
GO

IF EXISTS (select * from GxQscripts where name = 'QS_DeleteDataSet')
	delete from GxQscripts where name = 'QS_DeleteDataSet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_DeleteDataSet')
	delete from GXDBVersions where aliasname = 'QS_DeleteDataSet'
GO

insert into GXDBVersions values(2, 'QS_DeleteDataSet',  '00010003017800020000', 'QS_DeleteDataSet', '00010003017800020000')
GO

insert into GxQscripts values(2,'QS_DeleteDataSet',  1, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 		With AuthCode:-'
 + CHAR(10) + '-- 			qoperation execscript -sn DeleteDataSet -si <DATASETID> -si <authentication_code> '
)
GO

