

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_DeleteContainer.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_DeleteContainer.sp,v $ $Id: QS_DeleteContainer.sp,v 1.2.204.3 2018/03/27 08:55:16 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_DeleteContainer <<<'

IF EXISTS (select * from sysobjects where name='QS_DeleteContainer')
	drop procedure QS_DeleteContainer
IF EXISTS (select * from GxQscripts where name='QS_DeleteContainer')
	delete from GxQscripts where name = 'QS_DeleteContainer'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_DeleteContainer')
	delete from GXDBVersions where aliasname = 'QS_DeleteContainer'
GO
print '... Creating Procedure: QS_DeleteContainer'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_DeleteContainer
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- SP Input Params
  @i_userName NVARCHAR(512) = '',
  @i_containerName NVARCHAR(MAX) = '',
  @i_containerType INT = 0
AS
Set NOCOUNT ON
DECLARE @o_errorMessage NVARCHAR(MAX) = ''
	--input Validation
	--
	IF( LEN(ISNULL(@i_userName,'')) = 0)
	BEGIN
		SELECT @o_errorMessage = ' UserName not provided '
		GOTO EXIT_SP;
	END
	IF( LEN(ISNULL(@i_containerName,'')) = 0)
	BEGIN
		SELECT @o_errorMessage = ' ContainerName not provided '
		GOTO EXIT_SP;
	END
	--local variables
	DECLARE @entityType INT = 0 --ReviewSet = 9501,	QuerySet = 9502, DownloadSet = 9503
	DECLARE @userId INT = 0
	DECLARE @containerId INT = 0
	--Get userId
	--
	--Since the user can also be deleted.
	--Input can be either user name or with deleted name
	--eg: ROBO\compuser3(Deleted,12) OR ROBO\compuser3
	--Check if exact input name matches the login name
	--
	SELECT @userId = id FROM UMUsers WHERE login = @i_userName
	--Check renamed login ie., name of format (ROBO\compuser3(Deleted,12))
	--
	IF(@userId = 0 )
		SELECT @userId = id FROM UMUsers
		WHERE ( CHARINDEX('(Deleted,'+ CAST(id AS VARCHAR(50))+')' ,login) > 0 AND
				@i_userName = LEFT(login,CHARINDEX('(Deleted,'+ CAST(id AS VARCHAR(50))+')' ,login) - 1 ) )
	IF(@userId = 0)
	BEGIN
		SELECT @o_errorMessage = ' UserId could not be found for the input user name. ' + @i_userName
		GOTO EXIT_SP;
	END
	--Get the container Type
	--
	--Default or value =1 is ReviewSet entity type
	IF(@i_containerType = 0 OR @i_containerType = 1)
		SET @entityType = 9501
	--Query Set
	ELSE IF(@i_containerType = 2)
		SET @entityType = 9502
	--Download OR Export Set
	ELSE IF (@i_containerType = 3)
		SET @entityType = 9503
	ELSE
	BEGIN
		SELECT @o_errorMessage = 'Invalid Container Type. Input Type : ' + CAST(@i_containerType AS VARCHAR(50))
		GOTO EXIT_SP;
	END
	--Check if container exists
	--
	SELECT @containerId = C.containerId FROM DM2Container AS C
	WHERE C.containerName = @i_containerName AND C.userId = @userId AND C.containerType = @entityType
	--Crude way to find out "My ReviewSet" deletion for enduser
	--Bcoz, for enduser display name will be "My DocumentSet" but actual CS stored name will be "My ReviewSet"
	--
	IF(@containerId = 0 AND @i_containerName = 'My DocumentSet' AND @entityType = 9501)
	BEGIN
		DECLARE @t_userCaps 		TABLE (caps bigint)
		INSERT INTO @t_userCaps
		EXECUTE GetUserCapabilities @userId
		DECLARE @userCaps 			bigint = 0
		SET @userCaps = ISNULL((SELECT TOP(1) caps FROM @t_userCaps), 0)
		--check for enduser capability
		--ENDUSER_SEARCH 24
		IF ( @userCaps & CONVERT(bigint, (POWER(2.0, 24-1))) <> 0)
		BEGIN
			SELECT @containerId = C.containerId FROM DM2Container AS C
			WHERE C.containerName = 'My ReviewSet' AND C.userId = @userId AND C.containerType = @entityType
		END
	END
	IF( @containerId = 0)
	BEGIN
		SELECT @o_errorMessage = ' Container Name could not be found. Input Name : ' + @i_containerName
		GOTO EXIT_SP
	END
	ELSE
	BEGIN
		IF(@@error > 0)
		BEGIN
			SELECT @o_errorMessage = ERROR_MESSAGE();
			GOTO EXIT_SP
		END
		delete FROM DM2Container WHERE containerId = @containerId
		IF(@@error > 0)
		BEGIN
			SELECT @o_errorMessage = ERROR_MESSAGE();
			GOTO EXIT_SP
		END
		SELECT @o_errorMessage = ' Container [' + @i_containerName + '] deleted successfully'
	END;
EXIT_SP:
	SELECT @o_errorMessage
GO

IF EXISTS (select * from GxQscripts where name = 'QS_DeleteContainer')
	delete from GxQscripts where name = 'QS_DeleteContainer'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_DeleteContainer')
	delete from GXDBVersions where aliasname = 'QS_DeleteContainer'
GO

insert into GXDBVersions values(2, 'QS_DeleteContainer',  '00010002020400030000', 'QS_DeleteContainer', '00010002020400030000')
GO

insert into GxQscripts values(2,'QS_DeleteContainer',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 	To delete container belonging to ReviewSet/Export/Query Set Type '
 + CHAR(10) + '-- 	qoperation execscript -sn DeleteContainer -si ''UserName'' -si ''ContainerName'' -si  ''ContainerType'''
 + CHAR(10) + '-- 	''UserName'' -- Owner of the container that needs to be deleted. '
 + CHAR(10) + '-- 	''ContainerName'' -- Name of the container that needs to be deleted.[excluding the username]'
 + CHAR(10) + '-- 	''ContainerType'' -- Optional. Type of the container that needs to be deleted. Can be 1,2 or 3. Default  ReviewSet.  [1 - ReviewSet  ; 2  QuerySet  ; 3 - DownloadSet]'
 + CHAR(10) + '-- 	Eg: To delete Review Set [ PEKO(Deleted, 59)@efgz\My ReviewSet ] whose owner is [efgz\PEKO]'
 + CHAR(10) + '-- 	Run as : qoperation execscript -sn DeleteContainer -si ''efgz\PEKO'' -si ''My ReviewSet'' -si 1'
)
GO

